/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.ContractRegistry;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.xml.XElem;
import obix.xml.XException;
import obix.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObixDecoder
extends XParser {
    private boolean useContracts;
    private HashMap fragIds;
    private HashMap fragRefs;

    public static Obj fromString(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            ObixDecoder obixDecoder = new ObixDecoder(byteArrayInputStream);
            return obixDecoder.decodeDocument();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public boolean getUseContracts() {
        return this.useContracts;
    }

    public void setUseContracts(boolean bl) {
        this.useContracts = bl;
    }

    public Obj decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj decodeDocument(boolean bl) throws Exception {
        Obj obj;
        block2: {
            try {
                XElem xElem = this.parse();
                Obj obj2 = this.decode(null, xElem, null);
                this.warningsForUnresolvedFragRefs();
                obj = obj2;
                Object var3_5 = null;
                if (!bl) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_6 = null;
                    if (!bl) break block3;
                    this.close();
                }
                throw throwable;
            }
            this.close();
        }
        return obj;
    }

    private final Obj decode(Obj obj, XElem xElem, Contract contract) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = null;
        Object object5 = null;
        Object object6 = null;
        Object object7 = null;
        Object object8 = null;
        Object object9 = null;
        Object object10 = null;
        Object object11 = null;
        Object object12 = null;
        Object object13 = null;
        Object object14 = null;
        Object object15 = null;
        Object object16 = null;
        Object object17 = null;
        Object object18 = null;
        Object object19 = null;
        Object object20 = null;
        Object object21 = null;
        Object object22 = null;
        int n = xElem.attrSize();
        int n2 = 0;
        while (n2 < n) {
            object4 = xElem.attrName(n2);
            object3 = xElem.attrValue(n2);
            if (((String)object4).equals("name")) {
                string = object3;
            } else if (((String)object4).equals("val")) {
                object5 = object3;
            } else if (((String)object4).equals("href")) {
                object6 = object3;
            } else if (((String)object4).equals("is")) {
                object7 = object3;
            } else if (((String)object4).equals("of")) {
                object8 = object3;
            } else if (((String)object4).equals("in")) {
                object9 = object3;
            } else if (((String)object4).equals("out")) {
                object10 = object3;
            } else if (((String)object4).equals("display")) {
                object11 = object3;
            } else if (((String)object4).equals("displayName")) {
                object12 = object3;
            } else if (((String)object4).equals("null")) {
                object14 = object3;
            } else if (((String)object4).equals("icon")) {
                object13 = object3;
            } else if (((String)object4).equals("writable")) {
                object15 = object3;
            } else if (((String)object4).equals("status")) {
                object16 = object3;
            } else if (((String)object4).equals("range")) {
                object17 = object3;
            } else if (((String)object4).equals("min")) {
                object18 = object3;
            } else if (((String)object4).equals("max")) {
                object19 = object3;
            } else if (((String)object4).equals("unit")) {
                object20 = object3;
            } else if (((String)object4).equals("precision")) {
                object21 = object3;
            } else if (((String)object4).equals("tz")) {
                object22 = object3;
            }
            ++n2;
        }
        String string2 = xElem.name();
        object4 = Obj.toClass(string2);
        if (object4 == null) {
            System.out.println("WARNING: Unknown element: " + xElem + " [Line " + xElem.line() + ']');
            return null;
        }
        object3 = null;
        if (object7 != null) {
            object3 = this.decodeContract((String)object7, xElem);
        }
        Obj obj2 = null;
        if (obj != null && string != null) {
            obj2 = obj.get(string);
        }
        if (obj2 == null) {
            if (this.useContracts) {
                if (object3 != null) {
                    object4 = ContractRegistry.toClass((Class)object4, (Contract)object3);
                } else if (contract != null) {
                    object4 = ContractRegistry.toClass((Class)object4, contract);
                }
            }
            obj2 = (Obj)((Class)object4).newInstance();
        } else if (!string2.equals(obj2.getElement())) {
            if (string2.equals("ref") || obj2.getElement().equals("obj")) {
                object2 = Obj.toObj(string2);
                if (object2 != null) {
                    ((Obj)object2).setName(string);
                    if (obj2.getParent() != null) {
                        obj2.getParent().replace(obj2, (Obj)object2);
                    }
                    obj2 = object2;
                }
            } else {
                throw this.err("Element name '" + string2 + "' conflicts with contract element '" + obj2.getElement() + '\'', xElem);
            }
        }
        if (string != null && obj2.getName() == null) {
            obj2.setName(string);
        }
        if (object6 != null) {
            if (obj2 instanceof Ref) {
                obj2.setHref(this.decodeRefUri((String)object6, xElem));
            } else {
                this.decodeHref(obj2, (String)object6);
            }
        }
        if (object3 != null) {
            obj2.setIs((Contract)object3);
        }
        if (object5 != null) {
            if (object14 == null) {
                obj2.setNull(false);
            }
            try {
                ((Val)obj2).decodeVal((String)object5);
            }
            catch (Exception exception) {
                throw this.err("Invalid val attribte '" + (String)object5 + "' for " + obj2.getElement(), xElem, exception);
            }
        }
        if (object11 != null) {
            obj2.setDisplay((String)object11);
        }
        if (object12 != null) {
            obj2.setDisplayName((String)object12);
        }
        if (object13 != null) {
            obj2.setIcon(new Uri((String)object13));
        }
        if (object16 != null) {
            obj2.setStatus(Status.parse(object16));
        }
        if (object14 != null) {
            obj2.setNull(((String)object14).equals("true"));
        }
        if (object15 != null) {
            obj2.setWritable(((String)object15).equals("true"));
        }
        object2 = null;
        if (obj2 instanceof List) {
            object = (List)obj2;
            if (object8 != null) {
                object2 = this.decodeContract((String)object8, xElem);
                ((List)object).setOf((Contract)object2);
            }
            if (object18 != null) {
                ((List)object).setMin(Integer.parseInt(object18));
            }
            if (object19 != null) {
                ((List)object).setMax(Integer.parseInt(object19));
            }
        } else if (obj2 instanceof Op) {
            object = (Op)obj2;
            if (object9 != null) {
                ((Op)object).setIn(this.decodeContract((String)object9, xElem));
            }
            if (object10 != null) {
                ((Op)object).setOut(this.decodeContract((String)object10, xElem));
            }
        } else if (obj2 instanceof Bool) {
            object = (Bool)obj2;
            if (object17 != null) {
                ((Bool)object).setRange(this.decodeRefUri((String)object17, xElem));
            }
        } else if (obj2 instanceof Int) {
            object = (Int)obj2;
            if (object18 != null) {
                ((Int)object).setMin(Long.parseLong(object18));
            }
            if (object19 != null) {
                ((Int)object).setMax(Long.parseLong(object19));
            }
            if (object20 != null) {
                ((Int)object).setUnit(this.decodeRefUri((String)object20, xElem));
            }
        } else if (obj2 instanceof Str) {
            object = (Str)obj2;
            if (object18 != null) {
                ((Str)object).setMin(Integer.parseInt(object18));
            }
            if (object19 != null) {
                ((Str)object).setMax(Integer.parseInt(object19));
            }
        } else if (obj2 instanceof Real) {
            object = (Real)obj2;
            if (object18 != null) {
                ((Real)object).setMin(Double.parseDouble((String)object18));
            }
            if (object19 != null) {
                ((Real)object).setMax(Double.parseDouble(object19));
            }
            if (object20 != null) {
                ((Real)object).setUnit(this.decodeRefUri((String)object20, xElem));
            }
            if (object21 != null) {
                ((Real)object).setPrecision(Integer.parseInt(object21));
            }
        } else if (obj2 instanceof Enum) {
            object = (Enum)obj2;
            if (object17 != null) {
                ((Enum)object).setRange(this.decodeRefUri((String)object17, xElem));
            }
        } else if (obj2 instanceof Reltime) {
            object = (Reltime)obj2;
            if (object18 != null) {
                ((Reltime)object).setMin(Reltime.parse((String)object18));
            }
            if (object19 != null) {
                ((Reltime)object).setMax(Reltime.parse((String)object19));
            }
        } else if (obj2 instanceof Abstime) {
            object = (Abstime)obj2;
            if (object18 != null) {
                ((Abstime)object).setMin(Abstime.parse((String)object18));
            }
            if (object19 != null) {
                ((Abstime)object).setMax(Abstime.parse((String)object19));
            }
            if (object22 != null) {
                ((Abstime)object).setTz((String)object22);
            }
        } else if (obj2 instanceof Time) {
            object = (Time)obj2;
            if (object18 != null) {
                ((Time)object).setMin(Time.parse((String)object18));
            }
            if (object19 != null) {
                ((Time)object).setMax(Time.parse((String)object19));
            }
            if (object22 != null) {
                ((Time)object).setTz((String)object22);
            }
        } else if (obj2 instanceof Date) {
            object = (Date)obj2;
            if (object18 != null) {
                ((Date)object).setMin(Date.parse((String)object18));
            }
            if (object19 != null) {
                ((Date)object).setMax(Date.parse((String)object19));
            }
            if (object22 != null) {
                ((Date)object).setTz((String)object22);
            }
        } else if (obj2 instanceof Feed) {
            object = (Feed)obj2;
            if (object9 != null) {
                ((Feed)object).setIn(this.decodeContract((String)object9, xElem));
            }
            if (object8 != null) {
                ((Feed)object).setOf(this.decodeContract((String)object8, xElem));
            }
        }
        object = xElem.elems();
        int n3 = 0;
        while (n3 < ((XElem[])object).length) {
            Obj obj3 = this.decode(obj2, object[n3], (Contract)object2);
            if (obj3 != null && obj3.getParent() == null) {
                try {
                    obj2.add(obj3);
                }
                catch (Exception exception) {
                    throw this.err("Cannot add child '" + string + '\'', (XElem)object[n3], exception);
                }
            }
            ++n3;
        }
        return obj2;
    }

    void decodeHref(Obj obj, String string) {
        Uri uri = new Uri(null, string);
        obj.setHref(uri);
        if (!uri.isFragment()) {
            return;
        }
        this.fragIds.put(string, obj);
        FragRefs fragRefs = (FragRefs)this.fragRefs.get(string);
        if (fragRefs == null) {
            return;
        }
        this.fragRefs.remove(string);
        int n = 0;
        while (n < fragRefs.uris.size()) {
            ((Uri)fragRefs.uris.get(n)).setResolved(obj);
            ++n;
        }
    }

    Uri decodeRefUri(String string, XElem xElem) {
        Uri uri = new Uri(string);
        if (!uri.isFragment()) {
            return uri;
        }
        Obj obj = (Obj)this.fragIds.get(string);
        if (obj != null) {
            uri.setResolved(obj);
            return uri;
        }
        FragRefs fragRefs = (FragRefs)this.fragRefs.get(string);
        if (fragRefs == null) {
            fragRefs = new FragRefs();
            this.fragRefs.put(string, fragRefs);
        }
        fragRefs.uris.add(uri);
        fragRefs.elems.add(xElem);
        return uri;
    }

    Contract decodeContract(String string, XElem xElem) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(this.decodeRefUri(stringTokenizer.nextToken(), xElem));
        }
        return new Contract(arrayList.toArray(new Uri[arrayList.size()]));
    }

    void warningsForUnresolvedFragRefs() {
        FragRefs[] fragRefsArray = this.fragRefs.values().toArray(new FragRefs[this.fragRefs.size()]);
        int n = 0;
        while (n < fragRefsArray.length) {
            FragRefs fragRefs = fragRefsArray[n];
            int n2 = 0;
            while (n2 < fragRefs.uris.size()) {
                Uri uri = (Uri)fragRefs.uris.get(n2);
                XElem xElem = (XElem)fragRefs.elems.get(n2);
                this.warning("Unresolved fragment reference '" + uri + '\'', xElem);
                ++n2;
            }
            ++n;
        }
    }

    XException err(String string, XElem xElem, Throwable throwable) {
        return new XException(string, xElem, throwable);
    }

    XException err(String string, XElem xElem) {
        return new XException(string, xElem);
    }

    void warning(String string, XElem xElem) {
        String string2 = "";
        if (xElem != null) {
            string2 = " [line " + xElem.line() + ']';
        }
        System.out.println("WARNING: " + string + string2);
    }

    private final /* synthetic */ void this() {
        this.useContracts = true;
        this.fragIds = new HashMap();
        this.fragRefs = new HashMap();
    }

    public ObixDecoder(InputStream inputStream) throws Exception {
        super(inputStream);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class FragRefs {
        ArrayList uris;
        ArrayList elems;

        private final /* synthetic */ void this() {
            this.uris = new ArrayList(4);
            this.elems = new ArrayList(4);
        }

        FragRefs() {
            this.this();
        }
    }
}

