/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Err;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BinObixDecoder
extends DataInputStream {
    ArrayList strTable;

    public static Obj fromBytes(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BinObixDecoder binObixDecoder = new BinObixDecoder(byteArrayInputStream);
            return binObixDecoder.decodeDocument();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Obj decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj decodeDocument(boolean bl) throws Exception {
        Obj obj;
        block2: {
            try {
                this.strTable.clear();
                obj = this.decode(this.readUnsignedByte());
                Object var3_3 = null;
                if (!bl) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_4 = null;
                    if (!bl) break block3;
                    this.close();
                }
                throw throwable;
            }
            this.close();
        }
        return obj;
    }

    private final Obj decode(int n) throws Exception {
        Obj obj;
        switch (n & 0x7C) {
            case 4: {
                obj = new Obj();
                break;
            }
            case 8: {
                obj = new Bool(this.readBoolVal(n));
                break;
            }
            case 12: {
                obj = new Int(this.readIntVal(n));
                break;
            }
            case 16: {
                obj = new Real(this.readRealVal(n));
                break;
            }
            case 20: {
                obj = new Str(this.readStrVal(n));
                break;
            }
            case 24: {
                obj = new Enum(this.readStrVal(n));
                break;
            }
            case 32: {
                obj = this.readAbstimeVal(n);
                break;
            }
            case 36: {
                obj = this.readReltimeVal(n);
                break;
            }
            case 44: {
                obj = this.readTimeVal(n);
                break;
            }
            case 40: {
                obj = this.readDateVal(n);
                break;
            }
            case 28: {
                obj = new Uri(this.readStrVal(n));
                break;
            }
            case 48: {
                obj = new List();
                break;
            }
            case 52: {
                obj = new Op();
                break;
            }
            case 56: {
                obj = new Feed();
                break;
            }
            case 60: {
                obj = new Ref();
                break;
            }
            case 64: {
                obj = new Err();
                break;
            }
            default: {
                throw new IOException("Invalid object code 0x" + Integer.toHexString(n));
            }
        }
        boolean bl = false;
        while ((n & 0x80) != 0) {
            n = this.readUnsignedByte();
            switch (n & 0x7C) {
                case 4: {
                    bl = true;
                    break;
                }
                case 8: {
                    obj.setName(this.readStrVal(n));
                    break;
                }
                case 12: {
                    obj.setHref(new Uri(this.readStrVal(n)));
                    break;
                }
                case 16: {
                    obj.setIs(this.readContractVal(n));
                    break;
                }
                case 76: 
                case 80: {
                    obj.setStatus(this.readStatusVal(n));
                    break;
                }
                case 44: {
                    obj.setDisplay(this.readStrVal(n));
                    break;
                }
                case 40: {
                    obj.setDisplayName(this.readStrVal(n));
                    break;
                }
                case 36: {
                    obj.setIcon(new Uri(this.readStrVal(n)));
                    break;
                }
                case 32: {
                    obj.setNull(this.readBoolVal(n));
                    break;
                }
                case 48: {
                    obj.setWritable(this.readBoolVal(n));
                    break;
                }
                case 20: {
                    this.readOf(obj, n);
                    break;
                }
                case 24: {
                    this.readIn(obj, n);
                    break;
                }
                case 28: {
                    this.readOut(obj, n);
                    break;
                }
                case 52: {
                    this.readMin(obj, n);
                    break;
                }
                case 56: {
                    this.readMax(obj, n);
                    break;
                }
                case 68: {
                    this.readRange(obj, n);
                    break;
                }
                case 60: {
                    this.readUnit(obj, n);
                    break;
                }
                case 64: {
                    this.readPrecision(obj, n);
                    break;
                }
                case 72: {
                    this.readTz(obj, n);
                    break;
                }
                default: {
                    throw new IOException("Invalid facet code 0x" + Integer.toHexString(n));
                }
            }
        }
        if (bl) {
            while ((n = this.readUnsignedByte()) != 68) {
                Obj obj2 = this.decode(n);
                obj.add(obj2);
            }
        }
        return obj;
    }

    private final void readOf(Obj obj, int n) throws IOException {
        Contract contract = this.readContractVal(n);
        switch (obj.getBinCode()) {
            case 48: {
                ((List)obj).setOf(contract);
                break;
            }
            case 56: {
                ((Feed)obj).setOf(contract);
                break;
            }
            default: {
                throw new IOException("Invalid 'of' facet on " + obj.getElement());
            }
        }
    }

    private final void readIn(Obj obj, int n) throws IOException {
        Contract contract = this.readContractVal(n);
        switch (obj.getBinCode()) {
            case 52: {
                ((Op)obj).setIn(contract);
                break;
            }
            case 56: {
                ((Feed)obj).setIn(contract);
                break;
            }
            default: {
                throw new IOException("Invalid 'in' facet on " + obj.getElement());
            }
        }
    }

    private final void readOut(Obj obj, int n) throws IOException {
        Contract contract = this.readContractVal(n);
        switch (obj.getBinCode()) {
            case 52: {
                ((Op)obj).setOut(contract);
                break;
            }
            default: {
                throw new IOException("Invalid 'out' facet on " + obj.getElement());
            }
        }
    }

    private final void readMin(Obj obj, int n) throws IOException {
        switch (obj.getBinCode()) {
            case 12: {
                ((Int)obj).setMin(this.readIntVal(n));
                break;
            }
            case 16: {
                ((Real)obj).setMin(this.readRealVal(n));
                break;
            }
            case 20: {
                ((Str)obj).setMin((int)this.readIntVal(n));
                break;
            }
            case 48: {
                ((List)obj).setMin((int)this.readIntVal(n));
                break;
            }
            case 32: {
                ((Abstime)obj).setMin(this.readAbstimeVal(n));
                break;
            }
            case 36: {
                ((Reltime)obj).setMin(this.readReltimeVal(n));
                break;
            }
            case 44: {
                ((Time)obj).setMin(this.readTimeVal(n));
                break;
            }
            case 40: {
                ((Date)obj).setMin(this.readDateVal(n));
                break;
            }
            default: {
                throw new IOException("Invalid 'min' facet on " + obj.getElement());
            }
        }
    }

    private final void readMax(Obj obj, int n) throws IOException {
        switch (obj.getBinCode()) {
            case 12: {
                ((Int)obj).setMax(this.readIntVal(n));
                break;
            }
            case 16: {
                ((Real)obj).setMax(this.readRealVal(n));
                break;
            }
            case 20: {
                ((Str)obj).setMax((int)this.readIntVal(n));
                break;
            }
            case 48: {
                ((List)obj).setMax((int)this.readIntVal(n));
                break;
            }
            case 32: {
                ((Abstime)obj).setMax(this.readAbstimeVal(n));
                break;
            }
            case 36: {
                ((Reltime)obj).setMax(this.readReltimeVal(n));
                break;
            }
            case 44: {
                ((Time)obj).setMax(this.readTimeVal(n));
                break;
            }
            case 40: {
                ((Date)obj).setMax(this.readDateVal(n));
                break;
            }
            default: {
                throw new IOException("Invalid 'max' facet on " + obj.getElement());
            }
        }
    }

    private final void readRange(Obj obj, int n) throws IOException {
        Uri uri = new Uri(this.readStrVal(n));
        switch (obj.getBinCode()) {
            case 8: {
                ((Bool)obj).setRange(uri);
                break;
            }
            case 24: {
                ((Enum)obj).setRange(uri);
                break;
            }
            default: {
                throw new IOException("Invalid 'range' facet on " + obj.getElement());
            }
        }
    }

    private final void readUnit(Obj obj, int n) throws IOException {
        Uri uri = new Uri(this.readStrVal(n));
        switch (obj.getBinCode()) {
            case 12: {
                ((Int)obj).setUnit(uri);
                break;
            }
            case 16: {
                ((Real)obj).setUnit(uri);
                break;
            }
            default: {
                throw new IOException("Invalid 'unit' facet on " + obj.getElement());
            }
        }
    }

    private final void readPrecision(Obj obj, int n) throws IOException {
        int n2 = (int)this.readIntVal(n);
        switch (obj.getBinCode()) {
            case 16: {
                ((Real)obj).setPrecision(n2);
                break;
            }
            default: {
                throw new IOException("Invalid 'precision' facet on " + obj.getElement());
            }
        }
    }

    private final void readTz(Obj obj, int n) throws IOException {
        String string = this.readStrVal(n);
        switch (obj.getBinCode()) {
            case 32: {
                ((Abstime)obj).setTz(string);
                break;
            }
            case 44: {
                ((Time)obj).setTz(string);
                break;
            }
            case 40: {
                ((Date)obj).setTz(string);
                break;
            }
            default: {
                throw new IOException("Invalid 'tz' facet on " + obj.getElement());
            }
        }
    }

    private final boolean readBoolVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("Invalid bool value code 0x" + Integer.toHexString(n));
    }

    private final long readIntVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return this.readUnsignedByte();
            }
            case 1: {
                return this.readUnsignedShort();
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLong();
            }
        }
        throw new IOException("Invalid int value code 0x" + Integer.toHexString(n));
    }

    private final double readRealVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return this.readFloat();
            }
            case 1: {
                return this.readDouble();
            }
        }
        throw new IOException("Invalid float value code 0x" + Integer.toHexString(n));
    }

    private final Abstime readAbstimeVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return new Abstime((long)this.readInt() * 1000L + 946684800000L);
            }
            case 1: {
                return new Abstime(this.readLong() / 1000000L + 946684800000L);
            }
        }
        throw new IOException("Invalid abstime value code 0x" + Integer.toHexString(n));
    }

    private final Reltime readReltimeVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return new Reltime((long)this.readInt() * 1000L);
            }
            case 1: {
                return new Reltime(this.readLong() / 1000000L);
            }
        }
        throw new IOException("Invalid reltime value code 0x" + Integer.toHexString(n));
    }

    private final Time readTimeVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return new Time((long)this.readInt() * 1000L);
            }
            case 1: {
                return new Time(this.readLong() / 1000000L);
            }
        }
        throw new IOException("Invalid time value code 0x" + Integer.toHexString(n));
    }

    private final Date readDateVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                return new Date(this.readUnsignedShort(), this.readUnsignedByte(), this.readUnsignedByte());
            }
        }
        throw new IOException("Invalid date value code 0x" + Integer.toHexString(n));
    }

    private final Contract readContractVal(int n) throws IOException {
        return new Contract(this.readStrVal(n));
    }

    private final Status readStatusVal(int n) throws IOException {
        switch (n & 0x7F) {
            case 76: {
                return Status.disabled;
            }
            case 77: {
                return Status.fault;
            }
            case 78: {
                return Status.down;
            }
            case 79: {
                return Status.unackedAlarm;
            }
            case 80: {
                return Status.alarm;
            }
            case 81: {
                return Status.unacked;
            }
            case 82: {
                return Status.overridden;
            }
        }
        throw new IOException("Invalid status value code 0x" + Integer.toHexString(n));
    }

    private final String readStrVal(int n) throws IOException {
        switch (n & 3) {
            case 0: {
                String string = this.readStr();
                this.strTable.add(string);
                return string;
            }
            case 1: {
                int n2 = this.readUnsignedShort();
                if (n2 >= this.strTable.size()) {
                    throw new IOException("Str table index out of bounds " + n2 + " >= " + this.strTable.size());
                }
                return (String)this.strTable.get(n2);
            }
        }
        throw new IOException("Invalid str value code 0x" + Integer.toHexString(n));
    }

    String readStr() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.readUnsignedByte()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.strTable = new ArrayList();
    }

    public BinObixDecoder(InputStream inputStream) throws Exception {
        super(inputStream);
        this.this();
    }
}

