/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import java.util.ArrayList;
import obix.asm.Assembler;
import obix.asm.AttributeInfo;
import obix.asm.Buffer;
import obix.asm.ConstantPool;

public abstract class MemberInfo {
    public final Assembler asm;
    public final ConstantPool cp;
    public final int name;
    public final int type;
    public final int accessFlags;
    ArrayList attributes;

    MemberInfo(Assembler assembler, int n, int n2, int n3) {
        this.asm = assembler;
        this.cp = assembler.cp;
        this.name = n;
        this.type = n2;
        this.accessFlags = n3;
    }

    MemberInfo(Assembler assembler, String string, String string2, int n) {
        this.asm = assembler;
        this.cp = assembler.cp;
        this.name = this.cp.utf(string);
        this.type = this.cp.utf(string2);
        this.accessFlags = n;
    }

    MemberInfo(Assembler assembler, int n, String string, int n2) {
        this.asm = assembler;
        this.cp = assembler.cp;
        this.name = n;
        this.type = this.cp.utf(string);
        this.accessFlags = n2;
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        }
        this.attributes.add(attributeInfo);
    }

    void compile(Buffer buffer) {
        int n = this.attributes == null ? 0 : this.attributes.size();
        buffer.u2(this.accessFlags);
        buffer.u2(this.name);
        buffer.u2(this.type);
        buffer.u2(n);
        for (int i = 0; i < n; ++i) {
            ((AttributeInfo)this.attributes.get(i)).compile(buffer);
        }
    }
}

