/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import java.util.ArrayList;
import obix.asm.AttributeInfo;
import obix.asm.Buffer;
import obix.asm.ConstantPool;
import obix.asm.FieldInfo;
import obix.asm.MethodInfo;

public class Assembler {
    public final int thisClass;
    public final int superClass;
    public final int[] interfaces;
    public final int accessFlags;
    public final ConstantPool cp = new ConstantPool();
    private ArrayList fields = new ArrayList();
    private ArrayList methods = new ArrayList();
    private ArrayList attributes = new ArrayList();

    public Assembler(String string, Class clazz, int n, Class[] classArray) {
        this.thisClass = this.cp.cls(string);
        this.superClass = clazz == null ? 0 : this.cp.cls(clazz);
        this.accessFlags = n;
        this.interfaces = new int[classArray == null ? 0 : classArray.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = this.cp.cls(classArray[i]);
        }
    }

    public void addField(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    public void addMethod(MethodInfo methodInfo) {
        this.methods.add(methodInfo);
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.add(attributeInfo);
    }

    public Buffer compile() {
        int n;
        Buffer buffer = new Buffer();
        buffer.u4(-889275714);
        buffer.u2(3);
        buffer.u2(45);
        buffer.u2(this.cp.count + 1);
        buffer.append(this.cp.buf);
        buffer.u2(this.accessFlags);
        buffer.u2(this.thisClass);
        buffer.u2(this.superClass);
        buffer.u2(this.interfaces.length);
        for (n = 0; n < this.interfaces.length; ++n) {
            buffer.u2(this.interfaces[n]);
        }
        buffer.u2(this.fields.size());
        for (n = 0; n < this.fields.size(); ++n) {
            ((FieldInfo)this.fields.get(n)).compile(buffer);
        }
        buffer.u2(this.methods.size());
        for (n = 0; n < this.methods.size(); ++n) {
            ((MethodInfo)this.methods.get(n)).compile(buffer);
        }
        buffer.u2(this.attributes.size());
        for (n = 0; n < this.attributes.size(); ++n) {
            ((AttributeInfo)this.attributes.get(n)).compile(buffer);
        }
        return buffer;
    }
}

