/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Val;

public class Time
extends Val {
    private int hour;
    private int min;
    private int sec;
    private int ms;
    private Time minTime;
    private Time maxTime;
    private String tz;

    public Time(String string, int n, int n2, int n3, int n4) {
        super(string);
        this.set(n, n2, n3, n4);
    }

    public Time(String string) {
        super(string);
    }

    public Time(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3, n4);
    }

    public Time(int n, int n2, int n3) {
        this.set(n, n2, n3, 0);
    }

    public Time(long l) {
        this.set(l);
    }

    public Time() {
    }

    public long getMillis() {
        return (long)this.hour * 3600000L + (long)this.min * 60000L + (long)this.sec * 1000L + (long)this.ms;
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.min;
    }

    public final int getSecond() {
        return this.sec;
    }

    public final int getMillisecond() {
        return this.ms;
    }

    public void set(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("hour not 0-23: " + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("min not 0-59: " + n2);
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("sec not 0-59: " + n3);
        }
        if (n4 < 0 || n4 > 999) {
            throw new IllegalArgumentException("ms not 0-999: " + n4);
        }
        this.hour = n;
        this.min = n2;
        this.sec = n3;
        this.ms = n4;
    }

    public void set(long l) {
        this.hour = (int)(l / 3600000L);
        this.min = (int)((l -= (long)this.hour * 3600000L) / 60000L);
        this.sec = (int)((l -= (long)this.min * 60000L) / 1000L);
        this.ms = (int)(l -= (long)this.sec * 1000L);
    }

    public String getElement() {
        return "time";
    }

    public int getBinCode() {
        return 44;
    }

    public boolean valEquals(Val val) {
        if (val instanceof Time) {
            return this.getMillis() == ((Time)val).getMillis();
        }
        return false;
    }

    public int compareTo(Object object) {
        long l;
        long l2 = this.getMillis();
        if (l2 == (l = ((Time)object).getMillis())) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    public String encodeVal() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hour < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.hour);
        stringBuffer.append(':');
        if (this.min < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.min);
        stringBuffer.append(':');
        if (this.sec < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.sec);
        if (this.ms != 0) {
            stringBuffer.append('.');
            if (this.ms < 10) {
                stringBuffer.append("00");
            } else if (this.ms < 100) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this.ms);
        }
        return stringBuffer.toString();
    }

    public static Time parse(String string) throws Exception {
        Time time = new Time();
        time.decodeVal(string);
        return time;
    }

    public void decodeVal(String string) throws Exception {
        try {
            if (string.charAt(2) != ':') {
                throw new Exception();
            }
            int n = Integer.parseInt(string.substring(0, 2));
            int n2 = Integer.parseInt(string.substring(3, 5));
            int n3 = 0;
            int n4 = 0;
            if (string.length() > 5) {
                if (string.charAt(5) != ':') {
                    throw new Exception();
                }
                n3 = Integer.parseInt(string.substring(6, 8));
                if (string.length() > 8) {
                    if (string.charAt(8) != '.') {
                        throw new Exception();
                    }
                    if (string.length() >= 9) {
                        n4 += (string.charAt(9) - 48) * 100;
                    }
                    if (string.length() >= 10) {
                        n4 += (string.charAt(10) - 48) * 10;
                    }
                    if (string.length() >= 11) {
                        n4 += (string.charAt(11) - 48) * 1;
                    }
                }
            }
            this.set(n, n2, n3, n4);
        }
        catch (Exception exception) {
            throw new Exception("Invalid time: " + string);
        }
    }

    public Time getMin() {
        return this.minTime;
    }

    public void setMin(Time time) {
        this.minTime = time;
    }

    public Time getMax() {
        return this.maxTime;
    }

    public void setMax(Time time) {
        this.maxTime = time;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String string) {
        this.tz = string;
    }
}

