/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.lang.reflect.Array;
import java.util.HashMap;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Enum;
import obix.Err;
import obix.Feed;
import obix.IObj;
import obix.Int;
import obix.List;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Uri;
import obix.Val;
import obix.io.ObixEncoder;

public class Obj
implements IObj {
    static HashMap elemNameToClass = new HashMap();
    static HashMap binCodeToClass = new HashMap();
    private String name;
    private Uri href;
    private Contract is;
    private Obj parent;
    private HashMap kidsByName;
    private Obj kidsHead;
    private Obj kidsTail;
    private int kidsCount;
    private Obj prev;
    private Obj next;
    private Status status = Status.ok;
    private String display;
    private String displayName;
    private Uri icon;
    private boolean writable;
    private boolean isNull;
    static /* synthetic */ Class class$obix$Obj;
    static /* synthetic */ Class class$obix$Str;
    static /* synthetic */ Class class$obix$Bool;
    static /* synthetic */ Class class$obix$Int;
    static /* synthetic */ Class class$obix$Enum;
    static /* synthetic */ Class class$obix$List;
    static /* synthetic */ Class class$obix$Real;
    static /* synthetic */ Class class$obix$Uri;
    static /* synthetic */ Class class$obix$Abstime;
    static /* synthetic */ Class class$obix$Reltime;
    static /* synthetic */ Class class$obix$Time;
    static /* synthetic */ Class class$obix$Date;
    static /* synthetic */ Class class$obix$Op;
    static /* synthetic */ Class class$obix$Ref;
    static /* synthetic */ Class class$obix$Err;
    static /* synthetic */ Class class$obix$Feed;

    public static Class toClass(String string) {
        return (Class)elemNameToClass.get(string);
    }

    public static Class toClass(int n) {
        return (Class)binCodeToClass.get(new Integer(n));
    }

    public static Obj toObj(String string) {
        Class clazz = Obj.toClass(string);
        if (clazz == null) {
            return null;
        }
        try {
            return (Obj)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    private static void mapClass(String string, int n, Class clazz) {
        elemNameToClass.put(string, clazz);
        binCodeToClass.put(new Integer(n), clazz);
    }

    public Obj(String string) {
        this.name = string;
    }

    public Obj() {
        this(null);
    }

    public String getElement() {
        return "obj";
    }

    public int getBinCode() {
        return 4;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name != null) {
            throw new IllegalStateException("name is already set");
        }
        if (this.parent != null) {
            throw new IllegalStateException("obj is already parented");
        }
        this.name = string;
    }

    public Obj getParent() {
        return this.parent;
    }

    public Obj getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public Uri getHref() {
        return this.href;
    }

    public Uri getNormalizedHref() {
        if (this.href == null) {
            return null;
        }
        return this.href.normalize(this.getRoot().getHref());
    }

    public void setHref(Uri uri) {
        this.href = uri;
    }

    public boolean is(String string) {
        return this.is(new Uri(string));
    }

    public boolean is(Uri uri) {
        if (this.is == null) {
            return false;
        }
        return this.is.contains(uri);
    }

    public Contract getIs() {
        return this.is;
    }

    public void setIs(Contract contract) {
        this.is = contract;
    }

    public boolean isVal() {
        return this instanceof Val;
    }

    public boolean isBool() {
        return this instanceof Bool;
    }

    public boolean isInt() {
        return this instanceof Int;
    }

    public boolean isReal() {
        return this instanceof Real;
    }

    public boolean isEnum() {
        return this instanceof Enum;
    }

    public boolean isStr() {
        return this instanceof Str;
    }

    public boolean isAbstime() {
        return this instanceof Abstime;
    }

    public boolean isReltime() {
        return this instanceof Reltime;
    }

    public boolean isUri() {
        return this instanceof Uri;
    }

    public boolean isList() {
        return this instanceof List;
    }

    public boolean isOp() {
        return this instanceof Op;
    }

    public boolean isRef() {
        return this instanceof Ref;
    }

    public boolean isFeed() {
        return this instanceof Feed;
    }

    public boolean isErr() {
        return this instanceof Err;
    }

    public boolean getBool() {
        return ((Bool)this).get();
    }

    public long getInt() {
        return ((Int)this).get();
    }

    public double getReal() {
        return ((Real)this).get();
    }

    public String getStr() {
        return ((Str)this).get();
    }

    public void setBool(boolean bl) {
        ((Bool)this).set(bl);
    }

    public void setInt(long l) {
        ((Int)this).set(l);
    }

    public void setReal(double d) {
        ((Real)this).set(d);
    }

    public void setStr(String string) {
        ((Str)this).set(string);
    }

    public String toDisplayString() {
        if (this.display != null) {
            return this.display;
        }
        if (this instanceof Val) {
            return ((Val)this).encodeVal();
        }
        if (this.is != null && this.is.size() > 0) {
            return this.is.toString();
        }
        return "obix:" + this.getElement();
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public String toDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.name != null) {
            return this.name;
        }
        return this.getElement();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public Uri getIcon() {
        return this.icon;
    }

    public void setIcon(Uri uri) {
        this.icon = uri;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == null) {
            status = Status.ok;
        }
        this.status = status;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean bl) {
        this.isNull = bl;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean bl) {
        this.setWritable(bl, false);
    }

    public void setWritable(boolean bl, boolean bl2) {
        this.writable = bl;
        if (bl2) {
            Obj[] objArray = this.list();
            for (int i = 0; i < objArray.length; ++i) {
                objArray[i].setWritable(bl, bl2);
            }
        }
    }

    public boolean has(String string) {
        if (this.kidsByName == null) {
            return false;
        }
        return this.kidsByName.get(string) != null;
    }

    public Obj get(String string) {
        if (this.kidsByName == null) {
            return null;
        }
        return (Obj)this.kidsByName.get(string);
    }

    public Uri getChildHref(String string) {
        Obj obj = this.get(string);
        if (obj == null) {
            throw new IllegalStateException("Missing child object: " + string);
        }
        if (obj.getHref() == null) {
            throw new IllegalStateException("Child missing href : " + string);
        }
        return obj.getNormalizedHref();
    }

    public int size() {
        return this.kidsCount;
    }

    public Obj[] list() {
        Obj[] objArray = new Obj[this.kidsCount];
        int n = 0;
        Obj obj = this.kidsHead;
        while (obj != null) {
            objArray[n++] = obj;
            obj = obj.next;
        }
        return objArray;
    }

    public Object[] list(Class clazz) {
        Object[] objectArray = new Object[this.kidsCount];
        int n = 0;
        Object[] objectArray2 = this.kidsHead;
        while (objectArray2 != null) {
            if (clazz.isInstance(objectArray2)) {
                objectArray[n++] = objectArray2;
            }
            objectArray2 = objectArray2.next;
        }
        objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public Obj add(String string, Obj obj) {
        obj.setName(string);
        return this.add(obj);
    }

    public Obj add(Obj obj) {
        if (obj.parent != null || obj.prev != null || obj.next != null) {
            throw new IllegalStateException("Child is already parented");
        }
        if (obj.name != null && this.kidsByName != null && this.kidsByName.containsKey(obj.name)) {
            throw new IllegalStateException("Duplicate child name '" + obj.name + "'");
        }
        if (obj.name != null) {
            if (this.kidsByName == null) {
                this.kidsByName = new HashMap();
            }
            this.kidsByName.put(obj.name, obj);
        }
        if (this.kidsTail == null) {
            this.kidsHead = this.kidsTail = obj;
        } else {
            this.kidsTail.next = obj;
            obj.prev = this.kidsTail;
            this.kidsTail = obj;
        }
        obj.parent = this;
        ++this.kidsCount;
        return this;
    }

    public Obj addAll(Obj[] objArray) {
        for (int i = 0; i < objArray.length; ++i) {
            this.add(objArray[i]);
        }
        return this;
    }

    public void remove(Obj obj) {
        if (obj.parent != this) {
            throw new IllegalStateException("Not parented by me");
        }
        if (obj.name != null) {
            this.kidsByName.remove(obj.name);
        }
        if (this.kidsHead == obj) {
            this.kidsHead = obj.next;
        } else {
            obj.prev.next = obj.next;
        }
        if (this.kidsTail == obj) {
            this.kidsTail = obj.prev;
        } else {
            obj.next.prev = obj.prev;
        }
        obj.parent = null;
        obj.prev = null;
        obj.next = null;
        --this.kidsCount;
    }

    public void replace(Obj obj, Obj obj2) {
        if (!obj.name.equals(obj2.name)) {
            throw new IllegalStateException("Mismatched names: " + obj.name + " != " + obj2.name);
        }
        if (obj.parent != this) {
            throw new IllegalStateException("oldObj not parented by me");
        }
        if (obj2.parent != null) {
            throw new IllegalStateException("newObj already parented");
        }
        this.kidsByName.put(obj2.name, obj2);
        obj2.parent = this;
        obj2.prev = obj.prev;
        if (obj2.prev != null) {
            obj2.prev.next = obj2;
        }
        obj2.next = obj.next;
        if (obj2.next != null) {
            obj2.next.prev = obj2;
        }
        if (this.kidsHead == obj) {
            this.kidsHead = obj2;
        }
        if (this.kidsTail == obj) {
            this.kidsTail = obj2;
        }
        obj.parent = null;
        obj.prev = null;
        obj.next = null;
    }

    public void removeThis() {
        if (this.parent == null) {
            throw new IllegalStateException("Not parented");
        }
        this.parent.remove(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(this.getElement());
        if (this.name != null) {
            stringBuffer.append(" name=\"").append(this.name).append('\"');
        }
        if (this.href != null) {
            stringBuffer.append(" href=\"").append(this.href.get()).append('\"');
        }
        if (this instanceof Val) {
            stringBuffer.append(" val=\"").append(((Val)this).encodeVal()).append('\"');
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public void dump() {
        ObixEncoder.dump(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Obj.mapClass("obj", 4, class$obix$Obj == null ? (class$obix$Obj = Obj.class$("obix.Obj")) : class$obix$Obj);
        Obj.mapClass("str", 20, class$obix$Str == null ? (class$obix$Str = Obj.class$("obix.Str")) : class$obix$Str);
        Obj.mapClass("bool", 8, class$obix$Bool == null ? (class$obix$Bool = Obj.class$("obix.Bool")) : class$obix$Bool);
        Obj.mapClass("int", 12, class$obix$Int == null ? (class$obix$Int = Obj.class$("obix.Int")) : class$obix$Int);
        Obj.mapClass("enum", 24, class$obix$Enum == null ? (class$obix$Enum = Obj.class$("obix.Enum")) : class$obix$Enum);
        Obj.mapClass("list", 48, class$obix$List == null ? (class$obix$List = Obj.class$("obix.List")) : class$obix$List);
        Obj.mapClass("real", 16, class$obix$Real == null ? (class$obix$Real = Obj.class$("obix.Real")) : class$obix$Real);
        Obj.mapClass("uri", 28, class$obix$Uri == null ? (class$obix$Uri = Obj.class$("obix.Uri")) : class$obix$Uri);
        Obj.mapClass("abstime", 32, class$obix$Abstime == null ? (class$obix$Abstime = Obj.class$("obix.Abstime")) : class$obix$Abstime);
        Obj.mapClass("reltime", 36, class$obix$Reltime == null ? (class$obix$Reltime = Obj.class$("obix.Reltime")) : class$obix$Reltime);
        Obj.mapClass("time", 44, class$obix$Time == null ? (class$obix$Time = Obj.class$("obix.Time")) : class$obix$Time);
        Obj.mapClass("date", 40, class$obix$Date == null ? (class$obix$Date = Obj.class$("obix.Date")) : class$obix$Date);
        Obj.mapClass("op", 52, class$obix$Op == null ? (class$obix$Op = Obj.class$("obix.Op")) : class$obix$Op);
        Obj.mapClass("ref", 60, class$obix$Ref == null ? (class$obix$Ref = Obj.class$("obix.Ref")) : class$obix$Ref);
        Obj.mapClass("err", 64, class$obix$Err == null ? (class$obix$Err = Obj.class$("obix.Err")) : class$obix$Err);
        Obj.mapClass("feed", 56, class$obix$Feed == null ? (class$obix$Feed = Obj.class$("obix.Feed")) : class$obix$Feed);
    }
}

