/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.util.ArrayList;
import java.util.StringTokenizer;
import obix.Uri;

public class Contract {
    static final Contract Obj = new Contract("obix:obj");
    Uri[] list;
    String string;

    public Contract(String string) {
        this(Contract.parse(string));
        this.string = string;
    }

    public Contract(String[] stringArray) {
        this.list = new Uri[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.list[i] = new Uri(stringArray[i]);
        }
    }

    public Contract(Uri[] uriArray) {
        this.list = uriArray;
    }

    public static Uri[] parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Uri(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Uri[arrayList.size()]);
    }

    public Uri primary() {
        return this.list[0];
    }

    public int size() {
        return this.list.length;
    }

    public Uri get(int n) {
        return this.list[n];
    }

    public Uri[] list() {
        return this.list;
    }

    public boolean contains(Uri uri) {
        for (int i = 0; i < this.list.length; ++i) {
            if (!this.list[i].equals(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyObj() {
        return this.list.length == 1 && this.list[0].get().equals("obix:obj");
    }

    public boolean equals(Object object) {
        if (object instanceof Contract) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public String encodeJava() {
        return "new Contract(\"" + this.toString() + "\")";
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.list.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.list[i].encodeVal());
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

