/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import obix.Reltime;
import obix.Val;

public class Abstime
extends Val {
    private DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    public static final long JAVA_2000 = 946684800000L;
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final TimeZone defaultTimeZone = TimeZone.getDefault();
    static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private long millis;
    private int bits0;
    private int bits1;
    private TimeZone timeZone;
    private Abstime min;
    private Abstime max;
    private String tz;

    public Abstime(String string, long l) {
        super(string);
        this.set(l, defaultTimeZone);
    }

    public Abstime(String string) {
        super(string);
        this.set(0L, defaultTimeZone);
    }

    public Abstime(long l, TimeZone timeZone) {
        this.set(l, timeZone);
    }

    public Abstime(Abstime abstime, TimeZone timeZone) {
        this.set(abstime.millis, timeZone);
    }

    public Abstime(long l) {
        this(l, defaultTimeZone);
    }

    public Abstime(int n, int n2, int n3, int n4, int n5, int n6, int n7, TimeZone timeZone) {
        this.set(Abstime.toMillis(n, n2, n3, n4, n5, n6, n7, timeZone), timeZone);
    }

    public Abstime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6, n7, defaultTimeZone);
    }

    public Abstime(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0, defaultTimeZone);
    }

    public Abstime(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0, 0, defaultTimeZone);
    }

    public Abstime(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0, 0, defaultTimeZone);
    }

    public Abstime() {
        this.set(0L, defaultTimeZone);
    }

    public long getMillis() {
        return this.millis;
    }

    public long getMillis2000() {
        return this.millis - 946684800000L;
    }

    public final int getYear() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 >> 16 & 0xFFFF;
    }

    public final int getMonth() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 25 & 0xF;
    }

    public final int getDay() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 20 & 0x1F;
    }

    public final int getHour() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 15 & 0x1F;
    }

    public final int getMinute() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 9 & 0x3F;
    }

    public final int getSecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 3 & 0x3F;
    }

    public final int getMillisecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 & 0xFFFF;
    }

    public final int getWeekday() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 & 7;
    }

    public final long getTimeOfDayMillis() {
        return (long)(this.getHour() * 60 * 60) * 1000L + (long)(this.getMinute() * 60) * 1000L + (long)this.getSecond() * 1000L + (long)this.getMillisecond();
    }

    public String format() {
        if (this.isNull() || this.millis == 0L) {
            return "null";
        }
        return this.format.format(new Date(this.millis));
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getTimeZoneOffset() {
        if (!this.inDaylightTime()) {
            return this.timeZone.getRawOffset();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
        gregorianCalendar.setTime(new Date(this.millis));
        return gregorianCalendar.get(15) + gregorianCalendar.get(16);
    }

    public boolean inDaylightTime() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return (this.bits1 >> 29 & 1) != 0;
    }

    public Abstime toLocalTime() {
        if (this.timeZone.equals(defaultTimeZone)) {
            return this;
        }
        return new Abstime(this, defaultTimeZone);
    }

    public Abstime toUtcTime() {
        if (this.timeZone.equals(utcTimeZone)) {
            return this;
        }
        return new Abstime(this, utcTimeZone);
    }

    public int compareTo(Object object) {
        Abstime abstime = (Abstime)object;
        if (this.millis < abstime.millis) {
            return -1;
        }
        if (this.millis == abstime.millis) {
            return 0;
        }
        return 1;
    }

    public boolean isBefore(Abstime abstime) {
        return this.compareTo(abstime) < 0;
    }

    public boolean isAfter(Abstime abstime) {
        return this.compareTo(abstime) > 0;
    }

    public int hashCode() {
        return (int)(this.millis ^ this.millis >> 32);
    }

    public boolean valEquals(Val val) {
        if (val instanceof Abstime) {
            return ((Abstime)val).millis == this.millis;
        }
        return false;
    }

    public boolean dateEquals(Abstime abstime) {
        return abstime.getYear() == this.getYear() && abstime.getMonth() == this.getMonth() && abstime.getDay() == this.getDay();
    }

    public boolean timeEquals(Abstime abstime) {
        return abstime.getTimeOfDayMillis() == this.getTimeOfDayMillis();
    }

    public Abstime add(Reltime reltime) {
        return new Abstime(this.millis + reltime.getMillis(), this.timeZone);
    }

    public Abstime subtract(Reltime reltime) {
        return new Abstime(this.millis - reltime.getMillis(), this.timeZone);
    }

    public Reltime delta(Abstime abstime) {
        return new Reltime(abstime.millis - this.millis);
    }

    public Abstime timeOfDay(int n, int n2, int n3, int n4) {
        return new Abstime(this.getYear(), this.getMonth(), this.getDay(), n, n2, n3, n4, this.timeZone);
    }

    public Abstime nextDay() {
        int n = this.getYear();
        int n2 = this.getMonth();
        int n3 = this.getDay();
        if (n3 == Abstime.getDaysInMonth(n, n2)) {
            n3 = 1;
            if (n2 == 12) {
                n2 = 1;
                ++n;
            } else {
                ++n2;
            }
        } else {
            ++n3;
        }
        return new Abstime(n, n2, n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime prevDay() {
        int n = this.getYear();
        int n2 = this.getMonth();
        int n3 = this.getDay();
        if (n3 == 1) {
            if (n2 == 1) {
                n2 = 12;
                --n;
            } else {
                --n2;
            }
            n3 = Abstime.getDaysInMonth(n, n2);
        } else {
            --n3;
        }
        return new Abstime(n, n2, n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime nextMonth() {
        int n = this.getYear();
        int n2 = this.getMonth();
        int n3 = this.getDay();
        if (n2 == 12) {
            n2 = 1;
            ++n;
        } else if (n3 == Abstime.getDaysInMonth(n, n2)) {
            n3 = Abstime.getDaysInMonth(n, ++n2);
        } else if (n3 > Abstime.getDaysInMonth(n, ++n2)) {
            n3 = Abstime.getDaysInMonth(n, n2);
        }
        return new Abstime(n, n2, n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime prevMonth() {
        int n = this.getYear();
        int n2 = this.getMonth();
        int n3 = this.getDay();
        if (n2 == 1) {
            n2 = 12;
            --n;
        } else if (n3 == Abstime.getDaysInMonth(n, n2)) {
            n3 = Abstime.getDaysInMonth(n, --n2);
        } else if (n3 > Abstime.getDaysInMonth(n, --n2)) {
            n3 = Abstime.getDaysInMonth(n, n2);
        }
        return new Abstime(n, n2, n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime nextYear() {
        int n = this.getDay();
        if (this.isLeapDay()) {
            n = 28;
        }
        return new Abstime(this.getYear() + 1, this.getMonth(), n, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime prevYear() {
        int n = this.getDay();
        if (this.isLeapDay()) {
            n = 28;
        }
        return new Abstime(this.getYear() - 1, this.getMonth(), n, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime nextWeekday(int n) {
        Abstime abstime = this.nextDay();
        while (abstime.getWeekday() != n) {
            abstime = abstime.nextDay();
        }
        return abstime;
    }

    public Abstime prevWeekday(int n) {
        Abstime abstime = this.prevDay();
        while (abstime.getWeekday() != n) {
            abstime = abstime.prevDay();
        }
        return abstime;
    }

    public boolean isLeapDay() {
        return this.getMonth() == 2 && this.getDay() == 29;
    }

    public static boolean isLeapYear(int n) {
        if (n >= 1582) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return n % 4 == 0;
    }

    public static int getDaysInMonth(int n, int n2) {
        Abstime.checkMonth(n2);
        if (n2 == 2) {
            return Abstime.isLeapYear(n) ? 29 : 28;
        }
        return daysInMonth[n2 - 1];
    }

    public static int getDaysInYear(int n) {
        return Abstime.isLeapYear(n) ? 366 : 365;
    }

    public long get() {
        return this.millis;
    }

    public void set(long l, TimeZone timeZone) {
        this.millis = l;
        this.timeZone = timeZone;
        this.bits1 = 0;
        this.bits0 = 0;
        if (timeZone != null) {
            this.tz = timeZone.getID();
        }
    }

    public String getElement() {
        return "abstime";
    }

    public int getBinCode() {
        return 32;
    }

    public String encodeVal() {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = this.getYear();
        if (n < 10) {
            stringBuffer.append('0');
        }
        if (n < 100) {
            stringBuffer.append('0');
        }
        if (n < 1000) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('-');
        int n2 = this.getMonth();
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2).append('-');
        int n3 = this.getDay();
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3).append('T');
        int n4 = this.getHour();
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4).append(':');
        int n5 = this.getMinute();
        if (n5 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n5).append(':');
        int n6 = this.getSecond();
        if (n6 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n6).append('.');
        int n7 = this.getMillisecond();
        if (n7 < 10) {
            stringBuffer.append('0');
        }
        if (n7 < 100) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n7);
        int n8 = this.getTimeZoneOffset();
        if (n8 == 0) {
            stringBuffer.append('Z');
        } else {
            int n9 = Math.abs(n8 / 3600000);
            int n10 = Math.abs(n8 % 3600000 / 60000);
            if (n8 < 0) {
                stringBuffer.append('-');
            } else {
                stringBuffer.append('+');
            }
            if (n9 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n9);
            stringBuffer.append(':');
            if (n10 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n10);
        }
        return stringBuffer.toString();
    }

    public static Abstime parse(String string) throws Exception {
        Abstime abstime = new Abstime();
        abstime.decodeVal(string);
        return abstime;
    }

    public void decodeVal(String string) throws Exception {
        char[] cArray = string.toCharArray();
        try {
            char c;
            int n = 0;
            int n2 = (cArray[n++] - 48) * 1000 + (cArray[n++] - 48) * 100 + (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n3 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n4 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != 'T') {
                throw new Exception();
            }
            int n5 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n6 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n7 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            int n8 = 0;
            if (cArray[n] == '.') {
                int n9 = ++n;
                n8 = (cArray[n9] - 48) * 100;
                if ('0' <= cArray[++n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 10;
                }
                if ('0' <= cArray[n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 1;
                }
                while (n < cArray.length && '0' <= cArray[n] && cArray[n] <= '9') {
                    ++n;
                }
            }
            int n10 = 0;
            if ((c = cArray[n++]) != 'Z') {
                if (c != '+' && c != '-') {
                    throw new Exception();
                }
                int n11 = cArray[n++] - 48;
                if (n < cArray.length && cArray[n] != ':') {
                    n11 = n11 * 10 + (cArray[n++] - 48);
                }
                int n12 = 0;
                if (n < cArray.length) {
                    if (cArray[n++] != ':') {
                        throw new Exception();
                    }
                    n12 = 10 * (cArray[n++] - 48) + (cArray[n++] - 48);
                }
                n10 = n11 * 3600000 + n12 * 60000;
                if (c == '-') {
                    n10 *= -1;
                }
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.set(14, n8);
            ((Calendar)gregorianCalendar).setTimeZone(new SimpleTimeZone(n10, "Offset"));
            this.set(gregorianCalendar.getTime().getTime(), this.timeZone);
        }
        catch (Exception exception) {
            throw new Exception("Invalid abstime: " + string);
        }
    }

    public String encodeJava() {
        return String.valueOf(this.millis) + "L";
    }

    public Abstime getMin() {
        return this.min;
    }

    public void setMin(Abstime abstime) {
        this.min = abstime;
    }

    public Abstime getMax() {
        return this.max;
    }

    public void setMax(Abstime abstime) {
        this.max = abstime;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String string) {
        if (string == null) {
            return;
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if (timeZone == null) {
            System.out.println("no timezone for tz facet:" + string);
            return;
        }
        if (!timeZone.equals(this.timeZone)) {
            this.bits1 = 0;
            this.bits0 = 0;
        }
        this.tz = string;
        this.timeZone = timeZone;
    }

    private static long toMillis(int n, int n2, int n3, int n4, int n5, int n6, int n7, TimeZone timeZone) {
        Abstime.checkMonth(n2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        gregorianCalendar.set(14, n7);
        return gregorianCalendar.getTime().getTime();
    }

    private static int checkMonth(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Month must be 1 to 12");
        }
        return n;
    }

    private void millisToFields() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
        Date date = new Date(this.millis);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        this.bits0 |= (n & 0xFFFF) << 16;
        n = gregorianCalendar.get(14);
        this.bits0 |= (n & 0xFFFF) << 0;
        n = gregorianCalendar.get(2) + 1;
        this.bits1 |= (n & 0xF) << 25;
        n = gregorianCalendar.get(5);
        this.bits1 |= (n & 0x1F) << 20;
        n = gregorianCalendar.get(11);
        this.bits1 |= (n & 0x1F) << 15;
        n = gregorianCalendar.get(12);
        this.bits1 |= (n & 0x3F) << 9;
        n = gregorianCalendar.get(13);
        this.bits1 |= (n & 0x3F) << 3;
        n = gregorianCalendar.get(7) - 1;
        this.bits1 |= (n & 7) << 0;
        if (this.timeZone.inDaylightTime(date)) {
            this.bits1 |= 0x20000000;
        }
    }
}

