/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDisplay;

import com.tridium.platDisplay.BDisplayPlatformService;
import com.tridium.platform.BPlatform;
import com.tridium.platform.qnx.QnxNativeUtil;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDisplayPlatformServiceJavelina
extends BDisplayPlatformService {
    public static final Property enableScreenSaver = BDisplayPlatformServiceJavelina.newProperty((int)2, (boolean)true, null);
    public static final Property saveScreenAfter = BDisplayPlatformServiceJavelina.newProperty((int)2, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)false), (String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property touchscreen = BDisplayPlatformServiceJavelina.newProperty((int)2, (boolean)true, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platDisplay:CalibrateTouchscreenFE")));
    public static final Property cleanScreenDuration = BDisplayPlatformServiceJavelina.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true), (String)"min", (BIDataValue)BRelTime.makeSeconds((int)15)));
    public static final Property gamma = BDisplayPlatformServiceJavelina.newProperty((int)2, (float)1.0f, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.5f), (String)"max", (BIDataValue)BFloat.make((float)3.5f)));
    public static final Property brightness = BDisplayPlatformServiceJavelina.newProperty((int)2, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-100), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property contrast = BDisplayPlatformServiceJavelina.newProperty((int)2, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)200)));
    public static final Property backlight = BDisplayPlatformServiceJavelina.newProperty((int)2, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)3)));
    public static final Action calibrateTouchscreen = BDisplayPlatformServiceJavelina.newAction((int)0, null);
    public static final Action cleanScreen = BDisplayPlatformServiceJavelina.newAction((int)0, null);
    public static final Action screenSaverAlarm = BDisplayPlatformServiceJavelina.newAction((int)4, (BValue)new BStruct(), null);
    public static final Action updateGamma = BDisplayPlatformServiceJavelina.newAction((int)0, (BValue)BFloat.make((float)1.0f), null);
    public static final Action updateBrightness = BDisplayPlatformServiceJavelina.newAction((int)0, (BValue)BInteger.make((int)0), null);
    public static final Action updateContrast = BDisplayPlatformServiceJavelina.newAction((int)0, (BValue)BInteger.make((int)100), null);
    public static final Type TYPE;
    private static final String DISPLAY = "/sys/info/display";
    private static final String UICMD_DEV = "/dev/uicmd";
    private static final int ST_OK = 0;
    private static final int ST_CALIB_NOT_EXITED = 255;
    private static final int ST_CALIB_FAILED = 254;
    private static final int ST_IO_FAILED = 253;
    private static final int ST_SAVER_FAILED = 252;
    private static final int ST_CALIB_LOCKED = 251;
    private static final int ST_SAVER_LOCKED = 250;
    private static final String ST_OK_KEY = "screentool.ok";
    private static final String ST_CALIB_NOT_EXITED_KEY = "screentool.calibNotExited";
    private static final String ST_CALIB_FAILED_KEY = "screentool.calibFailed";
    private static final String ST_IO_FAILED_KEY = "screentool.ioFailed";
    private static final String ST_SAVER_FAILED_KEY = "screentool.saverFailed";
    Context notDirty;
    private PrintStream uicmdOut;
    static /* synthetic */ Class class$com$tridium$platDisplay$BDisplayPlatformServiceJavelina;

    public boolean getEnableScreenSaver() {
        return this.getBoolean(enableScreenSaver);
    }

    public void setEnableScreenSaver(boolean bl) {
        this.setBoolean(enableScreenSaver, bl, null);
    }

    public BRelTime getSaveScreenAfter() {
        return (BRelTime)this.get(saveScreenAfter);
    }

    public void setSaveScreenAfter(BRelTime bRelTime) {
        this.set(saveScreenAfter, (BValue)bRelTime, null);
    }

    public boolean getTouchscreen() {
        return this.getBoolean(touchscreen);
    }

    public void setTouchscreen(boolean bl) {
        this.setBoolean(touchscreen, bl, null);
    }

    public BRelTime getCleanScreenDuration() {
        return (BRelTime)this.get(cleanScreenDuration);
    }

    public void setCleanScreenDuration(BRelTime bRelTime) {
        this.set(cleanScreenDuration, (BValue)bRelTime, null);
    }

    public float getGamma() {
        return this.getFloat(gamma);
    }

    public void setGamma(float f) {
        this.setFloat(gamma, f, null);
    }

    public int getBrightness() {
        return this.getInt(brightness);
    }

    public void setBrightness(int n) {
        this.setInt(brightness, n, null);
    }

    public int getContrast() {
        return this.getInt(contrast);
    }

    public void setContrast(int n) {
        this.setInt(contrast, n, null);
    }

    public int getBacklight() {
        return this.getInt(backlight);
    }

    public void setBacklight(int n) {
        this.setInt(backlight, n, null);
    }

    public void calibrateTouchscreen() {
        this.invoke(calibrateTouchscreen, null, null);
    }

    public void cleanScreen() {
        this.invoke(cleanScreen, null, null);
    }

    public void screenSaverAlarm(BStruct bStruct) {
        this.invoke(screenSaverAlarm, (BValue)bStruct, null);
    }

    public void updateGamma(BFloat bFloat) {
        this.invoke(updateGamma, (BValue)bFloat, null);
    }

    public void updateBrightness(BInteger bInteger) {
        this.invoke(updateBrightness, (BValue)bInteger, null);
    }

    public void updateContrast(BInteger bInteger) {
        this.invoke(updateContrast, (BValue)bInteger, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            Class clazz = Sys.loadClass((String)"bajaui", (String)"com.tridium.ui.UiEnv");
            Method method = clazz.getDeclaredMethod("get", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getDeclaredMethod("setHasTouchscreen", Boolean.TYPE);
            method2.invoke(object, Boolean.TRUE);
        }
        catch (Exception exception) {
            System.err.println("unable to set hasTouchscreen" + exception.getMessage());
        }
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("kitPxDisplay:ScreenSaverConfigView");
        agentList.remove("kitPxDisplay:ColorSettingsView");
        return agentList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadPlatformServiceProperties() {
        Object object;
        block25: {
            File file;
            super.loadPlatformServiceProperties();
            BPlatform.log.trace("loading screen saver properties");
            BufferedReader bufferedReader = null;
            try {
                try {
                    file = new File(DISPLAY);
                    if (file.exists()) {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        this.setDisplayType(bufferedReader.readLine());
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    if (bufferedReader == null) throw throwable;
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            try {}
            catch (Exception exception) {}
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (!this.getDisplayType().equalsIgnoreCase("photon")) {
                this.setFlags((Slot)enableScreenSaver, this.getFlags((Slot)enableScreenSaver) & 4);
                this.setFlags((Slot)saveScreenAfter, this.getFlags((Slot)saveScreenAfter) & 4);
                this.setFlags((Slot)touchscreen, this.getFlags((Slot)touchscreen) & 4);
                this.setFlags((Slot)gamma, this.getFlags((Slot)gamma) & 4);
                this.setFlags((Slot)brightness, this.getFlags((Slot)brightness) & 4);
                this.setFlags((Slot)contrast, this.getFlags((Slot)contrast) & 4);
                this.setFlags((Slot)backlight, this.getFlags((Slot)backlight) & 4);
                this.setFlags((Slot)updateGamma, this.getFlags((Slot)updateGamma) & 4);
                this.setFlags((Slot)updateBrightness, this.getFlags((Slot)updateBrightness) & 4);
                this.setFlags((Slot)updateContrast, this.getFlags((Slot)updateContrast) & 4);
                return;
            }
            if (this.getSlot("screenSaverAlarmLink") == null) {
                BPlatform.log.trace("creating alarm service link");
                try {
                    object = Nre.serviceManager.getService("alarm:AlarmService");
                    file = object.getSlot("alarm");
                    if (file != null) {
                        if (this.linkTo("screenSaverAlarmLink", (BComponent)object, (Slot)file, (Slot)screenSaverAlarm) == null) {
                            BPlatform.log.error("unable to create link from alarm service");
                        }
                        break block25;
                    }
                    BPlatform.log.error("unable to find alarm slot on the alarm service");
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                    BPlatform.log.error("unable to find alarm service", (Throwable)serviceNotFoundException);
                }
            }
        }
        object = null;
        try {
            try {
                File file = new File(UICMD_DEV);
                if (file.exists()) {
                    object = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load((InputStream)object);
                    boolean bl = Boolean.valueOf(properties.getProperty("saverEnabled", "true"));
                    this.setBoolean(enableScreenSaver, bl, this.notDirty);
                    int n = Integer.parseInt(properties.getProperty("saverTimeout", "300"));
                    this.set(saveScreenAfter, (BValue)BRelTime.makeSeconds((int)n), this.notDirty);
                    float f = Float.parseFloat(properties.getProperty("gamma", "1.0"));
                    this.setFloat(gamma, f, this.notDirty);
                    int n2 = Integer.parseInt(properties.getProperty("brightness", "0"));
                    this.setInt(brightness, n2, this.notDirty);
                    int n3 = Integer.parseInt(properties.getProperty("contrast", "100"));
                    this.setInt(contrast, n3, this.notDirty);
                    int n4 = Integer.parseInt(properties.getProperty("backlight", "0"));
                    this.setInt(backlight, n4, this.notDirty);
                }
            }
            catch (Exception exception) {
                BPlatform.log.error("unable to read uicmd properties", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_18 = null;
            try {
                if (object == null) throw throwable;
                ((FileInputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var6_19 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (object == null) return;
        ((FileInputStream)object).close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidPlatform() {
        BufferedReader bufferedReader = null;
        boolean bl = false;
        String string = null;
        try {
            try {
                File file = new File(DISPLAY);
                if (file.exists() && (string = (bufferedReader = new BufferedReader(new FileReader(file))).readLine()) != null && !string.equalsIgnoreCase("none")) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Exception exception) {
            return bl;
        }
        if (bufferedReader == null) return bl;
        bufferedReader.close();
        return bl;
    }

    protected boolean loadLibraries() {
        return true;
    }

    public void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        try {
            this.uicmdOut = new PrintStream(new FileOutputStream(UICMD_DEV));
        }
        catch (Exception exception) {}
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(context);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || context == this.notDirty) {
            return;
        }
        if (property == gamma) {
            if (this.uicmdOut != null) {
                this.uicmdOut.println("GAMMA " + this.getGamma());
            }
        } else if (property == brightness) {
            if (this.uicmdOut != null) {
                this.uicmdOut.println("BRIGHTNESS " + this.getBrightness());
            }
        } else if (property == contrast) {
            if (this.uicmdOut != null) {
                this.uicmdOut.println("CONTRAST " + this.getContrast());
            }
        } else if (property == backlight && this.uicmdOut != null) {
            this.uicmdOut.println("DIM " + this.getBacklight());
        }
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        if (this.uicmdOut != null) {
            if (this.getEnableScreenSaver()) {
                this.uicmdOut.println("SAVER ENABLED " + this.getSaveScreenAfter().getSeconds());
            } else {
                this.uicmdOut.println("SAVER DISABLED");
            }
        }
    }

    public void doCalibrateTouchscreen() {
        try {
            if (this.uicmdOut != null) {
                this.uicmdOut.println("CALIB");
            }
        }
        catch (Exception exception) {}
    }

    public void doCleanScreen() {
        try {
            if (this.uicmdOut != null) {
                this.uicmdOut.println("CLEANSCREEN " + this.getCleanScreenDuration());
            }
        }
        catch (Exception exception) {}
    }

    public void doScreenSaverAlarm(BStruct bStruct) {
        try {
            BFrozenEnum bFrozenEnum;
            BFrozenEnum bFrozenEnum2 = (BFrozenEnum)bStruct.get("sourceState");
            if (bFrozenEnum2 != null && !bFrozenEnum2.getTag().equals("normal") && (bFrozenEnum = (BFrozenEnum)bStruct.get("ackState")).getTag().equals("unacked")) {
                QnxNativeUtil.slay((String)"pjavsaver", (int)16);
            }
        }
        catch (Exception exception) {}
    }

    public void doUpdateGamma(BFloat bFloat) {
        this.setFloat(gamma, bFloat.getFloat(), this.notDirty);
        if (this.uicmdOut != null) {
            this.uicmdOut.println("GAMMA " + this.getGamma());
        }
    }

    public void doUpdateBrightness(BInteger bInteger) {
        this.setInt(brightness, bInteger.getInt(), this.notDirty);
        if (this.uicmdOut != null) {
            this.uicmdOut.println("BRIGHTNESS " + this.getBrightness());
        }
    }

    public void doUpdateContrast(BInteger bInteger) {
        this.setInt(contrast, bInteger.getInt(), this.notDirty);
        if (this.uicmdOut != null) {
            this.uicmdOut.println("CONTRAST " + this.getContrast());
        }
    }

    public void doUpdateBacklight(BInteger bInteger) {
        this.setInt(backlight, bInteger.getInt(), this.notDirty);
        if (this.uicmdOut != null) {
            this.uicmdOut.println("DIM " + this.getBacklight());
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BDisplayPlatformService.TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.notDirty = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Javelina:notDirty";
            }
        };
        this.uicmdOut = null;
    }

    public BDisplayPlatformServiceJavelina() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platDisplay$BDisplayPlatformServiceJavelina;
        if (clazz == null) {
            clazz = class$com$tridium$platDisplay$BDisplayPlatformServiceJavelina = BDisplayPlatformServiceJavelina.class("[Lcom.tridium.platDisplay.BDisplayPlatformServiceJavelina;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

