/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather.advisory;

import java.util.Comparator;
import java.util.HashMap;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.SortUtil;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryAlarmSourceInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAdvisoryContainer
extends BVector
implements BIAlarmSource {
    public static final Property status = BAdvisoryContainer.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property alarmEnable = BAdvisoryContainer.newProperty((int)0, (boolean)true, null);
    public static final Property alarmProperties = BAdvisoryContainer.newProperty((int)0, (BValue)new BAdvisoryAlarmSourceInfo(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private AlarmSupport support = new AlarmSupport((BIAlarmSource)this, this.getAlarmProperties().getAlarmClass());
    static /* synthetic */ Class class$javax$baja$weather$advisory$BAdvisoryContainer;
    static /* synthetic */ Class class$javax$baja$weather$advisory$BAdvisory;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getAlarmEnable() {
        return this.getBoolean(alarmEnable);
    }

    public void setAlarmEnable(boolean bl) {
        this.setBoolean(alarmEnable, bl, null);
    }

    public BAdvisoryAlarmSourceInfo getAlarmProperties() {
        return (BAdvisoryAlarmSourceInfo)this.get(alarmProperties);
    }

    public void setAlarmProperties(BAdvisoryAlarmSourceInfo bAdvisoryAlarmSourceInfo) {
        this.set(alarmProperties, (BValue)bAdvisoryAlarmSourceInfo, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isNavChild() {
        return true;
    }

    public void started() {
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if (this.getChildren(clazz).length > 0) {
            this.setStatus(BStatus.alarm);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        try {
            return BBoolean.make((boolean)this.support.ackAlarm(bAlarmRecord));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BBoolean.make((boolean)false);
        }
    }

    public void advisory(BAdvisory bAdvisory) {
        BCurrentConditions bCurrentConditions;
        BAdvisory bAdvisory2 = this.getAdvisory(bAdvisory.getId());
        if (bAdvisory2 == null) {
            BFacets bFacets;
            this.add("advisory?", (BValue)bAdvisory, 1);
            bCurrentConditions = (BNameMap)this.get("displayNames");
            if (bCurrentConditions == null) {
                bFacets = new HashMap();
                bFacets.put(bAdvisory.getName(), BFormat.make((String)bAdvisory.getWeatherSummary().getValue()));
                this.add("displayNames", (BValue)BNameMap.make(bFacets), 4);
            } else {
                bCurrentConditions = BNameMap.make((BNameMap)bCurrentConditions, (String)bAdvisory.getName(), (BFormat)BFormat.make((String)bAdvisory.getWeatherSummary().getValue()));
                this.set("displayNames", (BValue)bCurrentConditions);
            }
            if (this.getAlarmEnable()) {
                bFacets = this.getAlarmProperties().makeAlarmData(BSourceState.offnormal);
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.state.getName(), (BIDataValue)bAdvisory.getState().toDataValue());
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.description.getName(), (BIDataValue)BString.make((String)bAdvisory.getDescription().getValue()));
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.instructions.getName(), (BIDataValue)BString.make((String)bAdvisory.getInstructions().getValue()));
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.urgency.getName(), (BIDataValue)bAdvisory.getUrgency().getValueValue().toDataValue());
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.severity.getName(), (BIDataValue)bAdvisory.getSeverity().getValueValue().toDataValue());
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.certainty.getName(), (BIDataValue)bAdvisory.getCertainty().getValueValue().toDataValue());
                bFacets = BFacets.make((BFacets)bFacets, (String)BAdvisory.expires.getName(), (BIDataValue)bAdvisory.getExpires());
                bFacets = BFacets.make((BFacets)bFacets, (String)"msgText", (BIDataValue)BString.make((String)bAdvisory.getWeatherSummary().getValue()));
                try {
                    this.support.setAlarmClass(this.getAlarmProperties().getAlarmClass());
                    this.support.newOffnormalAlarm(bFacets);
                }
                catch (Exception exception) {
                    BWeatherService.log.error("Unable to create weather advisory alarm.", (Throwable)exception);
                }
            }
        } else {
            bAdvisory2.copyFrom((BComplex)bAdvisory);
        }
        bCurrentConditions = (BCurrentConditions)this.getParent();
        bCurrentConditions.setStatus(BStatus.makeAlarm((BStatus)bCurrentConditions.getStatus(), (boolean)true));
        bCurrentConditions.getState().setStatus(BStatus.makeAlarm((BStatus)bCurrentConditions.getStatus(), (boolean)true));
        ((BWeatherReport)bCurrentConditions.getParent()).setStatus(BStatus.makeAlarm((BStatus)((BWeatherReport)bCurrentConditions.getParent()).getStatus(), (boolean)true));
    }

    public void added(Property property, Context context) {
        Class clazz;
        if (this.isRunning() && property.getType().is(BAdvisory.TYPE)) {
            BCurrentConditions bCurrentConditions = (BCurrentConditions)this.getParent();
            bCurrentConditions.setStatus(BStatus.makeAlarm((BStatus)bCurrentConditions.getStatus(), (boolean)true));
            bCurrentConditions.getState().setStatus(BStatus.makeAlarm((BStatus)bCurrentConditions.getStatus(), (boolean)true));
            ((BWeatherReport)bCurrentConditions.getParent()).setStatus(BStatus.makeAlarm((BStatus)((BWeatherReport)bCurrentConditions.getParent()).getStatus(), (boolean)true));
        }
        if ((clazz = class$javax$baja$weather$advisory$BAdvisory) == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if (this.getChildren(clazz).length > 0) {
            this.setStatus(BStatus.alarm);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        Class clazz;
        if (this.isRunning() && property.getType().is(BAdvisory.TYPE)) {
            if (this.getAlarmEnable()) {
                Class clazz2 = class$javax$baja$weather$advisory$BAdvisory;
                if (clazz2 == null) {
                    clazz2 = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
                }
                if (this.getChildren(clazz2).length == 0) {
                    try {
                        this.support.toNormal(context);
                    }
                    catch (Exception exception) {
                        BWeatherService.log.error("Unable to return advisory alarms to normal.", (Throwable)exception);
                    }
                }
            }
            boolean bl = false;
            Class clazz3 = class$javax$baja$weather$advisory$BAdvisory;
            if (clazz3 == null) {
                clazz3 = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
            }
            if (this.getChildren(clazz3).length > 0) {
                bl = true;
            }
            boolean bl2 = bl;
            BCurrentConditions bCurrentConditions = (BCurrentConditions)this.getParent();
            bCurrentConditions.setStatus(BStatus.makeAlarm((BStatus)bCurrentConditions.getStatus(), (boolean)bl2));
            bCurrentConditions.getState().setStatus(BStatus.makeAlarm((BStatus)bCurrentConditions.getStatus(), (boolean)bl2));
            ((BWeatherReport)bCurrentConditions.getParent()).setStatus(BStatus.makeAlarm((BStatus)((BWeatherReport)bCurrentConditions.getParent()).getStatus(), (boolean)bl2));
        }
        if ((clazz = class$javax$baja$weather$advisory$BAdvisory) == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if (this.getChildren(clazz).length > 0) {
            this.setStatus(BStatus.alarm);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public boolean hasAdvisories() {
        this.lease();
        boolean bl = false;
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if (this.getChildren(clazz).length > 0) {
            bl = true;
        }
        return bl;
    }

    public int getAdvisoryCount() {
        this.lease();
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        return this.getChildren(clazz).length;
    }

    public BAdvisory getMostRecent() {
        BAdvisory[] bAdvisoryArray;
        this.lease(2);
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if ((bAdvisoryArray = (BAdvisory[])this.getChildren(clazz)).length > 0) {
            SortUtil.sort((Object[])bAdvisoryArray, (Object[])bAdvisoryArray, (Comparator)new Comparator(){

                public final int compare(Object object, Object object2) {
                    BAdvisory bAdvisory = (BAdvisory)((Object)object);
                    BAdvisory bAdvisory2 = (BAdvisory)((Object)object2);
                    return bAdvisory2.getEffective().compareTo((Object)bAdvisory.getEffective());
                }
            });
            return bAdvisoryArray[0];
        }
        return null;
    }

    public BAdvisory getMostUrgent() {
        BAdvisory[] bAdvisoryArray;
        this.lease(2);
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if ((bAdvisoryArray = (BAdvisory[])this.getChildren(clazz)).length > 0) {
            SortUtil.sort((Object[])bAdvisoryArray, (Object[])bAdvisoryArray, (Comparator)new Comparator(){

                public final int compare(Object object, Object object2) {
                    BAdvisory bAdvisory = (BAdvisory)((Object)object);
                    BAdvisory bAdvisory2 = (BAdvisory)((Object)object2);
                    int n = bAdvisory.getUrgency().getValue().compareTo((Object)bAdvisory2.getUrgency().getValue());
                    if (n != 0) {
                        return n;
                    }
                    return bAdvisory2.getEffective().compareTo((Object)bAdvisory.getEffective());
                }
            });
            return bAdvisoryArray[0];
        }
        return null;
    }

    public BAdvisory getMostSevere() {
        BAdvisory[] bAdvisoryArray;
        this.lease(2);
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if ((bAdvisoryArray = (BAdvisory[])this.getChildren(clazz)).length > 0) {
            SortUtil.sort((Object[])bAdvisoryArray, (Object[])bAdvisoryArray, (Comparator)new Comparator(){

                public final int compare(Object object, Object object2) {
                    BAdvisory bAdvisory = (BAdvisory)((Object)object);
                    BAdvisory bAdvisory2 = (BAdvisory)((Object)object2);
                    int n = bAdvisory.getSeverity().getValue().compareTo((Object)bAdvisory2.getSeverity().getValue());
                    if (n != 0) {
                        return n;
                    }
                    return bAdvisory2.getEffective().compareTo((Object)bAdvisory.getEffective());
                }
            });
            return bAdvisoryArray[0];
        }
        return null;
    }

    public BAdvisory getMostCertain() {
        BAdvisory[] bAdvisoryArray;
        this.lease(2);
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        if ((bAdvisoryArray = (BAdvisory[])this.getChildren(clazz)).length > 0) {
            SortUtil.sort((Object[])bAdvisoryArray, (Object[])bAdvisoryArray, (Comparator)new Comparator(){

                public final int compare(Object object, Object object2) {
                    BAdvisory bAdvisory = (BAdvisory)((Object)object);
                    BAdvisory bAdvisory2 = (BAdvisory)((Object)object2);
                    return bAdvisory.getCertainty().getValue().compareTo((Object)bAdvisory2.getCertainty().getValue());
                }
            });
            return bAdvisoryArray[0];
        }
        return null;
    }

    public BAdvisory getAdvisory(BValue bValue) {
        Class clazz = class$javax$baja$weather$advisory$BAdvisory;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisory = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisory;", false);
        }
        Object[] objectArray = this.getChildren(clazz);
        int n = 0;
        while (n < objectArray.length) {
            if (((BAdvisory)((Object)objectArray[n])).getId().equals((Object)bValue)) {
                return (BAdvisory)((Object)objectArray[n]);
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$weather$advisory$BAdvisoryContainer;
        if (clazz == null) {
            clazz = class$javax$baja$weather$advisory$BAdvisoryContainer = BAdvisoryContainer.class("[Ljavax.baja.weather.advisory.BAdvisoryContainer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.make((String)"module://weather/icons/weather.png"), (BIcon)BIcon.make((String)"module://icons/x16/badges/warning.png"));
    }
}

