/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import com.tridium.weather.nws.BNwsWeatherProvider;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWeatherReport
extends BComponent
implements BIStatus {
    public static final Property status = BWeatherReport.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property provider = BWeatherReport.newProperty((int)0, (BValue)new BNwsWeatherProvider(), null);
    public static final Property current = BWeatherReport.newProperty((int)0, (BValue)new BCurrentConditions(), null);
    public static final Action updateWeatherReport = BWeatherReport.newAction((int)16, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static Lexicon lex;
    static final String lexToday;
    static final String lexTomorrow;
    static /* synthetic */ Class class$javax$baja$weather$BWeatherReport;
    static /* synthetic */ Class class$javax$baja$weather$BForecast;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BWeatherProvider getProvider() {
        return (BWeatherProvider)this.get(provider);
    }

    public void setProvider(BWeatherProvider bWeatherProvider) {
        this.set(provider, (BValue)bWeatherProvider, null);
    }

    public BCurrentConditions getCurrent() {
        return (BCurrentConditions)this.get(current);
    }

    public void setCurrent(BCurrentConditions bCurrentConditions) {
        this.set(current, (BValue)bCurrentConditions, null);
    }

    public void updateWeatherReport() {
        this.invoke(updateWeatherReport, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.updateWeatherReport();
    }

    public BForecast[] getForecast() {
        Class clazz = class$javax$baja$weather$BForecast;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BForecast = BWeatherReport.class("[Ljavax.baja.weather.BForecast;", false);
        }
        return (BForecast[])this.getChildren(clazz);
    }

    public void setForecast(BForecast[] bForecastArray) {
        int n = 0;
        while (n < bForecastArray.length) {
            String string = "day" + n;
            BForecast bForecast = (BForecast)this.get(string);
            if (bForecast != null) {
                SlotCursor slotCursor = bForecast.getProperties();
                while (slotCursor.next()) {
                    Property property = slotCursor.property();
                    bForecast.set(property, bForecastArray[n].get(property).newCopy(true));
                }
            } else {
                this.add(string, (BValue)bForecastArray[n]);
            }
            ++n;
        }
    }

    public String getDisplayName(Slot slot, Context context) {
        if (slot.isProperty() && slot.asProperty().getType().is(BForecast.TYPE)) {
            String string = slot.getName();
            int n = Integer.parseInt(string.substring("day".length()));
            if (n == 0) {
                return lexToday;
            }
            if (n == 1) {
                return lexTomorrow;
            }
            BAbsTime bAbsTime = BAbsTime.now();
            int n2 = 0;
            while (n2 < n) {
                bAbsTime = bAbsTime.nextDay();
                ++n2;
            }
            return bAbsTime.getWeekday().toString();
        }
        return super.getDisplayName(slot, context);
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)provider)) {
            this.updateWeatherReport();
        }
        super.changed(property, context);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)updateWeatherReport)) {
            if (this.isRunning()) {
                BWeatherService bWeatherService = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
                bWeatherService.getQueue().enqueue((Object)new Invocation((BComponent)this, action, bValue, context));
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    public void doUpdateWeatherReport() {
        if (!this.isRunning()) {
            return;
        }
        try {
            BWeatherService bWeatherService = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
            if (bWeatherService.getEnabled()) {
                BWeatherProvider bWeatherProvider = this.getProvider();
                bWeatherProvider.updateReport();
                bWeatherProvider.updateSunStatus();
            }
        }
        catch (Exception exception) {
            BWeatherService.log.error("Unable to update", (Throwable)exception);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$weather$BWeatherReport;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BWeatherReport = BWeatherReport.class("[Ljavax.baja.weather.BWeatherReport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weather/icons/weatherReport.png");
        lex = Lexicon.make((String)"weather");
        lexToday = lex.getText("today");
        lexTomorrow = lex.getText("tomorrow");
    }
}

