/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BWeatherProvider
extends BComponent {
    public static final Action updateSunStatus = BWeatherProvider.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private Clock.Ticket updateSun;
    static /* synthetic */ Class class$javax$baja$weather$BWeatherProvider;

    public void updateSunStatus() {
        this.invoke(updateSunStatus, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract void updateReport();

    public void clockChanged(BRelTime bRelTime) {
        if (this.updateSun != null && !this.updateSun.isExpired()) {
            this.updateSun.cancel();
        }
        this.updateSunStatus();
    }

    public void doUpdateSunStatus() {
        boolean bl;
        boolean bl2;
        BAbsTime bAbsTime = BAbsTime.now();
        BWeatherReport bWeatherReport = (BWeatherReport)this.getParent();
        BCurrentConditions bCurrentConditions = bWeatherReport.getCurrent();
        if (!bCurrentConditions.getSunrise().equals((Object)bCurrentConditions.getSunset())) {
            boolean bl3;
            bl2 = bAbsTime.isBefore(BAbsTime.make((BAbsTime)bAbsTime, (BTime)bCurrentConditions.getSunrise()));
            bl = bAbsTime.isAfter(BAbsTime.make((BAbsTime)bAbsTime, (BTime)bCurrentConditions.getSunset()));
            boolean bl4 = false;
            if (bl2 || bl) {
                bl4 = bl3 = true;
            }
            if (bCurrentConditions.getSunDown().getValue() != bl3) {
                bCurrentConditions.setSunDown(new BStatusBoolean(bl3));
            }
        } else {
            BWeatherService.log.trace("Location " + bWeatherReport.getName() + " has no sunrise or sunset.");
        }
        if (this.updateSun == null || this.updateSun.isExpired()) {
            bl2 = false;
            bl = false;
            if (BAbsTime.make((BAbsTime)bAbsTime, (BTime)bCurrentConditions.getSunset()).isAfter(bAbsTime)) {
                bl2 = true;
            }
            if (BAbsTime.make((BAbsTime)bAbsTime, (BTime)bCurrentConditions.getSunrise()).isAfter(bAbsTime)) {
                bl = true;
            }
            if (bl && bl2) {
                BTime bTime = BTime.make((BRelTime)BRelTime.make((long)Math.min(bCurrentConditions.getSunset().getTimeOfDayMillis(), bCurrentConditions.getSunrise().getTimeOfDayMillis())));
                this.updateSun = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)bAbsTime, (BTime)bTime), (Action)updateSunStatus, null);
                BWeatherService.log.trace("Scheduled sun status update for " + bWeatherReport.getName() + " at " + bTime);
            } else if (bl) {
                this.updateSun = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)bAbsTime, (BTime)bCurrentConditions.getSunrise()), (Action)updateSunStatus, null);
                BWeatherService.log.trace("Scheduled sun status update for " + bWeatherReport.getName() + " at " + bCurrentConditions.getSunrise());
            } else if (bl2) {
                this.updateSun = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)bAbsTime, (BTime)bCurrentConditions.getSunset()), (Action)updateSunStatus, null);
                BWeatherService.log.trace("Scheduled sun status update for " + bWeatherReport.getName() + " at " + bCurrentConditions.getSunset());
            }
        }
        BWeatherService.log.trace("Updated sun status for " + bWeatherReport.getName());
    }

    public void stopped() throws Exception {
        if (this.updateSun != null) {
            this.updateSun.cancel();
        }
        super.stopped();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.updateSun = null;
    }

    public BWeatherProvider() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$weather$BWeatherProvider;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BWeatherProvider = BWeatherProvider.class("[Ljavax.baja.weather.BWeatherProvider;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weather/icons/weatherProvider.png");
    }
}

