/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.weather.BMoonPhase;
import javax.baja.weather.BWeatherService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMoonPosition
extends BComponent {
    public static final Property enabled = BMoonPosition.newProperty((int)0, (boolean)true, null);
    public static final Property updatePeriod = BMoonPosition.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property phase = BMoonPosition.newProperty((int)11, (BValue)BMoonPhase.newMoon, null);
    public static final Property age = BMoonPosition.newProperty((int)11, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"showDay", (BIDataValue)BBoolean.TRUE));
    public static final Property illumination = BMoonPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Action recalculate = BMoonPosition.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final double moonCycle = 29.530588853;
    private static final double firstNewMoon;
    private Clock.Ticket updateTicket;
    static /* synthetic */ Class class$javax$baja$weather$BMoonPosition;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime bRelTime) {
        this.set(updatePeriod, (BValue)bRelTime, null);
    }

    public BMoonPhase getPhase() {
        return (BMoonPhase)this.get(phase);
    }

    public void setPhase(BMoonPhase bMoonPhase) {
        this.set(phase, (BValue)bMoonPhase, null);
    }

    public BRelTime getAge() {
        return (BRelTime)this.get(age);
    }

    public void setAge(BRelTime bRelTime) {
        this.set(age, (BValue)bRelTime, null);
    }

    public int getIllumination() {
        return this.getInt(illumination);
    }

    public void setIllumination(int n) {
        this.setInt(illumination, n, null);
    }

    public void recalculate() {
        this.invoke(recalculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStationStarted() && this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public void stopped() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void stationStarted() {
        if (this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public static BMoonPosition make(BAbsTime bAbsTime) {
        BMoonPosition bMoonPosition = new BMoonPosition();
        bMoonPosition.doRecalculate(bAbsTime);
        return bMoonPosition;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled) || property.equals((Object)updatePeriod)) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isRunning()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            }
        }
    }

    public void doRecalculate() {
        this.doRecalculate(BAbsTime.now());
    }

    private final void doRecalculate(BAbsTime bAbsTime) {
        BWeatherService.log.trace("Calculating moon position");
        if (!this.getEnabled()) {
            return;
        }
        double d = BMoonPosition.getJulianDay(bAbsTime);
        double d2 = (d - firstNewMoon) / 29.530588853;
        double d3 = (d2 - Math.floor(d2)) * 29.530588853;
        if (d3 < 0.0) {
            d3 += 29.530588853;
        }
        this.setPhase(BMoonPhase.make((int)(Math.ceil((d3 - 1.8456618033125) / 3.691323606625) % 8.0)));
        this.setAge(BRelTime.makeMinutes((int)((int)(d3 * 24.0 * 60.0))));
        this.setIllumination((int)((0.5 + 0.5 * Math.sin(-1.94 + d3 * 0.22)) * 100.0));
    }

    private static final double getJulianDay(BAbsTime bAbsTime) {
        bAbsTime.toUtcTime();
        int n = bAbsTime.getYear();
        int n2 = bAbsTime.getMonth().getOrdinal() + 1;
        int n3 = bAbsTime.getDay();
        double d = (double)bAbsTime.getHour() + (double)bAbsTime.getMinute() / 60.0;
        return (double)((long)(-7 * (n + (n2 + 9) / 12) / 4 + 275 * n2 / 9 + n3) + (long)n * 367L) - 730530.0 + d / 24.0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$weather$BMoonPosition;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BMoonPosition = BMoonPosition.class("[Ljavax.baja.weather.BMoonPosition;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weather/icons/moon.png");
        firstNewMoon = BMoonPosition.getJulianDay(BAbsTime.make((int)2010, (BMonth)BMonth.january, (int)15, (int)7, (int)11, (int)0, (int)0, (BTimeZone)BTimeZone.UTC));
    }
}

