/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;
import javax.baja.weather.advisory.BAdvisoryContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCurrentConditions
extends BComponent
implements BIComparable {
    public static final Property status = BCurrentConditions.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property lastUpdate = BCurrentConditions.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property observed = BCurrentConditions.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property sunrise = BCurrentConditions.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    public static final Property sunset = BCurrentConditions.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    public static final Property sunDown = BCurrentConditions.newProperty((int)3, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property temp = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property weatherSummary = BCurrentConditions.newProperty((int)3, (BValue)new BStatusString("", BStatus.nullStatus), null);
    public static final Property state = BCurrentConditions.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWeatherState.clear), null);
    public static final Property humidity = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent relative humidity"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property windDirection = BCurrentConditions.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWindDirection.north, BStatus.nullStatus), null);
    public static final Property windSpeed = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    public static final Property windGust = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    public static final Property windChill = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property pressure = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"inches of mercury")));
    public static final Property dewPoint = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property heatIndex = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property visibility = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"mile")));
    public static final Property ozone = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"parts per million"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property particulateMatter = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"micrograms per cubic meter"), (String)"precision", (BIDataValue)BDouble.make((double)1.0)));
    public static final Property advisories = BCurrentConditions.newProperty((int)0, (BValue)new BAdvisoryContainer(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$weather$BCurrentConditions;
    static /* synthetic */ Class class$javax$baja$status$BStatusValue;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime bAbsTime) {
        this.set(lastUpdate, (BValue)bAbsTime, null);
    }

    public BAbsTime getObserved() {
        return (BAbsTime)this.get(observed);
    }

    public void setObserved(BAbsTime bAbsTime) {
        this.set(observed, (BValue)bAbsTime, null);
    }

    public BTime getSunrise() {
        return (BTime)this.get(sunrise);
    }

    public void setSunrise(BTime bTime) {
        this.set(sunrise, (BValue)bTime, null);
    }

    public BTime getSunset() {
        return (BTime)this.get(sunset);
    }

    public void setSunset(BTime bTime) {
        this.set(sunset, (BValue)bTime, null);
    }

    public BStatusBoolean getSunDown() {
        return (BStatusBoolean)this.get(sunDown);
    }

    public void setSunDown(BStatusBoolean bStatusBoolean) {
        this.set(sunDown, (BValue)bStatusBoolean, null);
    }

    public BStatusNumeric getTemp() {
        return (BStatusNumeric)this.get(temp);
    }

    public void setTemp(BStatusNumeric bStatusNumeric) {
        this.set(temp, (BValue)bStatusNumeric, null);
    }

    public BStatusString getWeatherSummary() {
        return (BStatusString)this.get(weatherSummary);
    }

    public void setWeatherSummary(BStatusString bStatusString) {
        this.set(weatherSummary, (BValue)bStatusString, null);
    }

    public BStatusEnum getState() {
        return (BStatusEnum)this.get(state);
    }

    public void setState(BStatusEnum bStatusEnum) {
        this.set(state, (BValue)bStatusEnum, null);
    }

    public BStatusNumeric getHumidity() {
        return (BStatusNumeric)this.get(humidity);
    }

    public void setHumidity(BStatusNumeric bStatusNumeric) {
        this.set(humidity, (BValue)bStatusNumeric, null);
    }

    public BStatusEnum getWindDirection() {
        return (BStatusEnum)this.get(windDirection);
    }

    public void setWindDirection(BStatusEnum bStatusEnum) {
        this.set(windDirection, (BValue)bStatusEnum, null);
    }

    public BStatusNumeric getWindSpeed() {
        return (BStatusNumeric)this.get(windSpeed);
    }

    public void setWindSpeed(BStatusNumeric bStatusNumeric) {
        this.set(windSpeed, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getWindGust() {
        return (BStatusNumeric)this.get(windGust);
    }

    public void setWindGust(BStatusNumeric bStatusNumeric) {
        this.set(windGust, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getWindChill() {
        return (BStatusNumeric)this.get(windChill);
    }

    public void setWindChill(BStatusNumeric bStatusNumeric) {
        this.set(windChill, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getPressure() {
        return (BStatusNumeric)this.get(pressure);
    }

    public void setPressure(BStatusNumeric bStatusNumeric) {
        this.set(pressure, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getDewPoint() {
        return (BStatusNumeric)this.get(dewPoint);
    }

    public void setDewPoint(BStatusNumeric bStatusNumeric) {
        this.set(dewPoint, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getHeatIndex() {
        return (BStatusNumeric)this.get(heatIndex);
    }

    public void setHeatIndex(BStatusNumeric bStatusNumeric) {
        this.set(heatIndex, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getVisibility() {
        return (BStatusNumeric)this.get(visibility);
    }

    public void setVisibility(BStatusNumeric bStatusNumeric) {
        this.set(visibility, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOzone() {
        return (BStatusNumeric)this.get(ozone);
    }

    public void setOzone(BStatusNumeric bStatusNumeric) {
        this.set(ozone, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getParticulateMatter() {
        return (BStatusNumeric)this.get(particulateMatter);
    }

    public void setParticulateMatter(BStatusNumeric bStatusNumeric) {
        this.set(particulateMatter, (BValue)bStatusNumeric, null);
    }

    public BAdvisoryContainer getAdvisories() {
        return (BAdvisoryContainer)this.get(advisories);
    }

    public void setAdvisories(BAdvisoryContainer bAdvisoryContainer) {
        this.set(advisories, (BValue)bAdvisoryContainer, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void setSun(double d, double d2) {
        BSunPosition bSunPosition = BSunPosition.make(d2, d);
        this.setSunrise(BTime.make((BAbsTime)bSunPosition.getSunrise()));
        this.setSunset(BTime.make((BAbsTime)bSunPosition.getSunset()));
        boolean bl = false;
        if (bSunPosition.getCurrentElevation() < 0.0) {
            bl = true;
        }
        this.setSunDown(new BStatusBoolean(bl, BStatus.ok));
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)status)) {
            Class clazz = class$javax$baja$status$BStatusValue;
            if (clazz == null) {
                clazz = class$javax$baja$status$BStatusValue = BCurrentConditions.class("[Ljavax.baja.status.BStatusValue;", false);
            }
            BStatusValue[] bStatusValueArray = (BStatusValue[])this.getChildren(clazz);
            int n = 0;
            while (n < bStatusValueArray.length) {
                bStatusValueArray[n].setStatus(BStatus.make((int)(bStatusValueArray[n].getStatus().getBits() & 0x48 | this.getStatus().getBits() & 0x16)));
                ++n;
            }
        }
        super.changed(property, context);
    }

    public String toString(Context context) {
        String string = this.getTemp().getValueValue().toString((Context)this.getSlotFacets((Slot)temp));
        String string2 = this.getState().getValueValue().toString((Context)this.getSlotFacets((Slot)state));
        if (this.getTemp().getStatus().isNull()) {
            string = "-";
        }
        if (this.getState().getStatus().isNull()) {
            string2 = "-";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(", ").append(string2);
        stringBuffer.append(" ").append(this.getStatus().toString(context));
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        if (!(object instanceof BCurrentConditions)) {
            return 0;
        }
        BCurrentConditions bCurrentConditions = (BCurrentConditions)((Object)object);
        return Double.compare(this.getTemp().getValue(), bCurrentConditions.getTemp().getValue());
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$weather$BCurrentConditions;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BCurrentConditions = BCurrentConditions.class("[Ljavax.baja.weather.BCurrentConditions;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weather/icons/weather.png");
    }
}

