/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.NwsStationList;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.AbstractSequentialList;
import java.util.Comparator;
import java.util.LinkedList;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.sys.BajaException;
import javax.baja.util.SortUtil;
import javax.baja.util.TextUtil;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

public class NwsStationListLoader {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        Object[] objectArray;
        Object object2;
        Object object3;
        NwsStationList nwsStationList = new NwsStationList();
        System.out.print("Loading zip code data...");
        LinkedList<ZipCode> linkedList = new LinkedList<ZipCode>();
        Object object4 = "http://www.census.gov:80/tiger/tms/gazetteer/zcta5.txt";
        Object object5 = NwsStationListLoader.loadUrl((String)object4);
        try {
            object3 = new BufferedReader(new InputStreamReader(object5.getInputStream()));
            while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                linkedList.add(new ZipCode(((String)object2).substring(2, 7).trim(), Double.parseDouble(((String)object2).substring(136, 146).trim()), Double.parseDouble(((String)object2).substring(146, 157).trim())));
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            object5.close();
            throw throwable;
        }
        {
            objectArray = null;
        }
        object5.close();
        System.out.println("done");
        System.out.print("Loading weather advisory zones...");
        object4 = new LinkedList();
        object5 = "http://www.nws.noaa.gov:80/geodata/catalog/wsom/data/bp15de11.dbx";
        Object object6 = NwsStationListLoader.loadUrl((String)object5);
        try {
            object2 = new BufferedReader(new InputStreamReader(object6.getInputStream()));
            while ((string = ((BufferedReader)object2).readLine()) != null) {
                try {
                    object = TextUtil.split((String)string, (char)'|');
                    if (((String[])object).length < 10 || object[4].length() <= 2) continue;
                    ((LinkedList)object4).add(new AlertZone(object[3], object[0] + 'Z' + object[1], Double.parseDouble(object[9]), Double.parseDouble(object[10])));
                }
                catch (Exception exception) {
                    System.out.print("unable to process: " + string + "...");
                }
            }
        }
        catch (Throwable throwable) {
            object3 = null;
            object6.close();
            throw throwable;
        }
        {
            object3 = null;
        }
        object6.close();
        System.out.println("done");
        System.out.print("Loading NWS station data...");
        object5 = new LinkedList();
        object6 = "http://www.weather.gov:80/xml/current_obs/index.xml";
        objectArray = NwsStationListLoader.loadUrl((String)object6);
        try {
            string = XParser.make((InputStream)objectArray.getInputStream()).parse();
            object = string.elems("station");
            int n = 0;
            while (n < ((String[])object).length) {
                XText xText = object[n].elem("station_id").text();
                if (xText != null) {
                    String string2 = xText.string();
                    double d = Double.parseDouble(object[n].elem("latitude").text().string());
                    double d2 = Double.parseDouble(object[n].elem("longitude").text().string());
                    if (d != 0.0 || d2 != 0.0) {
                        String string3 = object[n].elem("state").text().string();
                        NwsStationList.Station station = nwsStationList.getStation(string2);
                        String string4 = station == null ? object[n].elem("station_name").text().string() : station.name;
                        ((LinkedList)object5).add(new Station(string2, string3, string4, d, d2));
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            object2 = null;
            objectArray.close();
            throw throwable;
        }
        {
            object2 = null;
        }
        objectArray.close();
        System.out.println("done");
        System.out.print("Correlating data...");
        object6 = ((AbstractSequentialList)object5).iterator();
        block14: while (true) {
            double d;
            Position position;
            if (!object6.hasNext()) {
                System.out.println("done");
                System.out.print("Sorting data...");
                objectArray = ((LinkedList)object5).toArray();
                SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)new Comparator(){

                    public final int compare(Object object, Object object2) {
                        Station station = (Station)object;
                        Station station2 = (Station)object2;
                        switch (station.state.compareTo(station2.state)) {
                            case 0: {
                                return station.id.compareTo(station2.id);
                            }
                            case -1: {
                                return -1;
                            }
                            case 1: {
                                return 1;
                            }
                        }
                        return 0;
                    }
                });
                System.out.println("done");
                System.out.print("Writing nwsStationList.xml file...");
                object3 = stringArray.length > 0 ? new FileOutputStream(stringArray[0]) : new FileOutputStream("nwsStationList.xml");
            }
            objectArray = (Station)object6.next();
            object3 = ((AbstractSequentialList)object4).iterator();
            object2 = null;
            double d3 = Double.MAX_VALUE;
            while (true) {
                if (!object3.hasNext()) {
                    if (object2 != null) {
                        objectArray.zone = object2;
                    }
                    break;
                }
                position = (AlertZone)object3.next();
                d = NwsStationListLoader.distance(position, (Position)objectArray);
                if (!(d < d3) || !(d < 150.0)) continue;
                d3 = d;
                object2 = position;
            }
            object3 = linkedList.iterator();
            object2 = null;
            d3 = Double.MAX_VALUE;
            while (true) {
                if (!object3.hasNext()) {
                    if (object2 == null) continue block14;
                    objectArray.zipCode = object2;
                    continue block14;
                }
                position = (ZipCode)object3.next();
                d = NwsStationListLoader.distance(position, (Position)objectArray);
                if (!(d < d3) || !(d < 150.0)) continue;
                d3 = d;
                object2 = position;
            }
            break;
        }
        object2 = new PrintStream((OutputStream)object3);
        ((PrintStream)object2).println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        ((PrintStream)object2).println("<nwsStationList>");
        int n = 0;
        while (true) {
            if (n >= objectArray.length) {
                ((PrintStream)object2).println("</nwsStationList>");
                ((FileOutputStream)object3).close();
                System.out.println("done");
                System.out.println("Reticulating splines...done");
                System.out.print("Writing nwsStationList.kml file...");
                object3 = stringArray.length > 1 ? new FileOutputStream(stringArray[1]) : new FileOutputStream("nwsStationList.kml");
            }
            object = (Station)objectArray[n];
            ((PrintStream)object2).print("\t<s ");
            ((PrintStream)object2).print("s=\"" + object.state + "\" ");
            ((PrintStream)object2).print("i=\"" + object.id + "\" ");
            if (object.descr != null && object.descr.length() > 0) {
                ((PrintStream)object2).print("n=\"" + object.descr + "\" ");
            }
            if (object.descr != null && object.descr.length() > 0) {
                ((PrintStream)object2).print("x=\"" + object.lat + "\" ");
                ((PrintStream)object2).print("y=\"" + object.lon + "\" ");
                if (object.zone != null) {
                    ((PrintStream)object2).print("z=\"" + object.zone.zone + "\" ");
                }
                if (object.zipCode != null) {
                    ((PrintStream)object2).print("c=\"" + object.zipCode.code + "\" ");
                }
            }
            ((PrintStream)object2).print("/>\n");
            ++n;
        }
        object2 = new PrintStream((OutputStream)object3);
        ((PrintStream)object2).println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        ((PrintStream)object2).println("<kml xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        ((PrintStream)object2).println("\t<Document>");
        n = 0;
        while (true) {
            if (n >= objectArray.length) {
                ((PrintStream)object2).println("\t</Document>");
                ((PrintStream)object2).println("</kml>");
                ((FileOutputStream)object3).close();
                System.out.println("done");
                return;
            }
            object = (Station)objectArray[n];
            if (object.descr != null && object.descr.length() != 0) {
                ((PrintStream)object2).println("\t\t<Placemark>");
                ((PrintStream)object2).println("\t\t\t<name>" + object.descr + " [" + object.id + "]</name>");
                ((PrintStream)object2).println("\t\t\t<Point>");
                ((PrintStream)object2).println("\t\t\t\t<coordinates>" + object.lon + ',' + object.lat + ",0</coordinates>");
                ((PrintStream)object2).println("\t\t\t</Point>");
                ((PrintStream)object2).println("\t\t</Placemark>");
            }
            ++n;
        }
    }

    private static final double distance(Position position, Position position2) {
        double d = Math.PI / 180.0;
        double d2 = position.getLon() * d;
        double d3 = position.getLat() * d;
        double d4 = position2.getLon() * d;
        double d5 = position2.getLat() * d;
        double d6 = 6371.0;
        return Math.acos(Math.sin(d3) * Math.sin(d5) + Math.cos(d3) * Math.cos(d5) * Math.cos(d4 - d2)) * d6;
    }

    private static final HttpConnection loadUrl(String string) throws Exception {
        URL uRL = new URL(string);
        HttpConnection httpConnection = new HttpConnection((BHost)new BIpHost(uRL.getHost()), uRL.getPort(), uRL.getPath());
        httpConnection.setTimeout(BNwsWeatherProvider.READ_TIMEOUT);
        httpConnection.connect(BNwsWeatherProvider.CONNECT_TIMEOUT);
        if (httpConnection.getStatusCode() / 100 != 2) {
            throw new BajaException("" + httpConnection.getStatusCode() + ' ' + httpConnection.getStatusMessage(), (Throwable)new Exception(uRL.toString()));
        }
        return httpConnection;
    }

    private static class ZipCode
    implements Position {
        String code;
        double lat;
        double lon;

        public String toString() {
            return this.code;
        }

        public double getLon() {
            return this.lon;
        }

        public double getLat() {
            return this.lat;
        }

        public ZipCode(String string, double d, double d2) {
            this.code = string;
            this.lat = d;
            this.lon = d2;
        }
    }

    private static class AlertZone
    implements Position {
        String zone;
        String descr;
        double lat;
        double lon;

        public double getLon() {
            return this.lon;
        }

        public double getLat() {
            return this.lat;
        }

        public AlertZone(String string, String string2, double d, double d2) {
            this.descr = string;
            this.zone = string2;
            this.lat = d;
            this.lon = d2;
        }
    }

    private static class Station
    implements Position {
        String id;
        AlertZone zone;
        ZipCode zipCode;
        String state;
        String descr;
        double lat;
        double lon;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.id);
            stringBuffer.append("\t");
            stringBuffer.append(this.zone.descr);
            stringBuffer.append(" (");
            stringBuffer.append(this.zone.zone);
            stringBuffer.append(") ");
            stringBuffer.append(NwsStationListLoader.distance(this.zone, this));
            stringBuffer.append(" ");
            stringBuffer.append(this.lat);
            stringBuffer.append(",");
            stringBuffer.append(this.lon);
            return stringBuffer.toString();
        }

        public double getLon() {
            return this.lon;
        }

        public double getLat() {
            return this.lat;
        }

        public Station(String string, String string2, String string3, double d, double d2) {
            this.id = string;
            this.state = string2;
            this.lat = d;
            this.lon = d2;
            this.descr = string3;
        }
    }

    private static interface Position {
        public double getLon();

        public double getLat();
    }
}

