/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.NwsStationList;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherState;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

public class NwsForecastReader {
    static final Log log = Log.getLog((String)"weather");
    BNwsWeatherProvider provider;

    XElem getFeed(NwsStationList.Station station, int n) throws Exception {
        return this.getFeed(station, n, this.provider.getForecastServer(), this.provider.getForecastPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XElem getFeed(NwsStationList.Station station, int n, String string, String string2) throws Exception {
        XElem xElem;
        HttpConnection httpConnection;
        StringBuffer stringBuffer;
        block10: {
            XElem xElem2;
            String string3 = BAbsTime.now().toString((Context)BFacets.make((String)"timeFormat", (String)"YYYY-MM-DD"));
            stringBuffer = new StringBuffer(string2);
            stringBuffer.append("?");
            stringBuffer.append("&lat=").append(station.latitude);
            stringBuffer.append("&lon=").append(station.longitude);
            stringBuffer.append("&format=24+hourly");
            stringBuffer.append("&startDate=").append(string3);
            stringBuffer.append("&numDays=").append(n);
            httpConnection = new HttpConnection((BHost)new BIpHost(string), 80, stringBuffer.toString());
            try {
                httpConnection.setTimeout(BNwsWeatherProvider.READ_TIMEOUT);
                httpConnection.connect(BNwsWeatherProvider.CONNECT_TIMEOUT);
                if (httpConnection.getStatusCode() != 301 && httpConnection.getStatusCode() != 302) break block10;
                log.trace("Redirect to " + httpConnection.getResponseHeader("Location"));
                URL uRL = new URL(httpConnection.getResponseHeader("Location"));
                xElem2 = this.getFeed(station, n, uRL.getHost(), uRL.getPath() + '?' + uRL.getQuery());
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                httpConnection.close();
                throw throwable;
            }
            httpConnection.close();
            return xElem2;
        }
        if (httpConnection.getStatusCode() / 100 != 2) {
            throw new BajaException("" + httpConnection.getStatusCode() + ' ' + httpConnection.getStatusMessage(), (Throwable)new Exception(this.provider.getConditionsServer() + string2));
        }
        XParser xParser = XParser.make((InputStream)httpConnection.getInputStream());
        try {
            xElem = xParser.parse();
        }
        catch (Exception exception) {
            throw new BajaException("Response improperly formatted: " + stringBuffer.toString(), (Throwable)exception);
        }
        if (xElem.name().equals("error")) {
            XElem xElem3 = xElem.elem("pre");
            if (xElem3 != null) {
                XText xText;
                XElem xElem4 = xElem3.elem("problem");
                if (xElem4 != null && (xText = xElem4.text()) != null) {
                    throw new NwsException(xText.toString());
                }
                xText = xElem3.text();
                if (xText != null) {
                    throw new NwsException(xText.toString());
                }
            }
            throw new NwsException();
        }
        XElem xElem5 = xElem.elem("data");
        Object var9_13 = null;
        httpConnection.close();
        return xElem5;
    }

    public BForecast[] getForecast(NwsStationList.Station station, int n) throws Exception {
        XElem xElem = this.getFeed(station, n);
        BForecast[] bForecastArray = this.parseDwml(xElem);
        int n2 = 0;
        while (n2 < bForecastArray.length) {
            bForecastArray[n2].setSun(bForecastArray[n2].getDate(), station.latitude, station.longitude);
            ++n2;
        }
        return bForecastArray;
    }

    private final BForecast[] parseDwml(XElem xElem) {
        BForecast[] bForecastArray;
        BStatusNumeric[] bStatusNumericArray = new BStatusNumeric[]{};
        BStatusNumeric[] bStatusNumericArray2 = new BStatusNumeric[]{};
        BStatusNumeric[] bStatusNumericArray3 = new BStatusNumeric[]{};
        BStatusString[] bStatusStringArray = new BStatusString[]{};
        XElem[] xElemArray = null;
        XElem[] xElemArray2 = xElem.elems();
        int n = 0;
        while (n < xElemArray2.length) {
            if (xElemArray2[n].name().equals("parameters")) {
                xElemArray = xElemArray2[n].elems();
            }
            ++n;
        }
        n = 0;
        while (n < xElemArray.length) {
            bForecastArray = xElemArray[n];
            if (bForecastArray.name().equals("temperature")) {
                String string = bForecastArray.get("type", "");
                if (string.equals("maximum")) {
                    bStatusNumericArray = this.parseTemp((XElem)bForecastArray);
                } else if (string.equals("minimum")) {
                    bStatusNumericArray2 = this.parseTemp((XElem)bForecastArray);
                }
            } else if (bForecastArray.name().equals("probability-of-precipitation")) {
                bStatusNumericArray3 = this.parseCop((XElem)bForecastArray);
            } else if (bForecastArray.name().equals("weather")) {
                bStatusStringArray = this.parseSummary((XElem)bForecastArray);
            }
            ++n;
        }
        BAbsTime bAbsTime = BAbsTime.now();
        bForecastArray = new BForecast[Math.min(bStatusNumericArray.length, bStatusNumericArray2.length)];
        int n2 = 0;
        while (n2 < bForecastArray.length) {
            BForecast bForecast = bForecastArray[n2] = new BForecast();
            bForecast.setLastUpdate(BAbsTime.now());
            bForecast.setDate(bAbsTime);
            bForecast.setHigh(bStatusNumericArray[n2]);
            bForecast.setLow(bStatusNumericArray2[n2]);
            bForecast.setPrecipChance(bStatusNumericArray3[n2]);
            if (bStatusStringArray.length > 0) {
                BWeatherState bWeatherState = BWeatherState.make(bStatusStringArray[n2].getValue());
                bForecast.setWeatherSummary(bStatusStringArray[n2]);
                bForecast.setState(new BStatusEnum((BEnum)bWeatherState));
            } else {
                bForecast.setWeatherSummary(new BStatusString("Unknown"));
                bForecast.setState(new BStatusEnum((BEnum)BWeatherState.unknown));
            }
            bAbsTime = bAbsTime.nextDay();
            ++n2;
        }
        return bForecastArray;
    }

    private final BStatusNumeric[] parseTemp(XElem xElem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("value")) {
                arrayList.add(xElemArray[n].string());
            }
            ++n;
        }
        BStatusNumeric[] bStatusNumericArray = new BStatusNumeric[arrayList.size()];
        int n2 = 0;
        while (n2 < bStatusNumericArray.length) {
            try {
                bStatusNumericArray[n2] = new BStatusNumeric((double)Float.parseFloat((String)arrayList.get(n2)));
            }
            catch (Exception exception) {
                bStatusNumericArray[n2] = new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            ++n2;
        }
        return bStatusNumericArray;
    }

    private final BStatusNumeric[] parseCop(XElem xElem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("value")) {
                arrayList.add(xElemArray[n].string());
            }
            ++n;
        }
        BStatusNumeric[] bStatusNumericArray = new BStatusNumeric[arrayList.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < bStatusNumericArray.length) {
            try {
                int n4 = Integer.parseInt((String)arrayList.get(n3++));
                int n5 = Integer.parseInt((String)arrayList.get(n3));
                bStatusNumericArray[n2] = new BStatusNumeric((double)((int)(((double)n4 + (double)n5) / (double)2)));
            }
            catch (Exception exception) {
                bStatusNumericArray[n2] = new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            ++n2;
            ++n3;
        }
        return bStatusNumericArray;
    }

    private final BStatusString[] parseSummary(XElem xElem) {
        ArrayList<BStatusString> arrayList = new ArrayList<BStatusString>();
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("weather-conditions")) {
                String string = xElemArray[n].get("weather-summary", null);
                if (string != null) {
                    arrayList.add(new BStatusString(string));
                } else {
                    arrayList.add(new BStatusString("", BStatus.nullStatus));
                }
            }
            ++n;
        }
        return arrayList.toArray(new BStatusString[arrayList.size()]);
    }

    public static void main(String[] stringArray) throws Exception {
        NwsStationList.Station station = new NwsStationList.Station();
        station.latitude = 37.616;
        station.longitude = -77.636;
        int n = 3;
        if (stringArray.length == 3) {
            station.latitude = Double.parseDouble(stringArray[0]);
            station.longitude = Double.parseDouble(stringArray[1]);
            n = Integer.parseInt(stringArray[2]);
        }
        NwsForecastReader nwsForecastReader = new NwsForecastReader(new BNwsWeatherProvider());
        BForecast[] bForecastArray = nwsForecastReader.getForecast(station, n);
        int n2 = 0;
        while (n2 < bForecastArray.length) {
            BForecast bForecast = bForecastArray[n2];
            System.out.println("");
            System.out.println(bForecast.getDate());
            System.out.println("  high: " + bForecast.getHigh());
            System.out.println("   low: " + bForecast.getLow());
            System.out.println("   cop: " + bForecast.getPrecipChance());
            System.out.println("   sum: " + bForecast.getWeatherSummary());
            ++n2;
        }
    }

    public NwsForecastReader(BNwsWeatherProvider bNwsWeatherProvider) {
        this.provider = bNwsWeatherProvider;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NwsException
    extends Exception {
        public NwsException(String string) {
            super(string);
        }

        public NwsException() {
        }
    }
}

