/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.AirQualityIndexUtil;
import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.NwsStationList;
import java.io.EOFException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.status.BStatus;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherService;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class EpaForecastReader {
    static final Log log = Log.getLog((String)"weather");
    BNwsWeatherProvider provider;

    XElem getFeed(NwsStationList.Station station, BForecast[] bForecastArray) throws Exception {
        BWeatherService bWeatherService = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
        String string = bWeatherService.getAirQualityApiKey();
        if (string.equals("")) {
            throw new Exception("Air Quality API key has not been set.");
        }
        String string2 = "/aq/forecast/zipCode/?format=application/xml&zipCode=" + station.zipCode + "&API_KEY=" + string;
        String string3 = "www.airnowapi.org";
        return this.getFeed(station, bForecastArray, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XElem getFeed(NwsStationList.Station station, BForecast[] bForecastArray, String string, String string2) throws Exception {
        HttpConnection httpConnection;
        block7: {
            XElem xElem;
            httpConnection = new HttpConnection((BHost)new BIpHost(string), 80, string2);
            try {
                httpConnection.setTimeout(BNwsWeatherProvider.READ_TIMEOUT);
                httpConnection.connect(BNwsWeatherProvider.CONNECT_TIMEOUT);
                if (httpConnection.getStatusCode() != 301 && httpConnection.getStatusCode() != 302) break block7;
                log.trace("Redirect to " + httpConnection.getResponseHeader("Location"));
                URL uRL = new URL(httpConnection.getResponseHeader("Location"));
                xElem = this.getFeed(station, bForecastArray, uRL.getHost(), uRL.getPath() + '?' + uRL.getQuery());
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                httpConnection.close();
                throw throwable;
            }
            httpConnection.close();
            return xElem;
        }
        if (httpConnection.getStatusCode() / 100 != 2) {
            throw new BajaException("" + httpConnection.getStatusCode() + ' ' + httpConnection.getStatusMessage(), (Throwable)new Exception(this.provider.getConditionsServer() + string2));
        }
        String string3 = new String(httpConnection.readContent());
        XElem xElem = null;
        try {
            xElem = XParser.make((String)string3).parse();
        }
        catch (EOFException eOFException) {
            if (string3.indexOf("Incorrect Key provided") != -1) {
                throw new Exception("Invalid Air Quality API Key provided.");
            }
            throw eOFException;
        }
        XElem xElem2 = xElem;
        Object var7_11 = null;
        httpConnection.close();
        return xElem2;
    }

    public BForecast[] getForecast(NwsStationList.Station station, BForecast[] bForecastArray) throws Exception {
        int n;
        if (station.zipCode == null) {
            return bForecastArray;
        }
        if (!this.provider.getAirQualityEnabled() && (n = 0) < bForecastArray.length) {
            bForecastArray[n].getOzone().setValue(Double.NaN);
            bForecastArray[n].getOzone().setStatus(BStatus.nullStatus);
            bForecastArray[n].getParticulateMatter().setValue(Double.NaN);
            bForecastArray[n].getParticulateMatter().setStatus(BStatus.nullStatus);
            return bForecastArray;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d/yyyy hh:mm:ss a");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getLocal().getJavaTimeZone());
        XElem[] xElemArray = new XElem[]{};
        boolean bl = false;
        try {
            XElem xElem = this.getFeed(station, bForecastArray);
            xElemArray = xElem.elems("ForecastByZip");
            if (xElemArray.length == 0) {
                if (xElem.name().equals("WebServiceError")) {
                    if (xElem.elem("Message").text().string().indexOf("Web service request limit exceeded") != -1) {
                        log.warning("Exceeded Air Quality request limit. Change the poll frequency, or request a new API key from http://airnowapi.org/");
                    } else {
                        log.warning("Air Quality web service error.");
                    }
                } else if (xElem.name().equals("ForecastByZipList")) {
                    log.warning("No air quality reporting stations nearby.");
                } else {
                    log.warning("Air Quality unknown error.");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            log.error("Unable to retrieve EPA air quality forecast.", (Throwable)exception);
            bl = true;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < bForecastArray.length) {
                bForecastArray[n2].getOzone().setStatus(BStatus.makeStale((BStatus)bForecastArray[n2].getOzone().getStatus(), (boolean)true));
                bForecastArray[n2].getParticulateMatter().setStatus(BStatus.makeStale((BStatus)bForecastArray[n2].getParticulateMatter().getStatus(), (boolean)true));
                ++n2;
            }
            return bForecastArray;
        }
        int n3 = 0;
        while (n3 < bForecastArray.length) {
            boolean bl2 = false;
            boolean bl3 = false;
            int n4 = 0;
            while (n4 < xElemArray.length) {
                try {
                    double d;
                    int n5;
                    if (!bl2 && xElemArray[n4].elem("ParameterName").text().string().equalsIgnoreCase("ozone")) {
                        gregorianCalendar.setTime(simpleDateFormat.parse(xElemArray[n4].elem("DateForecast").text().string()));
                        if (bForecastArray[n3].getDate().getDay() == gregorianCalendar.get(5) && bForecastArray[n3].getDate().getMonth().getOrdinal() == gregorianCalendar.get(2) && (n5 = Integer.parseInt(xElemArray[n4].elem("AQI").text().string())) >= 0) {
                            d = AirQualityIndexUtil.aqiToOzoneConcentration(n5);
                            bForecastArray[n3].getOzone().setValue(d);
                            bForecastArray[n3].getOzone().setStatus(BStatus.ok);
                            bl2 = true;
                        }
                    }
                    if (!bl3 && xElemArray[n4].elem("ParameterName").text().string().equalsIgnoreCase("pm2.5")) {
                        gregorianCalendar.setTime(simpleDateFormat.parse(xElemArray[n4].elem("DateForecast").text().string()));
                        if (bForecastArray[n3].getDate().getDay() == gregorianCalendar.get(5) && bForecastArray[n3].getDate().getMonth().getOrdinal() == gregorianCalendar.get(2) && (n5 = Integer.parseInt(xElemArray[n4].elem("AQI").text().string())) >= 0) {
                            d = AirQualityIndexUtil.aqiToParticulateConcentration(n5);
                            bForecastArray[n3].getParticulateMatter().setValue(d);
                            bForecastArray[n3].getParticulateMatter().setStatus(BStatus.ok);
                            bl3 = true;
                        }
                    }
                }
                catch (Exception exception) {
                    log.warning("Difficulty parsing EPA air quality forecast.", (Throwable)exception);
                }
                ++n4;
            }
            if (!bl2) {
                bForecastArray[n3].getOzone().setValue(Double.NaN);
                bForecastArray[n3].getOzone().setStatus(64);
            }
            if (!bl3) {
                bForecastArray[n3].getParticulateMatter().setValue(Double.NaN);
                bForecastArray[n3].getParticulateMatter().setStatus(64);
            }
            ++n3;
        }
        return bForecastArray;
    }

    public EpaForecastReader(BNwsWeatherProvider bNwsWeatherProvider) {
        this.provider = bNwsWeatherProvider;
    }
}

