/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.AirQualityIndexUtil;
import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.NwsStationList;
import java.io.EOFException;
import java.net.URL;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.status.BStatus;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherService;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class EpaCurrentReader {
    static final Log log = Log.getLog((String)"weather");
    BNwsWeatherProvider provider;

    XElem getFeed(NwsStationList.Station station) throws Exception {
        BWeatherService bWeatherService = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
        String string = bWeatherService.getAirQualityApiKey();
        if (string.equals("")) {
            throw new Exception("Air Quality API key has not been set.");
        }
        String string2 = "/aq/observation/zipCode/current/?format=application/xml&zipCode=" + station.zipCode + "&API_KEY=" + string;
        String string3 = "www.airnowapi.org";
        return this.getFeed(station, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XElem getFeed(NwsStationList.Station station, String string, String string2) throws Exception {
        HttpConnection httpConnection;
        block7: {
            XElem xElem;
            httpConnection = new HttpConnection((BHost)new BIpHost(string), 80, string2);
            try {
                httpConnection.setTimeout(BNwsWeatherProvider.READ_TIMEOUT);
                httpConnection.connect(BNwsWeatherProvider.CONNECT_TIMEOUT);
                if (httpConnection.getStatusCode() != 301 && httpConnection.getStatusCode() != 302) break block7;
                log.trace("Redirect to " + httpConnection.getResponseHeader("Location"));
                URL uRL = new URL(httpConnection.getResponseHeader("Location"));
                xElem = this.getFeed(station, uRL.getHost(), uRL.getPath() + '?' + uRL.getQuery());
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                httpConnection.close();
                throw throwable;
            }
            httpConnection.close();
            return xElem;
        }
        if (httpConnection.getStatusCode() / 100 != 2) {
            throw new BajaException("" + httpConnection.getStatusCode() + ' ' + httpConnection.getStatusMessage(), (Throwable)new Exception(this.provider.getConditionsServer() + string2));
        }
        String string3 = new String(httpConnection.readContent());
        XElem xElem = null;
        try {
            xElem = XParser.make((String)string3).parse();
        }
        catch (EOFException eOFException) {
            if (string3.indexOf("Incorrect Key provided") != -1) {
                throw new Exception("Invalid Air Quality API Key provided.");
            }
            throw eOFException;
        }
        XElem xElem2 = xElem;
        Object var6_10 = null;
        httpConnection.close();
        return xElem2;
    }

    public void getCurrent(BNwsWeatherProvider bNwsWeatherProvider, BCurrentConditions bCurrentConditions, NwsStationList.Station station) throws Exception {
        if (station.zipCode == null) {
            return;
        }
        if (!bNwsWeatherProvider.getAirQualityEnabled()) {
            bCurrentConditions.getOzone().setValue(Double.NaN);
            bCurrentConditions.getOzone().setStatus(BStatus.nullStatus);
            bCurrentConditions.getParticulateMatter().setValue(Double.NaN);
            bCurrentConditions.getParticulateMatter().setStatus(BStatus.nullStatus);
            return;
        }
        XElem[] xElemArray = new XElem[]{};
        boolean bl = false;
        try {
            XElem xElem = this.getFeed(station);
            xElemArray = xElem.elems("ObsByZip");
            if (xElemArray.length == 0) {
                if (xElem.name().equals("WebServiceError")) {
                    if (xElem.elem("Message").text().string().indexOf("Web service request limit exceeded") != -1) {
                        log.warning("Exceeded Air quality request limit. Change the poll frequency, or request a new API key from http://airnowapi.org/");
                    } else {
                        log.warning("Air quality web service error.");
                    }
                } else if (xElem.name().equals("ObsByZipList")) {
                    log.warning("No air quality reporting stations nearby.");
                } else {
                    log.warning("Air quality unknown error.");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            log.error("Unable to retrieve EPA current air quality.", (Throwable)exception);
            bl = true;
        }
        if (bl) {
            bCurrentConditions.getOzone().setStatus(BStatus.makeStale((BStatus)bCurrentConditions.getOzone().getStatus(), (boolean)true));
            bCurrentConditions.getParticulateMatter().setStatus(BStatus.makeStale((BStatus)bCurrentConditions.getParticulateMatter().getStatus(), (boolean)true));
            return;
        }
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < xElemArray.length) {
                XElem xElem = xElemArray[n];
                try {
                    double d;
                    int n2;
                    if (xElem.elem("ParameterName").text().string().equalsIgnoreCase("ozone")) {
                        try {
                            n2 = Integer.parseInt(xElem.elem("AQI").text().string());
                            d = AirQualityIndexUtil.aqiToOzoneConcentration(n2);
                            bCurrentConditions.getOzone().setValue(d);
                            bCurrentConditions.getOzone().setStatus(BStatus.ok);
                            bl2 = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (xElem.elem("ParameterName").text().string().equalsIgnoreCase("pm2.5")) {
                        try {
                            n2 = Integer.parseInt(xElem.elem("AQI").text().string());
                            d = AirQualityIndexUtil.aqiToParticulateConcentration(n2);
                            bCurrentConditions.getParticulateMatter().setValue(d);
                            bCurrentConditions.getParticulateMatter().setStatus(BStatus.ok);
                            bl3 = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (Exception exception) {
                    log.warning("Difficulty parsing current air quality data.", (Throwable)exception);
                }
                ++n;
            }
            if (!bl2) {
                bCurrentConditions.getOzone().setValue(Double.NaN);
                bCurrentConditions.getOzone().setStatus(BStatus.nullStatus);
            }
            if (!bl3) {
                bCurrentConditions.getParticulateMatter().setValue(Double.NaN);
                bCurrentConditions.getParticulateMatter().setStatus(BStatus.nullStatus);
            }
        }
        catch (Exception exception) {
            log.error("Unable to get current air quality data.", (Throwable)exception);
            bCurrentConditions.getOzone().setValue(Double.NaN);
            bCurrentConditions.getOzone().setStatus(BStatus.fault);
            bCurrentConditions.getParticulateMatter().setValue(Double.NaN);
            bCurrentConditions.getParticulateMatter().setStatus(BStatus.fault);
        }
    }

    public EpaCurrentReader(BNwsWeatherProvider bNwsWeatherProvider) {
        this.provider = bNwsWeatherProvider;
    }
}

