/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.util;

import com.tridium.crypto.core.cert.TridiumX509TrustManager;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.baja.nre.util.ByteArrayUtil;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TridiumAppletX509TrustManager
extends TridiumX509TrustManager
implements X509TrustManager {
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        block2: {
            try {
                this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
            }
            catch (Exception exception) {
                String string2 = TridiumAppletX509TrustManager.extractSHA1Fingerprint(x509CertificateArray[0]);
                String string3 = System.getProperty("sha1FingerPrint", "");
                if (string2.equalsIgnoreCase(string3)) break block2;
                throw new CertificateException("sha1 fingerprints don't match", exception);
            }
        }
    }

    private static final String extractSHA1Fingerprint(X509Certificate x509Certificate) {
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byArray = messageDigest.digest(x509Certificate.getEncoded());
        }
        catch (Exception exception) {
            return "???";
        }
        return ByteArrayUtil.toHexString((byte[])byArray, (String)":");
    }

    public TridiumAppletX509TrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        int n = 0;
        while (n < trustManagerArray.length) {
            if (trustManagerArray[n] instanceof X509TrustManager) {
                this.defaultTrustManager = (X509TrustManager)trustManagerArray[n];
                return;
            }
            ++n;
        }
        throw new Exception("Error intializing trust manager");
    }
}

