/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.util;

import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumCertValidator;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platcrypto.core.IExtCryptoManager;
import com.tridium.util.BSessionInfo;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSslSessionInfo
extends BSessionInfo {
    public static final Type TYPE;
    private static Lexicon lex;
    private NX509Certificate cert;
    private String protocol;
    private String cipherSuite;
    private boolean hostnameVerified;
    private boolean validCertChain;
    private boolean certExpired;
    static /* synthetic */ Class class$com$tridium$platcrypto$util$BSslSessionInfo;

    public Type getType() {
        return TYPE;
    }

    public static BSessionInfo make(String string, BAbsTime bAbsTime, Socket socket, String string2) {
        return new BSslSessionInfo(string, bAbsTime, socket, string2);
    }

    public BIcon getIdentityVerifiedIcon() {
        if (!this.hostnameVerified || !this.validCertChain || this.certExpired) {
            return BIcon.make((String)lex.getText("session.info.identityVerified.failed.icon"));
        }
        return BIcon.make((String)lex.getText("session.info.identityVerified.succeeded.icon"));
    }

    public String getIdentityVerifiedMessage() {
        if (!this.hostnameVerified || !this.validCertChain || this.certExpired) {
            StringBuffer stringBuffer = new StringBuffer(lex.getText("session.info.identityVerified.failed.title")).append("\n");
            if (!this.hostnameVerified) {
                stringBuffer.append(" - " + lex.getText("session.info.identityVerified.failed.hostnameMismatch")).append("\n");
            }
            if (!this.validCertChain) {
                stringBuffer.append(" - " + lex.getText("session.info.identityVerified.failed.certValidation")).append("\n");
            }
            if (this.certExpired) {
                stringBuffer.append(" - " + lex.getText("session.info.identityVerified.failed.certExpired")).append("\n");
            }
            return stringBuffer.toString();
        }
        return lex.getText("session.info.identityVerified.succeeded", new Object[]{this.cert.getIssuer()});
    }

    public BIcon getSessionEncryptedIcon() {
        return BIcon.make((String)lex.getText("session.info.sessionEncrypted.icon"));
    }

    public String getSessionEncryptedMessage() {
        return lex.getText("session.info.sessionEncrypted", new Object[]{this.hostname, "" + CryptoSupport.getEncryptionBits((String)this.cipherSuite), this.protocol, CryptoSupport.getEncryptionCipher((String)this.cipherSuite), CryptoSupport.getMessageAuthCipher((String)this.cipherSuite), CryptoSupport.getKeyExchangeCipher((String)this.cipherSuite)});
    }

    public String getProtocol() {
        return this.protocol;
    }

    public NX509Certificate getCertificate() {
        return this.cert;
    }

    public String toString(Context context) {
        return "SslSessionInfo: cert=" + this.cert.getSubject() + ", protocol=" + this.protocol + ", cipherSuite=" + this.cipherSuite + ", hostnameVerified=" + this.hostnameVerified + ", validCertChain=" + this.validCertChain + ", certExpired=" + this.certExpired;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cert = null;
        this.protocol = null;
        this.cipherSuite = null;
        this.hostnameVerified = false;
        this.validCertChain = false;
        this.certExpired = false;
    }

    public BSslSessionInfo() {
        this.this();
    }

    public BSslSessionInfo(String string, BAbsTime bAbsTime, Socket socket, String string2) {
        super(string, bAbsTime, string2);
        this.this();
        SSLSocket sSLSocket = (SSLSocket)socket;
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession != null) {
            this.cipherSuite = sSLSession.getCipherSuite();
            this.protocol = sSLSession.getProtocol();
            try {
                Certificate[] certificateArray = sSLSession.getPeerCertificates();
                if (certificateArray != null && certificateArray.length > 0 && certificateArray[0] instanceof java.security.cert.X509Certificate) {
                    this.cert = NX509Certificate.make((java.security.cert.X509Certificate)((java.security.cert.X509Certificate)certificateArray[0]));
                }
                X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
                java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
                int n = 0;
                while (n < x509CertificateArray.length) {
                    x509CertificateArray2[n] = NX509Certificate.convert((X509Certificate)x509CertificateArray[n]);
                    ++n;
                }
                IExtCryptoManager iExtCryptoManager = (IExtCryptoManager)CertManagerFactory.getInstance();
                String string3 = sSLSession.getPeerHost();
                String string4 = sSLSession.getPeerHost() + ':' + sSLSession.getPeerPort();
                CertValidationResult certValidationResult = TridiumCertValidator.validateCertificate((java.security.cert.X509Certificate[])x509CertificateArray2, (ICoreCryptoManager)iExtCryptoManager.getCoreCryptoManager(), (String)string3, (String)string4);
                this.hostnameVerified = certValidationResult.isHostnameVerified();
                this.validCertChain = certValidationResult.isValidCertChain();
                this.certExpired = certValidationResult.isCertExpired();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        Class clazz = class$com$tridium$platcrypto$util$BSslSessionInfo;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$util$BSslSessionInfo = BSslSessionInfo.class("[Lcom.tridium.platcrypto.util.BSslSessionInfo;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
    }
}

