/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BX509ExtensionPane
extends BEdgePane {
    public static final Type TYPE;
    private static final List OID_READONLY_LIST;
    private BCheckBox[] selected;
    private NX509Extension[] extensions;
    private boolean selectable;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BX509ExtensionPane;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERObjectIdentifier;

    public Type getType() {
        return TYPE;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public int getExtensionCount() {
        if (this.extensions == null) {
            return 0;
        }
        return this.extensions.length;
    }

    public boolean isSelected(int n) {
        if (this.extensions == null) {
            return false;
        }
        if (n > this.extensions.length - 1) {
            return false;
        }
        if (this.selected == null) {
            return false;
        }
        if (n > this.selected.length - 1) {
            return false;
        }
        return this.selected[n].getSelected();
    }

    public NX509Extension getExtension(int n) {
        return this.extensions[n];
    }

    public void setExtensions(NX509Extension[] nX509ExtensionArray, boolean bl) {
        this.extensions = nX509ExtensionArray;
        this.selectable = bl;
        this.buildExtensions();
    }

    protected BWidget createPaddedLabel(String string) {
        BLabel bLabel = new BLabel(string, BHalign.left);
        bLabel.setFont(Theme.label().getFixedWidthFont((IStylable)bLabel));
        BBorderPane bBorderPane = new BBorderPane((BWidget)bLabel, 0.0, (double)5, 0.0, (double)5);
        return bBorderPane;
    }

    private final void buildExtensions() {
        BGridPane bGridPane;
        if (this.selectable) {
            bGridPane = new BGridPane(2);
            bGridPane.setStretchColumn(1);
        } else {
            bGridPane = new BGridPane(1);
            bGridPane.setStretchColumn(0);
        }
        bGridPane.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)bGridPane, (String)"scrolled");
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setHalign(BHalign.left);
        ArrayList<BEdgePane> arrayList = new ArrayList<BEdgePane>();
        int n = 0;
        while (n < this.extensions.length) {
            BBorderPane bBorderPane;
            BEdgePane bEdgePane;
            if (this.selectable) {
                bEdgePane = new BCheckBox("", true);
                if (this.checkReadOnlyExtension(this.extensions[n])) {
                    bEdgePane.setEnabled(false);
                }
                arrayList.add(bEdgePane);
                bBorderPane = new BBorderPane((BWidget)bEdgePane, 0.0, 10.0, 0.0, 10.0);
                bGridPane.add(null, (BValue)bBorderPane);
            }
            bEdgePane = new BEdgePane();
            bEdgePane.setTop(this.createPaddedLabel("Identifier: " + this.extensions[n].getIdentifier()));
            bBorderPane = this.extensions[n].getExtensionText();
            StringBuffer stringBuffer = new StringBuffer("isCritical: " + (this.extensions[n].isCritical() ? "true" : "false"));
            int n2 = 0;
            while (n2 < ((BBorderPane)bBorderPane).length) {
                stringBuffer.append("\n");
                stringBuffer.append((String)bBorderPane[n2]);
                ++n2;
            }
            bEdgePane.setCenter(this.createPaddedLabel(stringBuffer.toString()));
            BConstrainedPane bConstrainedPane = new BConstrainedPane();
            bConstrainedPane.setMinWidth(15.0);
            bEdgePane.setLeft((BWidget)bConstrainedPane);
            bGridPane.add(null, (BValue)bEdgePane);
            ++n;
        }
        this.selected = arrayList.toArray(new BCheckBox[0]);
        this.setCenter((BWidget)bGridPane);
    }

    private final boolean checkReadOnlyExtension(NX509Extension nX509Extension) {
        if (OID_READONLY_LIST.contains(nX509Extension.getOid())) {
            return true;
        }
        try {
            if (nX509Extension.getOid().getId().equals("2.5.29.18")) {
                Class clazz = nX509Extension.getObject().getType();
                Class clazz2 = class$org$bouncycastle$asn1$DERObjectIdentifier;
                if (clazz2 == null) {
                    clazz2 = class$org$bouncycastle$asn1$DERObjectIdentifier = BX509ExtensionPane.class("[Lorg.bouncycastle.asn1.DERObjectIdentifier;", false);
                }
                if (clazz == clazz2 && nX509Extension.getObject().getValue() == "tridiumHostId") {
                    return true;
                }
                if (this.checkForTridiumHostId(nX509Extension.getObject())) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private final boolean checkForTridiumHostId(NX509Extension.NASN1Primitive nASN1Primitive) {
        if ("tridiumHostId".equals(nASN1Primitive.getValue())) {
            return true;
        }
        NX509Extension.NASN1Primitive[] nASN1PrimitiveArray = nASN1Primitive.getChildren();
        int n = 0;
        while (n < nASN1PrimitiveArray.length) {
            if (this.checkForTridiumHostId(nASN1PrimitiveArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.extensions = null;
        this.selectable = false;
    }

    public BX509ExtensionPane() {
        this.this();
    }

    public BX509ExtensionPane(NX509Extension[] nX509ExtensionArray) {
        this.this();
        this.extensions = nX509ExtensionArray;
        this.buildExtensions();
    }

    public BX509ExtensionPane(NX509Extension[] nX509ExtensionArray, boolean bl) {
        this.this();
        this.extensions = nX509ExtensionArray;
        this.selectable = bl;
        this.buildExtensions();
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BX509ExtensionPane;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BX509ExtensionPane = BX509ExtensionPane.class("[Lcom.tridium.platcrypto.ui.BX509ExtensionPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        OID_READONLY_LIST = Arrays.asList("2.5.29.19", "2.5.29.37", "2.5.29.15", "2.5.29.14", "1.3.6.1.4.1.4131.2");
    }
}

