/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.platcrypto.ui.BCertImportDialog;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ListIterator;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTrustCertsTable
extends BCertsTable {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BTrustCertsTable;
    static /* synthetic */ Class class$java$security$cert$X509Certificate;

    public Type getType() {
        return TYPE;
    }

    protected void initCommands() {
        this.getCommandBindings().setSupport((CommandBindings.Support)this);
        BCertsTable.ViewCommand viewCommand = new BCertsTable.ViewCommand();
        this.addCommand(viewCommand, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(viewCommand);
        this.addCommand(new BCertsTable.DeleteCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new TrustImportCommand(), BCommandEnablePolicy.always);
        this.addCommand(new BCertsTable.ExportCommand(), BCommandEnablePolicy.singleSelection);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BTrustCertsTable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BTrustCertsTable(ICoreKeyStore iCoreKeyStore) throws Exception {
        super(iCoreKeyStore);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BTrustCertsTable;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BTrustCertsTable = BTrustCertsTable.class("[Lcom.tridium.platcrypto.ui.BTrustCertsTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class TrustImportCommand
    extends BCertsTable.ImportCommand {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() {
            try {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                bFileChooser.setTitle(lex.getText("cert.import.chooser.title"));
                bFileChooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("cert.extension.info"), "pem,p12,crt,cer,cert"));
                bFileChooser.setCurrentDirectory(BOrd.make((String)("file:/" + BTrustCertsTable.getCertsDirectoryPath())));
                BOrd bOrd = bFileChooser.show();
                if (bOrd == null) {
                    return null;
                }
                BIFile bIFile = (BIFile)bOrd.get();
                if (bIFile == null) return null;
                Class clazz = class$java$security$cert$X509Certificate;
                if (clazz == null) {
                    clazz = class$java$security$cert$X509Certificate = BTrustCertsTable.class("[Ljava.security.cert.X509Certificate;", false);
                }
                Array array = new Array(clazz);
                InputStreamReader inputStreamReader = new InputStreamReader(bIFile.getInputStream());
                FriendlyPemReader friendlyPemReader = new FriendlyPemReader((Reader)inputStreamReader);
                PEMParser pEMParser = new PEMParser((Reader)friendlyPemReader);
                try {
                    Object object = null;
                    do {
                        try {
                            object = pEMParser.readObject();
                            if (object == null) continue;
                            if (object instanceof X509Certificate) {
                                array.add(object);
                                continue;
                            }
                            if (object instanceof X509CertificateHolder) {
                                X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)object);
                                array.add((Object)x509Certificate);
                                continue;
                            }
                            if (object instanceof PEMKeyPair || object instanceof PEMEncryptedKeyPair) continue;
                            throw new IOException("unsupported object type: " + object.getClass().getName());
                        }
                        catch (PasswordException passwordException) {
                            log.trace("skipping private key during trust store import");
                            object = new Object();
                        }
                    } while (object != null);
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    try {
                        pEMParser.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                {
                    Object var9_15 = null;
                }
                try {}
                catch (Exception exception) {}
                pEMParser.close();
                String string = bIFile.getFileName();
                string = string.substring(0, string.length() - bIFile.getExtension().length() - 1);
                this.importCertData(array, null, string);
                BTrustCertsTable.this.mgr.save();
                BTrustCertsTable.this.certModel().load();
                return null;
            }
            catch (EncryptionException encryptionException) {
                BDialog.error((BWidget)this.getOwner(), (Object)lex.get("cert.import.privatekey.badpassword"));
                return null;
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        protected void importCertData(Array array, PrivateKey privateKey, String string) throws Exception {
            ListIterator listIterator = array.iterator();
            while (listIterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)listIterator.next();
                if (!NX509Certificate.isSelfSigned((X509Certificate)x509Certificate)) {
                    throw new IOException("certificate in the trust store must be root certificates");
                }
                String string2 = BTrustCertsTable.this.mgr.findCertificate(x509Certificate);
                if (string2 == null) {
                    string2 = string;
                }
                NX509Certificate nX509Certificate = NX509Certificate.make((X509Certificate)x509Certificate);
                string2 = BCertImportDialog.prompt(this.getOwner(), nX509Certificate, string2, false);
                if (string2 == null) continue;
                BTrustCertsTable.this.mgr.setCertificateEntry(string2, x509Certificate);
            }
        }

        protected TrustImportCommand() {
        }
    }
}

