/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.platcrypto.ui.BCertImportDialog;
import com.tridium.platcrypto.ui.BCertRequestDialog;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BPasswordPromptDialog;
import com.tridium.platcrypto.ui.BPrivateKeyPasswordDialog;
import com.tridium.platcrypto.ui.BSelfSignedDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BConstrainedPane;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLocalCertsTable
extends BCertsTable {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BLocalCertsTable;

    public Type getType() {
        return TYPE;
    }

    protected void initCommands() {
        this.getCommandBindings().setSupport((CommandBindings.Support)this);
        BCertsTable.ViewCommand viewCommand = new BCertsTable.ViewCommand();
        this.addCommand(viewCommand, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(viewCommand);
        this.addCommand(new NewCommand(), BCommandEnablePolicy.always);
        this.addCommand(new CsrCommand(), BCommandEnablePolicy.singleSelection);
        this.addCommand(new BCertsTable.DeleteCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new LocalImportCommand(), BCommandEnablePolicy.always);
        this.addCommand(new BCertsTable.ExportCommand(), BCommandEnablePolicy.singleSelection);
        this.addCommand(new ResetCommand(), BCommandEnablePolicy.always);
        this.setCommandEnabledStates();
    }

    private final void certGenRequest(BWidget bWidget) {
        BCertsTable.CertGenRequest certGenRequest = BSelfSignedDialog.show(bWidget, this.mgr);
        if (certGenRequest != null) {
            this.certGenRequests.put(certGenRequest.getRequestId(), (Object)certGenRequest);
            this.checkCertMonitorThread();
            BDialog.info((BWidget)bWidget, (Object)lex.get("cert.generate.notify.msg"));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BLocalCertsTable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BLocalCertsTable(ICoreKeyStore iCoreKeyStore) throws Exception {
        super(iCoreKeyStore);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BLocalCertsTable;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BLocalCertsTable = BLocalCertsTable.class("[Lcom.tridium.platcrypto.ui.BLocalCertsTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class NewCommand
    extends Command {
        public CommandArtifact doInvoke() {
            if (!BLocalCertsTable.this.mgr.canGenerateCertificate()) {
                BDialog.open((BWidget)BLocalCertsTable.this.getParentWidget(), (String)lex.getText("station.running.dialog.title"), (Object)lex.getText("station.running.dialog.message"), (int)1, (BImage)BDialog.WARNING_ICON, null);
            } else {
                BLocalCertsTable.this.certGenRequest(this.getOwner());
            }
            return null;
        }

        public NewCommand() {
            super((BWidget)BLocalCertsTable.this, lex, "cert.button.new");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class CsrCommand
    extends Command {
        public CommandArtifact doInvoke() {
            block7: {
                try {
                    BPassword bPassword;
                    PrivateKey privateKey;
                    int n = BLocalCertsTable.this.certModel().getSelection().getRow();
                    if (!BCertRequestDialog.request(this.getOwner(), BLocalCertsTable.this.certModel().cert(n).getCertificate(0))) break block7;
                    String string = BLocalCertsTable.this.certModel().cert(n).getAlias();
                    String string2 = null;
                    try {
                        privateKey = (PrivateKey)BLocalCertsTable.this.mgr.getKey(string, null);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        bPassword = BPasswordPromptDialog.open(this.getOwner(), lex.getText("cert.pkey.dialog.title"), lex.getText("cert.pkey.dialog.info"));
                        if (bPassword == null) {
                            return null;
                        }
                        string2 = bPassword.getValue();
                    }
                    privateKey = BLocalCertsTable.this.mgr.generateCSR(string, string2);
                    if (privateKey != null) {
                        bPassword = BFileChooser.makeSave((BWidget)this.getOwner());
                        bPassword.addFilter((IFileFilter)new ExtFileFilter(lex.getText("csr.extension.info"), "csr"));
                        bPassword.setTitle(lex.getText(lex.getText("csr.filechooser.dialog.title")));
                        bPassword.setDefaultFileName(string + ".csr");
                        bPassword.setCurrentDirectory(BOrd.make((String)("file:/" + BLocalCertsTable.getCertsDirectoryPath())));
                        BOrd bOrd = bPassword.show();
                        if (bOrd == null) {
                            return null;
                        }
                        BIFile bIFile = (BIFile)bOrd.get();
                        PEMWriter pEMWriter = new PEMWriter((Writer)new OutputStreamWriter(bIFile.getOutputStream()));
                        pEMWriter.writeObject((Object)new PKCS10CertificationRequest(privateKey.getRequest().getEncoded()));
                        pEMWriter.close();
                        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BLabel(lex.getText("csr.generate.complete")));
                        bConstrainedPane.setMinWidth(200.0);
                        BDialog.info((BWidget)this.getOwner(), (String)lex.getText("csr.extension.info"), (Object)bConstrainedPane);
                    }
                }
                catch (Exception exception) {
                    CommandUtil.error((Command)this, (Throwable)exception);
                }
            }
            return null;
        }

        public CsrCommand() {
            super((BWidget)BLocalCertsTable.this, lex, "cert.button.csr");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class LocalImportCommand
    extends BCertsTable.ImportCommand {
        protected void importCertData(Array array, PrivateKey privateKey, String string) throws Exception {
            X509Certificate[] x509CertificateArray = (X509Certificate[])array.trim();
            if (x509CertificateArray.length <= 0) {
                BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.certificate.missing.title"), (Object)lex.get("cert.import.certificate.missing.msg"));
                return;
            }
            NX509Certificate nX509Certificate = NX509Certificate.make((X509Certificate)x509CertificateArray[0]);
            String string2 = BLocalCertsTable.this.mgr.findCertificate((X509Certificate)array.get(0));
            if (string2 != null) {
                string2 = BCertImportDialog.prompt(this.getOwner(), nX509Certificate, string2, true);
                if (string2 == null) {
                    return;
                }
                if (nX509Certificate.getCertificate().getBasicConstraints() >= 0) {
                    BPassword bPassword = BPrivateKeyPasswordDialog.open(this.getOwner());
                    if (bPassword == null) {
                        return;
                    }
                    if (privateKey == null && (privateKey = (PrivateKey)BLocalCertsTable.this.mgr.getKey(string2, bPassword.getValue().toCharArray())) == null) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.missing.title"), (Object)lex.get("cert.import.privatekey.missing.msg"));
                        return;
                    }
                    BLocalCertsTable.this.mgr.setKeyEntry(string2, (Key)privateKey, bPassword.getValue().toCharArray(), x509CertificateArray);
                } else {
                    if (privateKey == null && (privateKey = (PrivateKey)BLocalCertsTable.this.mgr.getKey(string2, null)) == null) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.missing.title"), (Object)lex.get("cert.import.privatekey.missing.msg"));
                        return;
                    }
                    BLocalCertsTable.this.mgr.setKeyEntry(string2, (Key)privateKey, null, x509CertificateArray);
                }
            } else {
                string2 = BCertImportDialog.prompt(this.getOwner(), nX509Certificate, string, false);
                if (string2 == null) {
                    return;
                }
                if (string2.trim().length() <= 0) {
                    BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.alias.missing.title"), (Object)lex.get("cert.import.alias.missing.msg"));
                    return;
                }
                X509Certificate x509Certificate = BLocalCertsTable.this.mgr.getCertificate(string2);
                if (x509Certificate != null && !x509Certificate.getPublicKey().equals(nX509Certificate.getPublicKey())) {
                    BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.mismatch.title"), (Object)lex.get("cert.import.privatekey.mismatch.msg"));
                    return;
                }
                if (nX509Certificate.getCertificate().getBasicConstraints() >= 0) {
                    BPassword bPassword = BPrivateKeyPasswordDialog.open(this.getOwner());
                    if (bPassword == null) {
                        return;
                    }
                    if (privateKey == null && (privateKey = (PrivateKey)BLocalCertsTable.this.mgr.getKey(string2, bPassword.getValue().toCharArray())) == null) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.missing.title"), (Object)lex.get("cert.import.privatekey.missing.msg"));
                        return;
                    }
                    BLocalCertsTable.this.mgr.setKeyEntry(string2, (Key)privateKey, bPassword.getValue().toCharArray(), x509CertificateArray);
                } else {
                    if (privateKey == null) {
                        try {
                            privateKey = (PrivateKey)BLocalCertsTable.this.mgr.getKey(string2, null);
                        }
                        catch (Exception exception) {}
                        if (privateKey == null) {
                            BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.missing.title"), (Object)lex.get("cert.import.privatekey.missing.msg"));
                            return;
                        }
                    }
                    BLocalCertsTable.this.mgr.setKeyEntry(string2, (Key)privateKey, null, x509CertificateArray);
                }
            }
        }

        protected LocalImportCommand() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ResetCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BLocalCertsTable.this, (String)lex.getText("cert.reset.dialog.title"), (Object)lex.getText("cert.reset.dialog.info"), (int)12)) {
                    Enumeration enumeration = BLocalCertsTable.this.mgr.aliases();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (enumeration.hasMoreElements()) {
                        arrayList.add((String)enumeration.nextElement());
                    }
                    BLocalCertsTable.this.mgr.deleteEntries(arrayList.toArray(new String[0]));
                    BLocalCertsTable.this.mgr.save();
                    BLocalCertsTable.this.certModel().load();
                    Calendar calendar = Calendar.getInstance();
                    Date date = calendar.getTime();
                    calendar.set(1, calendar.get(1) + 1);
                    Date date2 = calendar.getTime();
                    if (!BLocalCertsTable.this.mgr.canGenerateCertificate()) {
                        BDialog.open((BWidget)BLocalCertsTable.this.getParentWidget(), (String)lex.getText("station.running.dialog.title"), (Object)lex.getText("station.running.dialog.message"), (int)1, (BImage)BDialog.WARNING_ICON, null);
                    } else {
                        String string = "tridium";
                        int n = BLocalCertsTable.this.mgr.generateSelfSignedCert(string, "CN=NiagaraAX,O=Tridium,C=US", date, date2, 1024, 160, null, null);
                        if (n != -1) {
                            BCertsTable.CertGenRequest certGenRequest = new BCertsTable.CertGenRequest(n, string);
                            BLocalCertsTable.this.certGenRequests.put(n, (Object)certGenRequest);
                            BLocalCertsTable.this.checkCertMonitorThread();
                            BDialog.info((BWidget)this.getOwner(), (Object)lex.get("cert.generate.notify.msg"));
                        } else {
                            log.message("cert generation failed for " + string);
                            BLocalCertsTable.this.notify(lex.get("cert.generate.title"), failedIcon, lex.get("cert.generate.failed"), lex.getText("cert.generate.failed.msg", (Object[])new String[]{string}));
                        }
                    }
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public ResetCommand() {
            super((BWidget)BLocalCertsTable.this, lex, "cert.button.reset");
        }
    }
}

