/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.nre.util.PlatformUtil;
import com.tridium.platcrypto.ui.BCertEntryViewDialog;
import com.tridium.platcrypto.ui.BTrustCertsTable;
import com.tridium.platcrypto.ui.PrivateKeyPasswordFinder;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.util.BNotifyPane;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BCertsTable
extends BCommandBoundTable
implements CommandBindings.Support {
    public static final Type TYPE;
    public static final int COL_ALIAS = 0;
    public static final int COL_ISSUER = 1;
    public static final int COL_SUBJECT = 2;
    public static final int COL_NOT_BEFORE = 3;
    public static final int COL_NOT_AFTER = 4;
    public static final int COL_KEY_ALG = 5;
    public static final int COL_KEY_SIZE = 6;
    public static final int COL_SIG_ALG = 7;
    public static final int COL_SIG_SIZE = 8;
    public static final int COL_VALID = 9;
    public static final int COL_SELF_SIGNED = 10;
    protected static Log log;
    public static final Lexicon lex;
    public static final ExtFileFilter PEM_FILTER;
    private static String certsDirectoryPath;
    static final BImage securityHigh;
    static final BImage securityMedium;
    static final BImage securityLow;
    static final BImage jobIcon;
    static final BImage successIcon;
    static final BImage failedIcon;
    static final BImage unknownIcon;
    protected IntHashMap certGenRequests;
    protected CertGenMonitor certGenMonitor;
    protected ICoreKeyStore mgr;
    protected boolean readonly;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BCertsTable;
    static /* synthetic */ Class class$java$security$cert$X509Certificate;

    public Type getType() {
        return TYPE;
    }

    public void load() throws Exception {
        this.certModel().load();
    }

    private static final void initCertDirectory() {
        File file = Sys.getBajaHome();
        if (file.getPath().contains("wbapplet")) {
            file = file.getParentFile().getParentFile();
        }
        file = new File(file, "certManagement");
        file.mkdir();
        certsDirectoryPath = file.toString().replace("\\", "/");
    }

    protected static String getCertsDirectoryPath() {
        if (certsDirectoryPath == null) {
            BCertsTable.initCertDirectory();
        }
        return certsDirectoryPath;
    }

    protected abstract void initCommands();

    protected CertModel certModel() {
        DynamicTableModel dynamicTableModel = (DynamicTableModel)this.getModel();
        return (CertModel)dynamicTableModel.getRootModel();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        this.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (this.readonly && (command instanceof ImportCommand || command instanceof DeleteCommand)) {
            command.setEnabled(false);
        } else {
            command.setEnabled(bl);
        }
    }

    protected synchronized void checkCertMonitorThread() {
        if (this.certGenMonitor == null || !this.certGenMonitor.isAlive()) {
            this.certGenMonitor = new CertGenMonitor();
            this.certGenMonitor.start();
        }
    }

    protected void notify(String string, BImage bImage, String string2, String string3) {
        BLabel bLabel = new BLabel(jobIcon, string);
        bLabel.setFont(Theme.widget().getBoldText());
        BLabel bLabel2 = new BLabel(bImage, string2);
        BLabel bLabel3 = new BLabel(string3);
        bLabel3.setForeground(Theme.widget().getControlShadow());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)bLabel);
        bGridPane.add(null, (BValue)bLabel2);
        bGridPane.add(null, (BValue)bLabel3);
        BNotifyPane bNotifyPane = new BNotifyPane();
        bNotifyPane.setCenter((BWidget)bGridPane);
        bNotifyPane.open();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.certGenRequests = new IntHashMap();
        this.certGenMonitor = null;
        this.mgr = null;
        this.readonly = false;
    }

    public BCertsTable() throws UnsupportedOperationException {
        this.this();
        throw new UnsupportedOperationException();
    }

    public BCertsTable(ICoreKeyStore iCoreKeyStore) throws Exception {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 9;
        super((TableModel)new DynamicTableModel((TableModel)new CertModel(iCoreKeyStore), nArray));
        this.this();
        this.mgr = iCoreKeyStore;
        this.initCommands();
        BCertsTable.initCertDirectory();
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BCertsTable;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BCertsTable = BCertsTable.class("[Lcom.tridium.platcrypto.ui.BCertsTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"crypto");
        lex = Lexicon.make((String)"platCrypto");
        PEM_FILTER = new ExtFileFilter("", "pem,crt,cer");
        certsDirectoryPath = null;
        securityHigh = BImage.make((String)lex.get("security.high.x16.icon", "module://icons/x16/security-high.png"));
        securityMedium = BImage.make((String)lex.get("security.medium.x16.icon", "module://icons/x16/security-medium.png"));
        securityLow = BImage.make((String)lex.get("security.low.x16.icon", "module://icons/x16/security-low.png"));
        jobIcon = BImage.make((String)"module://icons/x16/doc.png");
        successIcon = BImage.make((String)"module://icons/x16/job/success.png");
        failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
        unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected static class CertModel
    extends TableModel {
        protected Array certs;
        protected ICoreKeyStore mgr;
        static /* synthetic */ Class class$com$tridium$crypto$core$cert$NX509CertificateEntry;

        public BImage getRowIcon(int n) {
            if (this.getTable() instanceof BTrustCertsTable) {
                return securityHigh;
            }
            try {
                if (!this.cert(n).getCertificate(0).isSelfSigned()) {
                    return securityHigh;
                }
                return securityMedium;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return securityLow;
            }
        }

        public void load() throws Exception {
            Enumeration enumeration = this.mgr.getCertificates();
            Class clazz = class$com$tridium$crypto$core$cert$NX509CertificateEntry;
            if (clazz == null) {
                clazz = class$com$tridium$crypto$core$cert$NX509CertificateEntry = CertModel.class("[Lcom.tridium.crypto.core.cert.NX509CertificateEntry;", false);
            }
            this.certs = new Array(clazz);
            while (enumeration.hasMoreElements()) {
                this.certs.add(enumeration.nextElement());
            }
            this.updateTable(true);
        }

        public int getColumnCount() {
            return 11;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("cert.field.alias");
                }
                case 1: {
                    return lex.getText("cert.field.issuedBy");
                }
                case 2: {
                    return lex.getText("cert.field.subject");
                }
                case 3: {
                    return lex.getText("cert.field.notBefore");
                }
                case 4: {
                    return lex.getText("cert.field.notAfter");
                }
                case 5: {
                    return lex.getText("cert.field.keyAlgorithm");
                }
                case 6: {
                    return lex.getText("cert.field.keySize");
                }
                case 7: {
                    return lex.getText("cert.field.signatureAlgorithm");
                }
                case 8: {
                    return lex.getText("cert.field.signatureSize");
                }
                case 10: {
                    return lex.getText("cert.field.selfSigned");
                }
                case 9: {
                    return lex.getText("cert.field.valid");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public synchronized void sortByColumn(int n, boolean bl) {
            Object[] objectArray = this.getColumnValues(n);
            Object[] objectArray2 = this.certs.trim();
            SortUtil.sort((Object[])objectArray, (Object[])objectArray2, (boolean)bl);
            this.certs.clear();
            this.certs.addAll(objectArray2);
        }

        public int getRowCount() {
            int n = 0;
            if (this.certs != null) {
                n = this.certs.size();
            }
            return n;
        }

        public NX509CertificateEntry cert(int n) {
            return (NX509CertificateEntry)this.certs.get(n);
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.cert(n).getAlias();
                }
                case 1: {
                    return this.cert(n).getCertificate(0).getIssuer();
                }
                case 2: {
                    return this.cert(n).getCertificate(0).getSubject();
                }
                case 3: {
                    return this.cert(n).getCertificate(0).getNotBefore();
                }
                case 4: {
                    return this.cert(n).getCertificate(0).getNotAfter();
                }
                case 5: {
                    return this.cert(n).getCertificate(0).getKeyAlgorithm();
                }
                case 6: {
                    return "" + this.cert(n).getCertificate(0).getKeySize();
                }
                case 7: {
                    return this.cert(n).getCertificate(0).getSignatureAlgorithm();
                }
                case 8: {
                    return "" + this.cert(n).getCertificate(0).getSignatureSize();
                }
                case 10: {
                    return this.cert(n).getCertificate(0).isSelfSigned() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false");
                }
                case 9: {
                    return this.cert(n).getCertificate(0).checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public CertModel(ICoreKeyStore iCoreKeyStore) {
            this.mgr = iCoreKeyStore;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class ImportCommand
    extends Command {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() {
            try {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                bFileChooser.setTitle(lex.getText("cert.import.chooser.title"));
                bFileChooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("cert.extension.info"), "pem,p12,crt,cer,cert"));
                bFileChooser.setCurrentDirectory(BOrd.make((String)("file:/" + certsDirectoryPath)));
                BOrd bOrd = bFileChooser.show();
                if (bOrd == null) {
                    return null;
                }
                BIFile bIFile = (BIFile)bOrd.get();
                if (bIFile == null) return null;
                Class clazz = class$java$security$cert$X509Certificate;
                if (clazz == null) {
                    clazz = class$java$security$cert$X509Certificate = BCertsTable.class("[Ljava.security.cert.X509Certificate;", false);
                }
                Array array = new Array(clazz);
                PrivateKey privateKey = null;
                InputStreamReader inputStreamReader = new InputStreamReader(bIFile.getInputStream());
                FriendlyPemReader friendlyPemReader = new FriendlyPemReader((Reader)inputStreamReader);
                PEMParser pEMParser = new PEMParser((Reader)friendlyPemReader);
                try {
                    try {
                        Object object = pEMParser.readObject();
                        while (object != null) {
                            X509Certificate x509Certificate;
                            if (object instanceof X509Certificate) {
                                array.add(object);
                            } else if (object instanceof X509CertificateHolder) {
                                x509Certificate = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)object);
                                array.add((Object)x509Certificate);
                            } else if (object instanceof PrivateKey) {
                                if (privateKey != null) throw new IOException("can't import multiple private keys from one file");
                                privateKey = (PrivateKey)object;
                            } else if (object instanceof KeyPair) {
                                if (privateKey != null) throw new IOException("can't import multiple private keys from one file");
                                privateKey = ((KeyPair)object).getPrivate();
                            } else if (object instanceof PEMKeyPair) {
                                if (privateKey != null) throw new IOException("can't import multiple private keys from one file");
                                privateKey = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider()).getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
                            } else {
                                if (!(object instanceof PEMEncryptedKeyPair)) throw new IOException("unsupported object type: " + object.getClass().getName());
                                if (privateKey != null) throw new IOException("can't import multiple private keys from one file");
                                x509Certificate = new JcePEMDecryptorProviderBuilder().setProvider((Provider)new BouncyCastleProvider());
                                PEMDecryptorProvider pEMDecryptorProvider = x509Certificate.build(new PrivateKeyPasswordFinder(this.getOwner()).getPassword());
                                JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
                                privateKey = jcaPEMKeyConverter.getPrivateKey(((PEMEncryptedKeyPair)object).decryptKeyPair(pEMDecryptorProvider).getPrivateKeyInfo());
                            }
                            object = pEMParser.readObject();
                        }
                    }
                    catch (PasswordException passwordException) {
                        BDialog.error((BWidget)this.getOwner(), (Object)lex.get("cert.import.privatekey.badpassword"));
                        CommandArtifact commandArtifact = null;
                        Object var10_17 = null;
                        try {
                            pEMParser.close();
                            return commandArtifact;
                        }
                        catch (Exception exception) {}
                        return commandArtifact;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_18 = null;
                    try {}
                    catch (Exception exception) {}
                    pEMParser.close();
                    throw throwable;
                    throw throwable;
                }
                {
                    Object var10_19 = null;
                }
                try {}
                catch (Exception exception) {}
                pEMParser.close();
                String string = bIFile.getFileName();
                string = string.substring(0, string.length() - bIFile.getExtension().length() - 1);
                this.importCertData(array, privateKey, string);
                BCertsTable.this.mgr.save();
                BCertsTable.this.certModel().load();
                return null;
            }
            catch (EncryptionException encryptionException) {
                BDialog.error((BWidget)this.getOwner(), (Object)lex.get("cert.import.privatekey.badpassword"));
                return null;
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        protected abstract void importCertData(Array var1, PrivateKey var2, String var3) throws Exception;

        public ImportCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.import");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DeleteCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BCertsTable.this, (String)lex.getText("cert.delete.dialog.title"), (Object)lex.getText("cert.delete.dialog.info"), (int)12)) {
                    int[] nArray = BCertsTable.this.getSelection().getRows();
                    String[] stringArray = new String[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        stringArray[n] = BCertsTable.this.certModel().cert(nArray[n]).getAlias();
                        log.trace("request to delete alias " + stringArray[n]);
                        ++n;
                    }
                    BCertsTable.this.mgr.deleteEntries(stringArray);
                    BCertsTable.this.mgr.save();
                    BCertsTable.this.certModel().load();
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public DeleteCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.delete");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class CertGenMonitor
    extends Thread {
        public void run() {
            do {
                IntHashMap.Iterator iterator = BCertsTable.this.certGenRequests.iterator();
                while (iterator.hasNext()) {
                    try {
                        CertGenRequest certGenRequest = (CertGenRequest)iterator.next();
                        int n = BCertsTable.this.mgr.getCertGenerationStatus(certGenRequest.requestId);
                        if (n == -1) {
                            BCertsTable.this.certGenRequests.remove(certGenRequest.requestId);
                            log.message("cert generation failed for " + certGenRequest.getAlias());
                            BCertsTable.this.notify(lex.get("cert.generate.title"), failedIcon, lex.get("cert.generate.failed"), lex.getText("cert.generate.failed.msg", (Object[])new String[]{certGenRequest.getAlias()}));
                            continue;
                        }
                        if (n == 2) {
                            BCertsTable.this.certGenRequests.remove(certGenRequest.requestId);
                            log.message("cert generation succeeded for " + certGenRequest.getAlias());
                            BCertsTable.this.notify(lex.get("cert.generate.title"), successIcon, lex.get("cert.generate.success"), lex.getText("cert.generate.success.msg", (Object[])new String[]{certGenRequest.getAlias()}));
                            BCertsTable.this.certModel().load();
                            continue;
                        }
                        long l = PlatformUtil.ticks();
                        if (l - certGenRequest.submitted <= 3600000L) continue;
                        BCertsTable.this.certModel().load();
                    }
                    catch (NotConnectedException notConnectedException) {
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(2500L);
                }
                catch (Exception exception) {}
            } while (!BCertsTable.this.certGenRequests.isEmpty());
        }

        public CertGenMonitor() {
            super("tCertGenMonitor");
        }
    }

    static class CertGenRequest {
        private int requestId;
        private String alias;
        private long submitted;

        public int getRequestId() {
            return this.requestId;
        }

        public String getAlias() {
            return this.alias;
        }

        public CertGenRequest(int n, String string) {
            this.requestId = n;
            this.alias = string;
            this.submitted = PlatformUtil.ticks();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ViewCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                int n = BCertsTable.this.certModel().getSelection().getRow();
                BCertEntryViewDialog.show((BWidget)BCertsTable.this, BCertsTable.this.certModel().cert(n));
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public ViewCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.view");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ExportCommand
    extends Command {
        /*
         * Exception decompiling
         */
        public CommandArtifact doInvoke() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [11 : 615->618)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ExportCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.export");
        }
    }
}

