/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BCryptoDialog;
import com.tridium.platcrypto.ui.BPasswordField;
import com.tridium.platcrypto.ui.BX509ExtensionPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.baja.file.BAbstractFile;
import javax.baja.file.FileUtil;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCertificateSignerDialog
extends BCryptoDialog {
    public static final Action cancelButtonPressed = BCertificateSignerDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    static Lexicon lex;
    static final BImage logo;
    private static final BImage open;
    ICryptoManager mgr;
    IKeyStore store;
    private BTextField csrFileText;
    BButton openBtn;
    private BLabel subject;
    private BLabel subjectDN;
    private BLabel keyAlg;
    private BLabel keySize;
    private BLabel sigAlg;
    private BLabel sigSize;
    private BLabel verified;
    BGridPane csrPane;
    BEdgePane csrPropPane;
    BEdgePane extensionsPane;
    private BAbsTimeFE notBeforeFE;
    private BAbsTimeFE notAfterFE;
    private BX509ExtensionPane extensionPane;
    private BTextDropDown ca;
    private BPasswordField caPassword;
    NPKCS10CertificationRequest csr;
    String baseFileName;
    private BAbsTime notBefore;
    private BAbsTime notAfter;
    private BButton okButton;
    protected BButton cancelButton;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BCertificateSignerDialog;

    public void cancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(cancelButtonPressed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static void show(BWidget bWidget) throws Exception {
        BCertificateSignerDialog bCertificateSignerDialog = new BCertificateSignerDialog(bWidget);
        bCertificateSignerDialog.setBoundsCenteredOnOwner();
        bCertificateSignerDialog.setResizable(false);
        bCertificateSignerDialog.open();
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, lex.getText("cert.signer.dialog.title"), lex.getText("cert.signer.dialog.info"));
    }

    protected BWidget buildBody() {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setStretchColumn(0);
        bGridPane.setColumnAlign(BHalign.fill);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BLabel(lex.getText("cert.signer.dialog.selectcsr") + ':', BHalign.left));
        BGridPane bGridPane2 = new BGridPane(2);
        this.csrFileText = new BTextField("", 60, false);
        bGridPane2.add(null, (BValue)this.csrFileText);
        this.openBtn = new BButton((Command)new OpenCsrCommand());
        this.openBtn.setButtonStyle(BButtonStyle.toolBar);
        bGridPane2.add(null, (BValue)this.openBtn);
        bEdgePane.setCenter((BWidget)bGridPane2);
        bGridPane.add(null, (BValue)bEdgePane);
        this.csrPane = new BGridPane(1);
        this.csrPane.setVisible(false);
        this.csrPane.setStretchColumn(0);
        this.csrPane.setColumnAlign(BHalign.fill);
        this.csrPane.setRowGap(7.0);
        this.csrPropPane = new BEdgePane();
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setLeft((BWidget)new BLabel(lex.getText("cert.dialog.properties") + ':'));
        this.csrPropPane.setTop((BWidget)bEdgePane2);
        BGridPane bGridPane3 = new BGridPane(2);
        bGridPane3.setStretchColumn(1);
        bGridPane3.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)bGridPane3, (String)"scrolled");
        bGridPane3.setColumnAlign(BHalign.left);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.subject", this.subject);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.subjectDn", this.subjectDN);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.keyAlgorithm", this.keyAlg);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.keySize", this.keySize);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.signatureAlgorithm", this.sigAlg);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.signatureSize", this.sigSize);
        BCertificateSignerDialog.addPaddedLabelRow(bGridPane3, "cert.field.verify", this.verified);
        BScrollPane bScrollPane = new BScrollPane((BWidget)bGridPane3);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane, 500.0, 150.0);
        this.csrPropPane.setCenter((BWidget)bConstrainedPane);
        this.csrPane.add(null, (BValue)this.csrPropPane);
        this.extensionsPane = new BEdgePane();
        this.extensionsPane.setVisible(false);
        BEdgePane bEdgePane3 = new BEdgePane();
        bEdgePane3.setLeft((BWidget)new BLabel(lex.getText("cert.dialog.extensions") + ':'));
        this.extensionsPane.setTop((BWidget)bEdgePane3);
        this.extensionPane = new BX509ExtensionPane();
        bScrollPane = new BScrollPane((BWidget)this.extensionPane);
        BConstrainedPane bConstrainedPane2 = new BConstrainedPane((BWidget)bScrollPane, 500.0, 150.0);
        this.extensionsPane.setCenter((BWidget)bConstrainedPane2);
        this.csrPane.add(null, (BValue)this.extensionsPane);
        bGridPane.add(null, (BValue)this.csrPane);
        BEdgePane bEdgePane4 = new BEdgePane();
        BGridPane bGridPane4 = new BGridPane(2);
        bGridPane4.setRowGap(7.0);
        this.notBeforeFE = new BAbsTimeFE(this.notBefore);
        BCertificateSignerDialog.addLabelRow(bGridPane4, "cert.field.notBefore", (BValue)this.notBeforeFE);
        this.notAfterFE = new BAbsTimeFE(this.notAfter);
        BCertificateSignerDialog.addLabelRow(bGridPane4, "cert.field.notAfter", (BValue)this.notAfterFE);
        this.ca = new BTextDropDown(this.getCaAliases(), 30, false);
        BCertificateSignerDialog.addLabelRow(bGridPane4, "cert.signer.dialog.caalias", (BValue)this.ca);
        this.caPassword = new BPasswordField("", 20);
        BCertificateSignerDialog.addLabelRow(bGridPane4, "cert.signer.dialog.capassword", (BValue)this.caPassword);
        bEdgePane4.setLeft((BWidget)bGridPane4);
        bGridPane.add(null, (BValue)bEdgePane4);
        bGridPane.setRowGap(7.0);
        return bGridPane;
    }

    private static final void addLabelRow(BGridPane bGridPane, String string, BValue bValue) {
        BCertificateSignerDialog.addRow(bGridPane, (BWidget)new BLabel(lex.getText(string) + ':'), bValue);
    }

    private static final void addPaddedLabelRow(BGridPane bGridPane, String string, BLabel bLabel) {
        BCertificateSignerDialog.addRow(bGridPane, BCertificateSignerDialog.createPaddedLabel(lex.getText(string)), (BValue)BCertificateSignerDialog.createPaddedLabel(bLabel));
    }

    private static final void addRow(BGridPane bGridPane, BWidget bWidget, BValue bValue) {
        bGridPane.add(null, (BValue)bWidget);
        bGridPane.add(null, bValue);
    }

    protected BWidget buildButtons() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        bGridPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        bGridPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)bGridPane, 7.0, 0.0, 0.0, 0.0);
    }

    private final List getCaAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration enumeration = this.store.aliases();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.store.isKeyEntry(string)) continue;
                X509Certificate x509Certificate = this.store.getCertificate(string);
                if (x509Certificate != null && x509Certificate.getBasicConstraints() != -1) {
                    arrayList.add(string);
                    continue;
                }
                if (x509Certificate == null || x509Certificate.getKeyUsage() == null || !x509Certificate.getKeyUsage()[5]) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void doOkButtonPressed(BWidgetEvent bWidgetEvent) {
        try {
            X509Certificate[] x509CertificateArray;
            String string = this.ca.getText();
            String string2 = this.caPassword.getText();
            X509Certificate x509Certificate = this.store.getCertificate(string);
            PrivateKey privateKey = (PrivateKey)this.store.getKey(string, string2.toCharArray());
            NX509CertificateEntry nX509CertificateEntry = NX509CertificateEntry.make(null, (X509Certificate[])new X509Certificate[]{x509Certificate}, (PrivateKey)privateKey);
            Date date = new Date(((BAbsTime)this.notBeforeFE.saveValue()).getMillis());
            Date date2 = new Date(((BAbsTime)this.notAfterFE.saveValue()).getMillis());
            NSigningParameters nSigningParameters = NSigningParameters.make((Date)date, (Date)date2);
            int n = 0;
            while (n < this.extensionPane.getExtensionCount()) {
                if (this.extensionPane.isSelected(n)) {
                    x509CertificateArray = this.extensionPane.getExtension(n);
                    nSigningParameters.addExtension((NX509Extension)x509CertificateArray);
                }
                ++n;
            }
            NX509Certificate nX509Certificate = CertUtils.signCertificate((NPKCS10CertificationRequest)this.csr, (NX509CertificateEntry)nX509CertificateEntry, (NSigningParameters)nSigningParameters);
            x509CertificateArray = this.store.getCertificateChain(string);
            NX509Certificate[] nX509CertificateArray = new NX509Certificate[x509CertificateArray.length + 1];
            nX509CertificateArray[0] = nX509Certificate;
            int n2 = 0;
            while (n2 < x509CertificateArray.length) {
                nX509CertificateArray[n2 + 1] = NX509Certificate.make((X509Certificate)x509CertificateArray[n2]);
                ++n2;
            }
            BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("cert.extension.info"), "pem,p12,crt,cer,cert"));
            bFileChooser.setTitle(lex.getText("cert.signer.save.title"));
            bFileChooser.setDefaultFileName(this.baseFileName + ".pem");
            bFileChooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
            BOrd bOrd = bFileChooser.show();
            if (bOrd == null) {
                return;
            }
            BAbstractFile bAbstractFile = (BAbstractFile)bOrd.get();
            if (bAbstractFile != null) {
                PEMWriter pEMWriter = new PEMWriter((Writer)new OutputStreamWriter(bAbstractFile.getOutputStream()));
                int n3 = 0;
                while (n3 < nX509CertificateArray.length) {
                    pEMWriter.writeObject((Object)nX509CertificateArray[n3].getCertificate());
                    ++n3;
                }
                pEMWriter.close();
            }
            this.close();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            this.badPassword();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close();
        }
    }

    private final void badPassword() {
        this.caPassword.getModel().setText("");
        BDialog.error((BWidget)this, (String)lex.getText("cert.signer.dialog.password.error.title"), (Object)lex.getText("cert.signer.dialog.password.error.message"));
    }

    public void doCancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.close();
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.subject = new BLabel("");
        this.subjectDN = new BLabel("");
        this.keyAlg = new BLabel("");
        this.keySize = new BLabel("");
        this.sigAlg = new BLabel("");
        this.sigSize = new BLabel("");
        this.verified = new BLabel("");
        this.baseFileName = null;
        this.notBefore = BAbsTime.now();
        this.notAfter = BAbsTime.make((long)(Clock.millis() + 63072000000L));
    }

    public BCertificateSignerDialog() throws UnsupportedOperationException {
        this.this();
        throw new UnsupportedOperationException();
    }

    public BCertificateSignerDialog(BWidget bWidget) throws Exception {
        this(bWidget, lex.getText("cert.signer.dialog.title"));
    }

    public BCertificateSignerDialog(BWidget bWidget, String string) throws Exception {
        super(bWidget, string);
        this.this();
        this.mgr = CertManagerFactory.getInstance();
        this.store = this.mgr.getKeyStore();
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BCertificateSignerDialog;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BCertificateSignerDialog = BCertificateSignerDialog.class("[Lcom.tridium.platcrypto.ui.BCertificateSignerDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
        logo = BImage.make((String)lex.get("cert.green.x32.icon", "module://icons/x32/lock.png"));
        open = BImage.make((BIcon)BIcon.std((String)"open.png"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class OpenCsrCommand
    extends Command {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() {
            try {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                bFileChooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("csr.extension.info"), "csr"));
                bFileChooser.setTitle(lex.getText("cert.signer.csr.select"));
                bFileChooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
                BOrd bOrd = bFileChooser.show();
                if (bOrd == null) {
                    return null;
                }
                BAbstractFile bAbstractFile = (BAbstractFile)bOrd.get();
                if (bAbstractFile == null) return null;
                InputStreamReader inputStreamReader = new InputStreamReader(bAbstractFile.getInputStream());
                FriendlyPemReader friendlyPemReader = new FriendlyPemReader((Reader)inputStreamReader);
                PEMParser pEMParser = new PEMParser((Reader)friendlyPemReader);
                try {
                    Object object = pEMParser.readObject();
                    if (object != null) {
                        if (object instanceof PKCS10CertificationRequest) {
                            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)object;
                            JcaPKCS10CertificationRequest jcaPKCS10CertificationRequest = new JcaPKCS10CertificationRequest(pKCS10CertificationRequest.getEncoded());
                            BCertificateSignerDialog.this.csr = NPKCS10CertificationRequest.make((JcaPKCS10CertificationRequest)jcaPKCS10CertificationRequest);
                            BCertificateSignerDialog.this.csrFileText.setText(bAbstractFile.toPathString());
                            BCertificateSignerDialog.this.baseFileName = FileUtil.getBase((String)bAbstractFile.getFileName());
                            BCertificateSignerDialog.this.subject.setText(BCertificateSignerDialog.this.csr.getSubject());
                            BCertificateSignerDialog.this.subjectDN.setText(BCertificateSignerDialog.this.csr.getSubjectDN().toString());
                            BCertificateSignerDialog.this.keyAlg.setText(BCertificateSignerDialog.this.csr.getKeyAlgorithm());
                            BCertificateSignerDialog.this.keySize.setText("" + BCertificateSignerDialog.this.csr.getKeySize());
                            BCertificateSignerDialog.this.sigAlg.setText(BCertificateSignerDialog.this.csr.getSignatureAlgorithm());
                            BCertificateSignerDialog.this.sigSize.setText("" + BCertificateSignerDialog.this.csr.getSignatureSize());
                            BCertificateSignerDialog.this.verified.setText("" + BCertificateSignerDialog.this.csr.verify());
                            BCertificateSignerDialog.this.csrPane.setVisible(true);
                            BCertificateSignerDialog.this.extensionPane.setExtensions(BCertificateSignerDialog.this.csr.getExtensions(), true);
                            if (BCertificateSignerDialog.this.extensionPane.getExtensionCount() > 0) {
                                BCertificateSignerDialog.this.extensionsPane.setVisible(true);
                            } else {
                                BCertificateSignerDialog.this.extensionsPane.setVisible(false);
                            }
                            BCertificateSignerDialog.this.setBoundsCenteredOnOwner();
                        } else {
                            BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("csr.selection.error.title"), (Object)lex.getText("csr.selection.error.msg", new Object[]{bAbstractFile.getFileName()}));
                        }
                    }
                    Object var8_13 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    try {
                        pEMParser.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {}
                catch (Exception exception) {
                    return null;
                }
                pEMParser.close();
                return null;
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public OpenCsrCommand() {
            super((BWidget)BCertificateSignerDialog.this, null, open, null, null);
        }
    }
}

