/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.security.cert.CertificateEncodingException;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCertRequestDialog
extends BCertViewDialog {
    public static final Action cancelButtonPressed = BCertRequestDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    static Lexicon lex;
    static final BImage logo;
    private BButton okButton;
    protected BButton cancelButton;
    protected boolean closeResult;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BCertRequestDialog;

    public void cancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(cancelButtonPressed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static boolean request(BWidget bWidget, NX509Certificate nX509Certificate) throws Exception {
        BCertRequestDialog bCertRequestDialog = new BCertRequestDialog(bWidget, nX509Certificate);
        bCertRequestDialog.setBoundsCenteredOnOwner();
        bCertRequestDialog.setResizable(false);
        bCertRequestDialog.open();
        return bCertRequestDialog.getResult();
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("csr.view.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    protected BWidget buildContent() throws Exception {
        BEdgePane bEdgePane = new BEdgePane();
        String string = this.certCheck();
        if (string != null && string.trim().length() > 0) {
            bEdgePane.setTop(this.buildInfo(this.certCheck()));
        }
        bEdgePane.setCenter(super.buildContent());
        return bEdgePane;
    }

    private final BWidget buildInfo(String string) {
        BLabel bLabel = new BLabel("The following warnings were found:\n" + string, BHalign.left);
        StyleUtils.addStyleClass((IStylable)bLabel, (String)"warning");
        return new BBorderPane((BWidget)bLabel, 0.0, 0.0, (double)5, 0.0);
    }

    private final String certCheck() throws CertificateEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        X500Name x500Name = this.cert.getSubjectDN();
        if (x500Name.getRDNs(BCStyle.CN).length <= 0) {
            stringBuffer.append("     - missing common name (CN)\n");
        }
        if (x500Name.getRDNs(BCStyle.O).length <= 0) {
            stringBuffer.append("     - missing organization (O)\n");
        }
        if (x500Name.getRDNs(BCStyle.L).length <= 0) {
            stringBuffer.append("     - missing city/locality (L)\n");
        }
        if (x500Name.getRDNs(BCStyle.ST).length <= 0) {
            stringBuffer.append("     - missing state (ST)\n");
        }
        if (x500Name.getRDNs(BCStyle.C).length <= 0) {
            stringBuffer.append("     - missing country (C)\n");
        }
        if (this.cert.getKeySize() < 2048) {
            stringBuffer.append("     - keysize should be at least 2048 bits\n");
        }
        return stringBuffer.toString();
    }

    protected BWidget buildButtons() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        bGridPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        bGridPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)bGridPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public void doOkButtonPressed(BWidgetEvent bWidgetEvent) {
        this.closeResult = true;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.closeResult = false;
        this.close();
    }

    public boolean getResult() {
        return this.closeResult;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.closeResult = false;
    }

    private BCertRequestDialog(BWidget bWidget, NX509Certificate nX509Certificate) throws Exception {
        super(bWidget, lex.getText("csr.view.dialog.title"));
        this.this();
        this.cert = nX509Certificate;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BCertRequestDialog;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BCertRequestDialog = BCertRequestDialog.class("[Lcom.tridium.platcrypto.ui.BCertRequestDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
        logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    }
}

