/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.provider.IProvider;
import com.tridium.crypto.core.provider.NProvider;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCryptoChannel
extends BFoxChannel {
    public static final Type TYPE;
    private static Log log;
    private ICoreCryptoManager service;
    private boolean validChannel;
    static /* synthetic */ Class class$com$tridium$platcrypto$fox$BCryptoChannel;
    static /* synthetic */ Class class$com$tridium$crypto$core$cert$NX509CertificateEntry;
    static /* synthetic */ Class class$com$tridium$crypto$core$cert$NHostExemption;

    public Type getType() {
        return TYPE;
    }

    public void sessionOpened() throws Exception {
        if (this.isRunning()) {
            Log.getLog((String)"crypto").trace("pairing CertManagerService with CryptoChannel");
            BISession bISession = this.getSession();
            if (bISession instanceof BLocalHost) {
                this.service = CoreCryptoManager.get((ISecurityInfoProvider)Nre.getSecurityInfoProvider());
            } else if (bISession instanceof BFoxSession) {
                this.service = new ChannelCryptoManager((BComponent)this);
            }
        }
    }

    public void sessionClosed(Throwable throwable) throws Exception {
        Log.getLog((String)"crypto").trace("unpairing CertManagerService with CryptoChannel");
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.command;
        if (string == "keystore.serverAliases") {
            return this.keyStoreServerAliases(foxRequest);
        }
        if (string == "keystore.aliases") {
            return this.keyStoreAliases(foxRequest);
        }
        if (string == "keystore.containsAlias") {
            return this.keyStoreContainsAlias(foxRequest);
        }
        if (string == "keystore.deleteEntry") {
            return this.keyStoreDeleteEntry(foxRequest);
        }
        if (string == "keystore.getCertificate") {
            return this.keyStoreGetCertificate(foxRequest);
        }
        if (string == "keystore.getCertificateAlias") {
            return this.keyStoreGetCertificateAlias(foxRequest);
        }
        if (string == "keystore.getCertificateChain") {
            return this.keyStoreGetCertificateChain(foxRequest);
        }
        if (string == "keystore.getCreationDate") {
            return this.keyStoreGetCreationDate(foxRequest);
        }
        if (string == "keystore.getKey") {
            return this.keyStoreGetKey(foxRequest);
        }
        if (string == "keystore.isCertificateEntry") {
            return this.keyStoreIsCertificateEntry(foxRequest);
        }
        if (string == "keystore.isKeyEntry") {
            return this.keyStoreIsKeyEntry(foxRequest);
        }
        if (string == "keystore.setCertificateEntry") {
            return this.keyStoreSetCertificateEntry(foxRequest);
        }
        if (string == "keystore.setKeyEntry0") {
            return this.keyStoreSetKeyEntry0(foxRequest);
        }
        if (string == "keystore.setKeyEntry1") {
            return this.keyStoreSetKeyEntry1(foxRequest);
        }
        if (string == "keystore.size") {
            return this.keyStoreSize(foxRequest);
        }
        if (string == "keystore.save") {
            return this.keyStoreSave(foxRequest);
        }
        if (string == "keystore.getCertificates") {
            return this.keyStoreGetCertificates(foxRequest);
        }
        if (string == "keystore.deleteEntries") {
            return this.keyStoreDeleteEntries(foxRequest);
        }
        if (string == "keystore.findCertificate") {
            return this.keyStoreFindCertificate(foxRequest);
        }
        if (string == "keystore.generateSelfSignedCert") {
            return this.keyStoreGenerateSelfSignedCert(foxRequest);
        }
        if (string == "keystore.getCertGenerationStatus") {
            return this.keyGetCertGenerationStatus(foxRequest);
        }
        if (string == "keystore.generateCSR") {
            return this.keyStoreGenerateCSR(foxRequest);
        }
        if (string == "provider.Providers") {
            return this.providerProviders(foxRequest);
        }
        if (string == "provider.getProvider") {
            return this.providerGetProvider(foxRequest);
        }
        if (string == "exemption.exemptions") {
            return this.exemptionExemptions(foxRequest);
        }
        if (string == "exemption.setExemption") {
            return this.exemptionSetExemption(foxRequest);
        }
        if (string == "exemption.deleteExemption") {
            return this.exemptionDeleteExemption(foxRequest);
        }
        if (string == "exemption.getExemption") {
            return this.exemptionGetExemption(foxRequest);
        }
        if (string == "exemption.save") {
            return this.exemptionSave(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public Enumeration keyStoreServerAliases() throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.serverAliases");
        foxRequest.add("useTrustStore", false);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("alias");
        List<String> list = Arrays.asList(stringArray);
        Enumeration<String> enumeration = Collections.enumeration(list);
        return enumeration;
    }

    private final FoxResponse keyStoreServerAliases(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        Enumeration enumeration = iCoreKeyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!CertUtils.isValidServerCert((String)string, (ICoreKeyStore)iCoreKeyStore)) continue;
            foxResponse.add("alias", string);
        }
        return foxResponse;
    }

    public Enumeration keyStoreAliases(boolean bl) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.aliases");
        foxRequest.add("useTrustStore", bl);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("alias");
        List<String> list = Arrays.asList(stringArray);
        Enumeration<String> enumeration = Collections.enumeration(list);
        return enumeration;
    }

    private final FoxResponse keyStoreAliases(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        Enumeration enumeration = iCoreKeyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            foxResponse.add("alias", string);
        }
        return foxResponse;
    }

    public boolean keyStoreContainsAlias(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.containsAlias");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getBoolean("containsAlias");
    }

    private final FoxResponse keyStoreContainsAlias(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        foxResponse.add("containsAlias", iCoreKeyStore.containsAlias(foxRequest.getString("alias")));
        return foxResponse;
    }

    public void keyStoreDeleteEntry(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.deleteEntry");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        this.sendSync(foxRequest);
    }

    private final FoxResponse keyStoreDeleteEntry(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        iCoreKeyStore.deleteEntry(foxRequest.getString("alias"));
        return foxResponse;
    }

    public X509Certificate keyStoreGetCertificate(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.getCertificate");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string2 = foxResponse.getString("certificate", null);
        if (string2 != null) {
            X509Certificate x509Certificate = NX509Certificate.decodeFromString((String)string2);
            return x509Certificate;
        }
        return null;
    }

    private final FoxResponse keyStoreGetCertificate(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        X509Certificate x509Certificate = iCoreKeyStore.getCertificate(foxRequest.getString("alias"));
        if (x509Certificate != null) {
            foxResponse.add("certificate", NX509Certificate.encodeToString((X509Certificate)x509Certificate));
        }
        return foxResponse;
    }

    public String keyStoreGetCertificateAlias(boolean bl, X509Certificate x509Certificate) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.getCertificateAlias");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("certificate", NX509Certificate.encodeToString((X509Certificate)x509Certificate));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getString("alias", null);
    }

    private final FoxResponse keyStoreGetCertificateAlias(FoxRequest foxRequest) throws Exception {
        X509Certificate x509Certificate;
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        String string = iCoreKeyStore.getCertificateAlias(x509Certificate = NX509Certificate.decodeFromString((String)foxRequest.getString("certificate")));
        if (string != null) {
            foxResponse.add("alias", string);
        }
        return foxResponse;
    }

    public X509Certificate[] keyStoreGetCertificateChain(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.getCertificateChain");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("certificateChain");
        X509Certificate[] x509CertificateArray = null;
        if (stringArray.length > 0) {
            x509CertificateArray = new X509Certificate[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                x509CertificateArray[n] = NX509Certificate.decodeFromString((String)stringArray[n]);
                ++n;
            }
        }
        return x509CertificateArray;
    }

    private final FoxResponse keyStoreGetCertificateChain(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        X509Certificate[] x509CertificateArray = iCoreKeyStore.getCertificateChain(foxRequest.getString("alias"));
        if (x509CertificateArray != null) {
            int n = 0;
            while (n < x509CertificateArray.length) {
                foxResponse.add("certificateChain", NX509Certificate.encodeToString((X509Certificate)x509CertificateArray[n]));
                ++n;
            }
        }
        return foxResponse;
    }

    public Date keyStoreGetCreationDate(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.getCreationDate");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        Date date = new Date(foxResponse.getTime("creationDate"));
        return date;
    }

    private final FoxResponse keyStoreGetCreationDate(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        Date date = iCoreKeyStore.getCreationDate(foxRequest.getString("alias"));
        foxResponse.add("creationDate", date.getTime());
        return foxResponse;
    }

    public Key keyStoreGetKey(boolean bl, String string, char[] cArray) throws Exception {
        Object object;
        Object object2;
        FoxRequest foxRequest = this.makeRequest("keystore.getKey");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        if (cArray != null) {
            object2 = new String(cArray);
            object = LegacyStorageUtil.encode((String)object2);
            foxRequest.add("password", (String)object);
        }
        object2 = this.sendSync(foxRequest);
        object = null;
        boolean bl2 = object2.getBoolean("success", false);
        if (bl2) {
            String string2 = object2.getString("key", null);
            if (string2 != null) {
                object = NKey.decodeFromString((String)string2);
            }
            return object;
        }
        throw new UnrecoverableKeyException("unable to recover key");
    }

    private final FoxResponse keyStoreGetKey(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        try {
            Key key;
            char[] cArray = null;
            if (foxRequest.getString("password", null) != null) {
                cArray = LegacyStorageUtil.decode((String)foxRequest.getString("password")).toCharArray();
            }
            if ((key = iCoreKeyStore.getKey(foxRequest.getString("alias"), cArray)) != null) {
                foxResponse.add("success", true);
                foxResponse.add("key", NKey.encodeToString((Key)key));
            } else {
                foxResponse.add("success", false);
            }
            return foxResponse;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            foxResponse.add("success", false);
            return foxResponse;
        }
    }

    public boolean keyStoreIsCertificateEntry(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.isCertificateEntry");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getBoolean("isCertificateEntry");
    }

    private final FoxResponse keyStoreIsCertificateEntry(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        foxResponse.add("isCertificateEntry", iCoreKeyStore.isCertificateEntry(foxRequest.getString("alias")));
        return foxResponse;
    }

    public boolean keyStoreIsKeyEntry(boolean bl, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.isKeyEntry");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getBoolean("isKeyEntry");
    }

    private final FoxResponse keyStoreIsKeyEntry(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        foxResponse.add("isKeyEntry", iCoreKeyStore.isKeyEntry(foxRequest.getString("alias")));
        return foxResponse;
    }

    public void keyStoreSetCertificateEntry(boolean bl, String string, X509Certificate x509Certificate) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.setCertificateEntry");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        foxRequest.add("certificate", NX509Certificate.encodeToString((X509Certificate)x509Certificate));
        this.sendSync(foxRequest);
    }

    private final FoxResponse keyStoreSetCertificateEntry(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        X509Certificate x509Certificate = NX509Certificate.decodeFromString((String)foxRequest.getString("certificate"));
        iCoreKeyStore.setCertificateEntry(foxRequest.getString("alias"), x509Certificate);
        return foxResponse;
    }

    public void keyStoreSetKeyEntry0(boolean bl, String string, byte[] byArray, X509Certificate[] x509CertificateArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.setKeyEntry0");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        foxRequest.add("key", byArray);
        if (x509CertificateArray != null) {
            int n = 0;
            while (n < x509CertificateArray.length) {
                foxRequest.add("chain", NX509Certificate.encodeToString((X509Certificate)x509CertificateArray[n]));
                ++n;
            }
        }
        this.sendSync(foxRequest);
    }

    private final FoxResponse keyStoreSetKeyEntry0(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        byte[] byArray = foxRequest.getBlob("key");
        X509Certificate[] x509CertificateArray = null;
        String[] stringArray = null;
        try {
            stringArray = foxRequest.listStrings("chain");
            x509CertificateArray = new X509Certificate[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                x509CertificateArray[n] = NX509Certificate.decodeFromString((String)stringArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {}
        iCoreKeyStore.setKeyEntry(foxRequest.getString("alias"), byArray, x509CertificateArray);
        return foxResponse;
    }

    public void keyStoreSetKeyEntry1(boolean bl, String string, Key key, char[] cArray, X509Certificate[] x509CertificateArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.setKeyEntry1");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        foxRequest.add("key", NKey.encodeToString((Key)key));
        if (cArray != null) {
            String string2 = new String(cArray);
            String string3 = LegacyStorageUtil.encode((String)string2);
            foxRequest.add("password", string3);
        }
        if (x509CertificateArray != null) {
            int n = 0;
            while (n < x509CertificateArray.length) {
                foxRequest.add("chain", NX509Certificate.encodeToString((X509Certificate)x509CertificateArray[n]));
                ++n;
            }
        }
        this.sendSync(foxRequest);
    }

    private final FoxResponse keyStoreSetKeyEntry1(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        Key key = NKey.decodeFromString((String)foxRequest.getString("key"));
        char[] cArray = null;
        if (foxRequest.getString("password", null) != null) {
            cArray = LegacyStorageUtil.decode((String)foxRequest.getString("password")).toCharArray();
        }
        X509Certificate[] x509CertificateArray = null;
        String[] stringArray = null;
        try {
            stringArray = foxRequest.listStrings("chain");
            x509CertificateArray = new X509Certificate[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                x509CertificateArray[n] = NX509Certificate.decodeFromString((String)stringArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {}
        iCoreKeyStore.setKeyEntry(foxRequest.getString("alias"), key, cArray, x509CertificateArray);
        return foxResponse;
    }

    public int keyStoreSize(boolean bl) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.size");
        foxRequest.add("useTrustStore", bl);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getInt("size");
    }

    private final FoxResponse keyStoreSize(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        foxResponse.add("size", iCoreKeyStore.size());
        return foxResponse;
    }

    public void keyStoreSave(boolean bl) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.save");
        foxRequest.add("useTrustStore", bl);
        this.sendSync(foxRequest);
    }

    private final FoxResponse keyStoreSave(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        iCoreKeyStore.save();
        return foxResponse;
    }

    public Enumeration keyStoreGetCertificates(boolean bl) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.getCertificates");
        foxRequest.add("useTrustStore", bl);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("cert");
        Class clazz = class$com$tridium$crypto$core$cert$NX509CertificateEntry;
        if (clazz == null) {
            clazz = class$com$tridium$crypto$core$cert$NX509CertificateEntry = BCryptoChannel.class("[Lcom.tridium.crypto.core.cert.NX509CertificateEntry;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < stringArray.length) {
            NX509CertificateEntry nX509CertificateEntry = NX509CertificateEntry.decodeFromString((String)stringArray[n]);
            array.add((Object)nX509CertificateEntry);
            ++n;
        }
        Enumeration enumeration = Collections.enumeration(array.list());
        return enumeration;
    }

    private final FoxResponse keyStoreGetCertificates(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        Enumeration enumeration = iCoreKeyStore.getCertificates();
        while (enumeration.hasMoreElements()) {
            NX509CertificateEntry nX509CertificateEntry = (NX509CertificateEntry)enumeration.nextElement();
            foxResponse.add("cert", nX509CertificateEntry.encodeToString());
        }
        return foxResponse;
    }

    public String keyStoreFindCertificate(boolean bl, X509Certificate x509Certificate) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.findCertificate");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("certificate", NX509Certificate.encodeToString((X509Certificate)x509Certificate));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getString("alias", null);
    }

    private final FoxResponse keyStoreFindCertificate(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        X509Certificate x509Certificate = NX509Certificate.decodeFromString((String)foxRequest.getString("certificate"));
        X509Principal x509Principal = PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate);
        Enumeration enumeration = iCoreKeyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X509Certificate x509Certificate2 = iCoreKeyStore.getCertificate(string);
            if (!x509Certificate2.getType().equals("X.509")) continue;
            X509Certificate x509Certificate3 = x509Certificate2;
            X509Principal x509Principal2 = PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate3);
            if (!x509Principal.equals((Object)x509Principal2)) break;
            foxResponse.add("alias", string);
            break;
        }
        return foxResponse;
    }

    public void keyStoreDeleteEntries(boolean bl, String[] stringArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.deleteEntries");
        foxRequest.add("useTrustStore", bl);
        int n = 0;
        while (n < stringArray.length) {
            foxRequest.add("alias", stringArray[n]);
            ++n;
        }
        this.sendSync(foxRequest);
    }

    private final FoxResponse keyStoreDeleteEntries(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        String[] stringArray = foxRequest.listStrings("alias");
        int n = 0;
        while (n < stringArray.length) {
            log.trace("deleting entry " + stringArray[n]);
            iCoreKeyStore.deleteEntry(stringArray[n]);
            ++n;
        }
        return foxResponse;
    }

    public int keyStoreGenerateSelfSignedCert(boolean bl, String string, String string2, Date date, Date date2, int n, int n2, String string3, String string4) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.generateSelfSignedCert");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        foxRequest.add("dn", string2);
        foxRequest.add("notBefore", date.getTime());
        foxRequest.add("notAfter", date2.getTime());
        foxRequest.add("keySize", n);
        foxRequest.add("keyUsage", n2);
        foxRequest.add("email", string3);
        foxRequest.add("password", string4);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getInt("requestId", -1);
    }

    private final FoxResponse keyStoreGenerateSelfSignedCert(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        String string = foxRequest.getString("alias");
        String string2 = foxRequest.getString("dn");
        Date date = new Date(foxRequest.getTime("notBefore"));
        Date date2 = new Date(foxRequest.getTime("notAfter"));
        int n = foxRequest.getInt("keySize");
        int n2 = foxRequest.getInt("keyUsage");
        String string3 = foxRequest.getString("email", null);
        String string4 = foxRequest.getString("password", null);
        int n3 = iCoreKeyStore.generateSelfSignedCert(string, string2, date, date2, n, n2, string3, string4);
        foxResponse.add("requestId", n3);
        return foxResponse;
    }

    public int keyGetCertGenerationStatus(boolean bl, int n) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.getCertGenerationStatus");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("requestId", n);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getInt("status", -1);
    }

    private final FoxResponse keyGetCertGenerationStatus(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        int n = foxRequest.getInt("requestId", -1);
        int n2 = iCoreKeyStore.getCertGenerationStatus(n);
        foxResponse.add("requestId", n);
        foxResponse.add("status", n2);
        return foxResponse;
    }

    public NPKCS10CertificationRequest keyStoreGenerateCSR(boolean bl, String string, String string2) throws Exception {
        FoxRequest foxRequest = this.makeRequest("keystore.generateCSR");
        foxRequest.add("useTrustStore", bl);
        foxRequest.add("alias", string);
        if (string2 != null) {
            foxRequest.add("passwd", string2);
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        NPKCS10CertificationRequest nPKCS10CertificationRequest = NPKCS10CertificationRequest.make((String)foxResponse.getString("csr"));
        return nPKCS10CertificationRequest;
    }

    private final FoxResponse keyStoreGenerateCSR(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreKeyStore iCoreKeyStore = this.getCorrectKeyStore(foxRequest);
        String string = foxRequest.getString("alias");
        String string2 = foxRequest.getString("passwd", null);
        NPKCS10CertificationRequest nPKCS10CertificationRequest = iCoreKeyStore.generateCSR(string, string2);
        foxResponse.add("csr", nPKCS10CertificationRequest.encodeToString());
        return foxResponse;
    }

    public Enumeration providerProviders() throws Exception {
        FoxRequest foxRequest = this.makeRequest("provider.Providers");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        Vector<NProvider> vector = new Vector<NProvider>();
        String[] stringArray = foxResponse.listStrings("provider");
        int n = 0;
        while (n < stringArray.length) {
            vector.add(NProvider.decodeFromString((String)stringArray[n]));
            ++n;
        }
        return vector.elements();
    }

    private final FoxResponse providerProviders(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        NProvider[] nProviderArray = NProvider.getProviders();
        int n = 0;
        while (n < nProviderArray.length) {
            foxResponse.add("provider", nProviderArray[n].encodeToString());
            ++n;
        }
        return foxResponse;
    }

    public IProvider providerGetProvider(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("provider.getProvider");
        foxRequest.add("name", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return NProvider.decodeFromString((String)foxResponse.getString("provider"));
    }

    private final FoxResponse providerGetProvider(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        NProvider[] nProviderArray = NProvider.getProviders();
        int n = 0;
        while (n < nProviderArray.length) {
            foxResponse.add("provider", nProviderArray[n].encodeToString());
            ++n;
        }
        return foxResponse;
    }

    public Enumeration exemptionExemptions() throws Exception {
        FoxRequest foxRequest = this.makeRequest("exemption.exemptions");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("exemption");
        Class clazz = class$com$tridium$crypto$core$cert$NHostExemption;
        if (clazz == null) {
            clazz = class$com$tridium$crypto$core$cert$NHostExemption = BCryptoChannel.class("[Lcom.tridium.crypto.core.cert.NHostExemption;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < stringArray.length) {
            array.push((Object)NHostExemption.decodeFromString((String)stringArray[n]));
            ++n;
        }
        Enumeration enumeration = Collections.enumeration(array.list());
        return enumeration;
    }

    private final FoxResponse exemptionExemptions(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreExemptionStore iCoreExemptionStore = this.service.getExemptionStore();
        Enumeration enumeration = iCoreExemptionStore.exemptions();
        while (enumeration.hasMoreElements()) {
            NHostExemption nHostExemption = (NHostExemption)enumeration.nextElement();
            foxResponse.add("exemption", nHostExemption.encodeToString());
        }
        return foxResponse;
    }

    public void exemptionSetExemption(NHostExemption nHostExemption) throws Exception {
        FoxRequest foxRequest = this.makeRequest("exemption.setExemption");
        foxRequest.add("exemption", nHostExemption.encodeToString());
        this.sendSync(foxRequest);
    }

    private final FoxResponse exemptionSetExemption(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreExemptionStore iCoreExemptionStore = this.service.getExemptionStore();
        NHostExemption nHostExemption = NHostExemption.make((String)foxRequest.getString("exemption"));
        iCoreExemptionStore.setExemption(nHostExemption);
        return foxResponse;
    }

    public void exemptionDeleteExemption(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("exemption.deleteExemption");
        foxRequest.add("host", string);
        this.sendSync(foxRequest);
    }

    private final FoxResponse exemptionDeleteExemption(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreExemptionStore iCoreExemptionStore = this.service.getExemptionStore();
        String string = foxRequest.getString("host");
        iCoreExemptionStore.deleteExemption(string);
        return foxResponse;
    }

    public NHostExemption exemptionGetExemption(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("exemption.getExemption");
        foxRequest.add("host", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string2 = foxResponse.getString("exemption");
        NHostExemption nHostExemption = NHostExemption.make((String)string2);
        return nHostExemption;
    }

    private final FoxResponse exemptionGetExemption(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreExemptionStore iCoreExemptionStore = this.service.getExemptionStore();
        String string = foxRequest.getString("host");
        NHostExemption nHostExemption = iCoreExemptionStore.getExemption(string);
        foxResponse.add("exemption", nHostExemption.encodeToString());
        return foxResponse;
    }

    public void exemptionSave() throws Exception {
        FoxRequest foxRequest = this.makeRequest("exemption.save");
        this.sendSync(foxRequest);
    }

    private final FoxResponse exemptionSave(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ICoreExemptionStore iCoreExemptionStore = this.service.getExemptionStore();
        iCoreExemptionStore.save();
        return foxResponse;
    }

    private final ICoreKeyStore getCorrectKeyStore(FoxRequest foxRequest) throws Exception {
        boolean bl = foxRequest.getBoolean("useTrustStore");
        if (bl) {
            return this.service.getTrustStore();
        }
        return this.service.getKeyStore();
    }

    public File getBaseDir() {
        try {
            return new File(BCryptoChannel.getFilePath(BOrd.make((String)"file:!")));
        }
        catch (Exception exception) {
            return Sys.getBajaHome();
        }
    }

    private static final String getFilePath(BOrd bOrd) throws IOException {
        OrdQuery[] ordQueryArray = bOrd.parse();
        FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
        File file = BFileSystem.INSTANCE.pathToLocalFile(filePath);
        return file.getPath();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.validChannel = false;
    }

    public BCryptoChannel() {
        super("crypto");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platcrypto$fox$BCryptoChannel;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$fox$BCryptoChannel = BCryptoChannel.class("[Lcom.tridium.platcrypto.fox.BCryptoChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"crypto");
    }
}

