/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.platcrypto.daemon.BPlatCryptoBase;
import com.tridium.platcrypto.daemon.messages.CertGenerationStatusMessage;
import com.tridium.platcrypto.daemon.messages.FindCertificateMessage;
import com.tridium.platcrypto.daemon.messages.GenerateCertificateMessage;
import com.tridium.platcrypto.daemon.messages.GetKeyMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import com.tridium.platcrypto.daemon.messages.SetCertificateEntryMessage;
import com.tridium.platcrypto.daemon.messages.SetKeyEntryMessage;
import com.tridium.platcrypto.daemon.messages.SetKeyEntryWithResponseMessage;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPlatKeyStore
extends BPlatCryptoBase
implements ICoreKeyStore {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platcrypto$daemon$BPlatKeyStore;

    public Type getType() {
        return TYPE;
    }

    public String getKeyStoreType() {
        return "keystore";
    }

    private final List getAliases() throws Exception {
        InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType()));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        XElem[] xElemArray = xElem.elems("key");
        int n = 0;
        if (xElemArray != null) {
            n = xElemArray.length;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (xElemArray != null) {
            int n2 = 0;
            while (n2 < xElemArray.length) {
                String string = xElemArray[n2].get("alias");
                if (string != null && string.length() > 0) {
                    arrayList.add(string);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public Enumeration aliases() throws Exception {
        return Collections.enumeration(this.getAliases());
    }

    public boolean containsAlias(String string) throws Exception {
        return this.getAliases().contains(string);
    }

    public void deleteEntries(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            this.deleteEntry(stringArray[n]);
            ++n;
        }
    }

    public void deleteEntry(String string) throws Exception {
        this.getDaemonSession().sendMessage((DaemonMessage)new DeleteEntryMessage(this.getKeyStoreType(), string));
    }

    public X509Certificate[] getCertificateChain(String string) throws Exception {
        XElem[] xElemArray = this.send(new GetCertificateChainMessage(this.getKeyStoreType(), string), "certificate");
        if (xElemArray == null || xElemArray.length == 0) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[xElemArray.length];
        int n = 0;
        while (n < x509CertificateArray.length) {
            if (xElemArray[n] != null && xElemArray[n].text() != null && xElemArray[n].text().length() > 0) {
                x509CertificateArray[n] = NX509Certificate.decodeFromString((String)xElemArray[n].text().string());
            }
            ++n;
        }
        return x509CertificateArray;
    }

    public Key getKey(String string, char[] cArray) throws Exception {
        String string2;
        XText xText;
        InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new GetKeyMessage(this.getKeyStoreType(), string, cArray));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        if (xElem != null && (xText = xElem.text()) != null && (string2 = xText.toString()) != null && string2.length() > 0) {
            return NKey.decodeFromString((String)string2);
        }
        return null;
    }

    public Date getCreationDate(String string) throws Exception {
        String string2;
        InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), string));
        XElem[] xElemArray = XParser.make((InputStream)inputStream).parse().elems("key");
        if (xElemArray.length > 0 && (string2 = xElemArray[0].get("creationDate")) != null && string2.length() == "yyyy-MM-dd HH:mm:ss".length()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(string2);
            return date;
        }
        return null;
    }

    public boolean isKeyEntry(String string) throws Exception {
        InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), string));
        XElem[] xElemArray = XParser.make((InputStream)inputStream).parse().elems("key");
        if (xElemArray.length > 0) {
            return xElemArray[0].getb("keyEntry");
        }
        return false;
    }

    public boolean isCertificateEntry(String string) throws Exception {
        InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), string));
        XElem[] xElemArray = XParser.make((InputStream)inputStream).parse().elems("key");
        if (xElemArray.length > 0) {
            return xElemArray[0].getb("certEntry");
        }
        return false;
    }

    public void setCertificateEntry(String string, X509Certificate x509Certificate) throws Exception {
        this.send(new SetCertificateEntryMessage(this.getKeyStoreType(), string, x509Certificate));
    }

    public void setKeyEntry(String string, byte[] byArray, X509Certificate[] x509CertificateArray) throws Exception {
        XElem xElem = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), string, byArray, x509CertificateArray));
        if (xElem.text() != null) {
            if (!xElem.text().string().equalsIgnoreCase("success")) {
                throw new Exception(xElem.text().string());
            }
        } else {
            this.send(new SetKeyEntryMessage(this.getKeyStoreType(), string, byArray, x509CertificateArray));
        }
    }

    public void setKeyEntry(String string, Key key, char[] cArray, X509Certificate[] x509CertificateArray) throws Exception {
        XElem xElem = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), string, key, cArray, x509CertificateArray));
        if (xElem.text() != null) {
            if (!xElem.text().string().equalsIgnoreCase("success")) {
                throw new Exception(xElem.text().string());
            }
        } else {
            this.send(new SetKeyEntryMessage(this.getKeyStoreType(), string, key, cArray, x509CertificateArray));
        }
    }

    public Enumeration getCertificates() throws Exception {
        XElem[] xElemArray = this.send(new GetCertificatesMessage(this.getKeyStoreType()), "certificateEntry");
        int n = 0;
        if (xElemArray != null) {
            n = xElemArray.length;
        }
        ArrayList<NX509CertificateEntry> arrayList = new ArrayList<NX509CertificateEntry>(n);
        if (xElemArray != null) {
            int n2 = 0;
            while (n2 < xElemArray.length) {
                String string = xElemArray[n2].text().toString();
                if (string != null && string.length() > 0) {
                    arrayList.add(NX509CertificateEntry.decodeFromString((String)string));
                }
                ++n2;
            }
        }
        return Collections.enumeration(arrayList);
    }

    public String findCertificate(X509Certificate x509Certificate) throws Exception {
        Enumeration enumeration = this.getCertificates();
        while (enumeration.hasMoreElements()) {
            NX509CertificateEntry nX509CertificateEntry = (NX509CertificateEntry)enumeration.nextElement();
            NX509Certificate nX509Certificate = nX509CertificateEntry.getCertificate(0);
            if (nX509Certificate == null || !nX509Certificate.getPublicKey().equals(x509Certificate.getPublicKey())) continue;
            return nX509CertificateEntry.getAlias();
        }
        return null;
    }

    public int generateSelfSignedCert(String string, String string2, String string3, String string4, String string5, String string6, String string7, Date date, Date date2, int n, int n2, String string8, String string9) throws Exception {
        XElem xElem = this.send(new GenerateCertificateMessage(this.getKeyStoreType(), string, string2, string3, string4, string5, string6, string7, date, date2, n, n2, string8, string9));
        if (xElem != null) {
            return xElem.geti("requestId", -1);
        }
        return -1;
    }

    public int generateSelfSignedCert(String string, String string2, Date date, Date date2, int n, int n2, String string3, String string4) throws Exception {
        XElem xElem = this.send(new GenerateCertificateMessage(this.getKeyStoreType(), string, string2, date, date2, n, n2, string3, string4));
        if (xElem != null) {
            return xElem.geti("requestId", -1);
        }
        return -1;
    }

    public int getCertGenerationStatus(int n) throws Exception {
        XElem xElem = this.send(new CertGenerationStatusMessage(this.getKeyStoreType(), n));
        if (xElem != null) {
            return xElem.geti("status", -1);
        }
        return -1;
    }

    public NPKCS10CertificationRequest generateCSR(String string, String string2) throws Exception {
        XElem xElem = this.send(new GenerateCsrMessage(this.getKeyStoreType(), string, string2));
        if (xElem != null && xElem.text() != null) {
            String string3 = xElem.text().toString();
            return NPKCS10CertificationRequest.make((String)string3);
        }
        return null;
    }

    public X509Certificate getCertificate(String string) throws Exception {
        XElem xElem = this.send(new GetCertificateMessage(this.getKeyStoreType(), string));
        if (xElem != null && xElem.text() != null) {
            String string2 = xElem.text().toString();
            return NX509Certificate.decodeFromString((String)string2);
        }
        return null;
    }

    public String getCertificateAlias(X509Certificate x509Certificate) throws Exception {
        InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new GetCertificateAliasMessage(this.getKeyStoreType(), x509Certificate));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        String string = xElem.get("alias");
        return string;
    }

    public int size() throws Exception {
        return this.getAliases().size();
    }

    public long getLastModified() throws Exception {
        return 0L;
    }

    public void load() throws Exception {
    }

    public void save() throws Exception {
        this.send(new SaveMessage(this.getKeyStoreType()));
    }

    public KeyStore getKeyStore() throws Exception {
        throw new UnsupportedOperationException("can't access raw keystore remotely");
    }

    public boolean canGenerateCertificate() {
        boolean bl = false;
        try {
            BDaemonSession bDaemonSession = this.getDaemonSession();
            if (bDaemonSession.getHostProperties().supportsServlet("crypto")) {
                InputStream inputStream = this.getDaemonSession().getInputStream((DaemonMessage)new SendAliasesMessage(this.getKeyStoreType()));
                XElem xElem = XParser.make((InputStream)inputStream).parse();
                bl = xElem.attrIndex("canGenerate") != -1 ? xElem.getb("canGenerate", false) : (bDaemonSession.getHostProperties().getOsName().startsWith("qnx") ? BStationSurrogate.isAnyStationRunning((BDaemonSession)bDaemonSession) ^ true : true);
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPlatKeyStore() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BPlatKeyStore(BDaemonSession bDaemonSession) {
        super(bDaemonSession);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$daemon$BPlatKeyStore;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$daemon$BPlatKeyStore = BPlatKeyStore.class("[Lcom.tridium.platcrypto.daemon.BPlatKeyStore;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DeleteEntryMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "deleteEntry";
        }

        public DeleteEntryMessage(String string, String string2) {
            super(string);
            this.add("alias", string2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class GetCertificateChainMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "getCertificateChain";
        }

        public GetCertificateChainMessage(String string, String string2) {
            super(string);
            this.add("alias", string2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class GetCertificatesMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "getCertificates";
        }

        public GetCertificatesMessage(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class GenerateCsrMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "generateCsr";
        }

        public GenerateCsrMessage(String string, String string2, String string3) {
            super(string);
            this.add("alias", string2);
            if (string3 != null) {
                this.add("passwd", string3);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class GetCertificateMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "getCertificate";
        }

        public GetCertificateMessage(String string, String string2) {
            super(string);
            this.add("alias", string2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class GetCertificateAliasMessage
    extends FindCertificateMessage {
        public String getAction() {
            return "getCertificateAlias";
        }

        public GetCertificateAliasMessage(String string, X509Certificate x509Certificate) {
            super(string, x509Certificate);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SaveMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "saveKeyStore";
        }

        public SaveMessage(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SendAliasesMessage
    extends KeyStoreMessage {
        public String getAction() {
            return "sendAliases";
        }

        public SendAliasesMessage(String string) {
            super(string);
        }
    }
}

