/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.table.BTable;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;

public abstract class TreeTableNode {
    TreeTableModel model;
    TreeTableNode parent;
    boolean expanded;
    int index;
    int depth;

    public BTreeTable getTable() {
        return (BTreeTable)this.model.getTable();
    }

    public TreeTableModel getModel() {
        return this.model;
    }

    public BWidgetShell getShell() {
        BTable table = this.model.getTable();
        if (table != null) {
            return table.getShell();
        }
        return null;
    }

    public boolean isGroup() {
        return false;
    }

    public abstract Object getValueAt(int var1);

    public Object getSubject() {
        return this.getValueAt(0);
    }

    public BImage getIcon() {
        return null;
    }

    public TreeTableNode getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean hasChildren() {
        boolean bl = false;
        if (this.getChildCount() != 0) {
            bl = true;
        }
        return bl;
    }

    public int getChildCount() {
        return 0;
    }

    public TreeTableNode getChild(int index) {
        throw new UnsupportedOperationException();
    }

    public int getChildIndex(TreeTableNode child) {
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            if (this.getChild(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isDescendantOf(TreeTableNode ancestor) {
        TreeTableNode parent = this.getParent();
        while (parent != null && parent != ancestor) {
            parent = parent.getParent();
        }
        boolean bl = false;
        if (parent == ancestor) {
            bl = true;
        }
        return bl;
    }

    public TreeTableNode[] getPathFromRoot() {
        ArrayList<TreeTableNode> temp = new ArrayList<TreeTableNode>(4);
        temp.add(this);
        TreeTableNode parent = this.getParent();
        while (parent != null) {
            temp.add(parent);
            parent = parent.getParent();
        }
        int len = temp.size();
        TreeTableNode[] path = new TreeTableNode[len];
        int i = 0;
        while (i < len) {
            path[i] = (TreeTableNode)temp.get(len - i - 1);
            ++i;
        }
        return path;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            if (this.expanded) {
                this.expanded();
            } else {
                this.collapsed();
            }
            boolean resize = expanded;
            this.getModel().updateTreeTable(resize);
        }
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    public void expanded() {
    }

    public void collapsed() {
    }

    public TreeTableNode(TreeTableModel model) {
        if (model == null) {
            throw new NullPointerException("null model");
        }
        this.model = model;
        this.parent = null;
        this.depth = 0;
    }

    public TreeTableNode(TreeTableNode parent) {
        if (parent.model == null) {
            throw new NullPointerException("null model");
        }
        this.model = parent.model;
        this.parent = parent;
        this.depth = parent.depth + 1;
    }
}

