/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import javax.baja.sys.BValue;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;

public class TreeTableController
extends TableController {
    public final BTreeTable getTreeTable() {
        return (BTreeTable)this.getTable();
    }

    public final TreeTableModel getTreeTableModel() {
        return ((BTreeTable)this.getTable()).model;
    }

    public void cellPressed(BMouseEvent event, int row, int col) {
        TreeTableModel model = this.getTreeTableModel();
        TreeTableNode node = model.rowToNode(row);
        if (col == 0 || node != null && node.isGroup()) {
            TreeTableTheme theme = Theme.treeTable();
            int depth = node.getDepth();
            double x = theme.getIndent(depth);
            double x1 = x - 1.0;
            double x2 = x + theme.getExpanderWidth() + 1.0;
            double ex = event.getX();
            if (x1 <= ex && ex <= x2 && model.isDepthExpandable(depth) && node.hasChildren()) {
                int[] sel = this.getSelection().getRows();
                int size = node.getChildCount();
                int delta = node.isExpanded() ? -size : size;
                this.getSelection().deselectAll();
                node.setExpanded(node.isExpanded() ^ true);
                int i = 0;
                while (i < sel.length) {
                    if (sel[i] > row) {
                        this.getSelection().select(sel[i] + delta);
                    } else {
                        this.getSelection().select(sel[i]);
                    }
                    ++i;
                }
                return;
            }
        }
        super.cellPressed(event, row, col);
    }

    protected BMenu makeOptionsMenu() {
        BTable table = this.getTable();
        TableModel model = this.getModel();
        BMenu menu = new BMenu();
        menu.add("resizeColumns", new TableController.ResizeColumnsCommand(table));
        menu.add("export", new TableController.ExportCommand(table));
        if (model instanceof DynamicTreeTableModel) {
            DynamicTreeTableModel dynamicModel = (DynamicTreeTableModel)model;
            menu.add("showSep", (BValue)new BSeparator());
            int count = 0;
            int i = 0;
            while (i < dynamicModel.getRootColumnCount()) {
                if (dynamicModel.isColumnShowable(i)) {
                    menu.add(null, new ShowColumnCommand(dynamicModel, i));
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                menu.remove("showSep");
            }
        }
        return menu;
    }

    protected final BMenu makePopup(TableSubject subject) {
        return this.makePopup((TreeTableSubject)subject);
    }

    protected BMenu makePopup(TreeTableSubject subject) {
        return null;
    }

    protected void headerPopup(BMouseEvent event, int column) {
        DynamicTreeTableModel dynamicModel;
        TableModel model = this.getModel();
        if (model instanceof DynamicTreeTableModel && (dynamicModel = (DynamicTreeTableModel)model).isColumnShowable(column = dynamicModel.toRootColumnIndex(column))) {
            BMenu menu = new BMenu();
            menu.add(null, new HideColumnCommand(dynamicModel, column));
            menu.open(this.getTable(), event.getX(), event.getY());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ShowColumnCommand
    extends ToggleCommand {
        DynamicTreeTableModel model;
        int column;

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            this.model.setShowColumn(this.column, sel);
        }

        ShowColumnCommand(DynamicTreeTableModel model, int column) {
            super(model.getTable(), model.getRootColumnName(column));
            this.model = model;
            this.column = column;
            this.setSelected(model.showColumn(column));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HideColumnCommand
    extends Command {
        DynamicTreeTableModel model;
        int column;

        public CommandArtifact doInvoke() {
            this.model.setShowColumn(this.column, false);
            return null;
        }

        HideColumnCommand(DynamicTreeTableModel model, int column) {
            super((BWidget)model.getTable(), UiLexicon.bajaui().module, "commands.table.hideColumn");
            this.model = model;
            this.column = column;
        }
    }
}

