/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreeTableCellRenderer
extends TableCellRenderer {
    private RectGeom clip;

    public final BTreeTable getTreeTable() {
        return (BTreeTable)this.getTable();
    }

    public final TreeTableModel getTreeTableModel() {
        return ((BTreeTable)this.getTable()).model;
    }

    public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
        double pw = super.getPreferredCellWidth(cell);
        if (cell.column == 0) {
            TreeTableTheme theme = Theme.treeTable();
            TreeTableModel model = this.getTreeTableModel();
            TreeTableNode node = model.rowToNode(cell.row);
            if (node.isGroup()) {
                return 0.0;
            }
            int depth = node.getDepth();
            pw += theme.getIndent(depth);
            if (model.isDepthExpandable(depth)) {
                pw += theme.getExpanderWidth() + (double)5;
            }
        }
        return pw;
    }

    public IGeom getClip(TableCellRenderer.Cell cell) {
        TreeTableModel model = this.getTreeTableModel();
        TreeTableNode node = model.rowToNode(cell.row);
        if (node.isGroup()) {
            if (cell.column == 0) {
                double gw = this.getTable().getWidth() - this.getTable().getVscrollBar().getWidth();
                this.clip.set(0.0, 0.0, gw - 1.0, cell.height);
                return this.clip;
            }
            this.clip.set(0.0, 0.0, 0.0, 0.0);
            return this.clip;
        }
        return super.getClip(cell);
    }

    public BBrush getForeground(TableCellRenderer.Cell cell) {
        return Theme.treeTable().getTextBrush();
    }

    public BBrush getBackground(TableCellRenderer.Cell cell) {
        if (this.getTreeTableModel().rowToNode(cell.row).isGroup()) {
            return Theme.treeTable().getGroupBackground();
        }
        return super.getBackground(cell);
    }

    public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
        String text;
        BImage icon;
        double y;
        TreeTableTheme theme = Theme.treeTable();
        TreeTableModel model = this.getTreeTableModel();
        TreeTableNode node = model.rowToNode(cell.row);
        int depth = node.getDepth();
        boolean group = node.isGroup();
        if (cell.column > 0) {
            if (!group) {
                super.paintCell(g, cell);
                this.paintVerticalLine(g, cell);
            }
            return;
        }
        if (group) {
            double gw;
            cell.width = gw = this.getTable().getWidth() - this.getTable().getVscrollBar().getWidth();
        }
        this.paintCellBackground(g, cell);
        BBrush fg = g.getBrush();
        double x = theme.getIndent(depth);
        if (model.isDepthExpandable(depth)) {
            if (node.hasChildren()) {
                int state = node.isExpanded() + 1;
                y = (cell.height - theme.getExpanderHeight()) / (double)2;
                theme.paintExpander(g, x, y, cell.selected, state, group);
            }
            x += theme.getExpanderWidth() + (double)5;
        }
        if ((icon = model.getRowIcon(cell.row)) != null) {
            y = (cell.height - 16.0) / (double)2;
            g.drawImage(icon, x, y);
            x += 18.0;
        }
        if ((text = this.getCellText(cell)) != null && text.length() > 0) {
            BFont font = this.getFont(cell);
            g.setBrush(fg);
            g.setFont(font);
            g.drawString(text, x, (cell.height + font.getAscent() - font.getDescent()) / (double)2);
        }
        if (!group) {
            this.paintVerticalLine(g, cell);
        }
    }

    public void paintVerticalLine(Graphics g, TableCellRenderer.Cell cell) {
        BTable table = this.getTable();
        if (!table.getVgridVisible()) {
            return;
        }
        BBrush c = this.getTable().getGridBrush();
        if (c.isNull()) {
            c = Theme.table().getGridBrush();
        }
        g.setBrush(c);
        g.strokeLine(cell.width - 1.0, 0.0, cell.width - 1.0, cell.height);
    }

    private final /* synthetic */ void this() {
        this.clip = new RectGeom();
    }

    public TreeTableCellRenderer() {
        this.this();
    }
}

