/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import java.util.BitSet;
import javax.baja.sys.BObject;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.WrapperTreeTableModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DynamicTreeTableModel
extends WrapperTreeTableModel {
    BitSet showCols;
    BitSet showable;
    int showCount;
    int[] toRootMap;
    int[] fromRootMap;

    public int getColumnCount() {
        if (this.showCount < 0) {
            this.columnsModified();
        }
        return this.showCount;
    }

    public String getColumnName(int col) {
        return this.root.getColumnName(this.toRootColumnIndex(col));
    }

    public Object getValueAt(int row, int col) {
        return this.root.getValueAt(row, this.toRootColumnIndex(col));
    }

    public Object getSubject(int row) {
        return this.root.getSubject(row);
    }

    public BHalign getColumnAlignment(int col) {
        return this.root.getColumnAlignment(this.toRootColumnIndex(col));
    }

    public boolean isColumnSortable(int col) {
        return this.root.isColumnSortable(this.toRootColumnIndex(col));
    }

    public void sortByColumn(int col, boolean ascending) {
        this.root.sortByColumn(this.toRootColumnIndex(col), ascending);
    }

    public int getRootColumnCount() {
        return this.root.getColumnCount();
    }

    public String getRootColumnName(int rootCol) {
        return this.root.getColumnName(rootCol);
    }

    public int toRootColumnIndex(int showCol) {
        if (showCol < 0) {
            return showCol;
        }
        if (this.fromRootMap == null) {
            this.columnsModified();
        }
        return this.toRootMap[showCol];
    }

    public int fromRootColumnIndex(int rootCol) {
        if (rootCol < 0) {
            return rootCol;
        }
        if (this.fromRootMap == null) {
            this.columnsModified();
        }
        return this.fromRootMap[rootCol];
    }

    public boolean showColumn(int rootCol) {
        return this.showCols.get(rootCol);
    }

    public void setShowColumn(int rootCol, boolean show) {
        if (!this.showable.get(rootCol)) {
            return;
        }
        BTreeTable table = this.getTreeTable();
        if (this.showCols.get(rootCol) != show) {
            int sortCol = -1;
            boolean sortAscending = true;
            if (table != null) {
                this.toRootColumnIndex(table.getSortColumn());
                sortAscending = table.isSortAscending();
            }
            DynamicTreeTableModel.set(this.showCols, rootCol, show);
            this.columnsModified();
            if (table != null) {
                this.getTable().sizeColumnsToFit();
            }
            if (table != null) {
                int relSortCol;
                table.sortByColumn(-1, sortAscending);
                if (sortCol >= 0 && this.showColumn(sortCol) && (relSortCol = this.fromRootColumnIndex(sortCol)) >= 0 && this.root.isColumnSortable(relSortCol)) {
                    table.sortByColumn(relSortCol, sortAscending);
                }
            }
        }
    }

    public void columnsModified() {
        int count = this.getRootColumnCount();
        int showCount = 0;
        int[] toRootMap = new int[count];
        int[] fromRootMap = new int[count];
        int i = 0;
        while (i < count) {
            if (this.showColumn(i)) {
                toRootMap[showCount++] = i;
                fromRootMap[i] = showCount - 1;
            } else {
                fromRootMap[i] = -1;
            }
            ++i;
        }
        this.showCount = showCount;
        this.toRootMap = toRootMap;
        this.fromRootMap = fromRootMap;
    }

    public void setColumnShowable(int rootCol, boolean show) {
        DynamicTreeTableModel.set(this.showable, rootCol, show);
    }

    public boolean isColumnShowable(int rootCol) {
        return this.showable.get(rootCol);
    }

    public BObject export(int row, int col) {
        return this.root.export(row, this.toRootColumnIndex(col));
    }

    static void set(BitSet bits, int fromIndex, int toIndex) {
        int i = fromIndex;
        while (i < toIndex) {
            bits.set(i);
            ++i;
        }
    }

    static void set(BitSet bits, int index, boolean bit) {
        if (bit) {
            bits.set(index);
        } else {
            bits.clear(index);
        }
    }

    private final /* synthetic */ void this() {
        this.showCols = new BitSet();
        this.showable = new BitSet();
        this.showCount = -1;
    }

    public DynamicTreeTableModel(TreeTableModel root, int[] showColumns) {
        super(root);
        this.this();
        int i = 0;
        while (i < showColumns.length) {
            this.showCols.set(showColumns[i]);
            ++i;
        }
        DynamicTreeTableModel.set(this.showable, 0, root.getColumnCount());
    }

    public DynamicTreeTableModel(TreeTableModel root) {
        super(root);
        this.this();
        DynamicTreeTableModel.set(this.showCols, 0, 255);
        DynamicTreeTableModel.set(this.showable, 0, 255);
    }
}

