/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTheme;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNodeRenderer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TreeNode {
    private static final double MARGIN = 4.0;
    private TreeModel model;
    private TreeNode parent;
    private double x;
    private double y;
    private boolean isTop;
    private boolean isLast;
    private double height;
    private double expanderX;
    private double expanderWidth;
    private double expanderY;
    private double expanderHeight;
    private double nodeX;
    private double nodeY;
    private boolean expanded;
    private boolean selected;
    private boolean focus;

    public TreeModel getModel() {
        TreeNode parent;
        if (this.model == null && (parent = this.getParent()) != null) {
            this.model = parent.getModel();
        }
        return this.model;
    }

    public BTree getTree() {
        return this.getModel().getTree();
    }

    public BWidgetShell getShell() {
        BTree tree = this.getTree();
        if (tree != null) {
            return tree.getShell();
        }
        return null;
    }

    public abstract String getText();

    public String toString() {
        return this.getText();
    }

    public abstract BImage getIcon();

    public boolean isLeaf() {
        return this.hasChildren() ^ true;
    }

    public boolean hasChildren() {
        boolean bl = false;
        if (this.getChildCount() != 0) {
            bl = true;
        }
        return bl;
    }

    public abstract int getChildCount();

    public abstract TreeNode getChild(int var1);

    public int getChildIndex(TreeNode child) {
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            if (this.getChild(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getSubject() {
        return this.getText();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isDescendantOf(TreeNode ancestor) {
        TreeNode parent = this.getParent();
        while (parent != null && parent != ancestor) {
            parent = parent.getParent();
        }
        boolean bl = false;
        if (parent == ancestor) {
            bl = true;
        }
        return bl;
    }

    public TreeNode[] getPathFromRoot() {
        ArrayList<TreeNode> temp = new ArrayList<TreeNode>(4);
        temp.add(this);
        TreeNode parent = this.getParent();
        while (parent != null) {
            temp.add(parent);
            parent = parent.getParent();
        }
        int count = temp.size();
        TreeNode[] path = new TreeNode[count];
        int i = 0;
        while (i < count) {
            path[i] = (TreeNode)temp.get(count - i - 1);
            ++i;
        }
        return path;
    }

    public boolean isValid() {
        TreeNode child = this;
        TreeNode parent = child.getParent();
        while (parent != null) {
            if (parent.getChildIndex(this) == -1) {
                return false;
            }
            child = parent;
            parent = child.getParent();
        }
        boolean bl = false;
        if (this.model.getRootIndex(child) != -1) {
            bl = true;
        }
        return bl;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.expanded) {
            this.expanded();
        } else {
            this.collapsed();
        }
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    public void expanded() {
    }

    public void collapsed() {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public boolean hasFocus() {
        return this.focus;
    }

    void setFocus(boolean f) {
        this.focus = f;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    double layout(double x, double y, boolean isTop, boolean isLast, ArrayList visibleNodes, Size prefSize) {
        this.x = x;
        this.y = y;
        this.isTop = isTop;
        this.isLast = isLast;
        visibleNodes.add(this);
        BTree tree = this.getTree();
        if (tree == null) {
            System.out.println("ERROR: TreeNode.layout no tree: " + this.getClass().getName());
            return 0.0;
        }
        TreeTheme theme = Theme.tree();
        TreeNodeRenderer renderer = tree.getNodeRenderer();
        double nodeHeight = renderer.getHeight();
        this.height = this.getTree().getRowHeight();
        this.expanderWidth = theme.getExpanderWidth();
        this.expanderHeight = theme.getExpanderHeight();
        this.expanderX = x;
        this.expanderY = y + (this.height - this.expanderHeight) / (double)2;
        this.nodeX = this.expanderX + this.expanderWidth + (double)4;
        this.nodeY = y + (this.height - nodeHeight) / (double)2;
        y += this.height;
        if (this.expanded) {
            RectGeom visRect = null;
            if (this.getTree().widgetSupport(this) != null) {
                visRect = new RectGeom(0.0, y - this.height, this.getTree().getWidth(), this.height);
            }
            double childX = this.nodeX + (renderer.getIconWidth() - this.expanderWidth) / (double)2;
            int childCount = this.getChildCount();
            int i = 0;
            while (i < childCount) {
                TreeNode treeNode = this.getChild(i);
                boolean bl = false;
                if (i == childCount - 1) {
                    bl = true;
                }
                y = treeNode.layout(childX, y, false, bl, visibleNodes, prefSize);
                ++i;
            }
            if (visRect != null) {
                visRect.height = y - visRect.y;
                this.getTree().widgetSupport(visRect);
            }
        }
        prefSize.width = Math.max(prefSize.width, this.nodeX + renderer.getWidth(this));
        return y;
    }

    public boolean inExpander(double x, double y) {
        return Theme.tree().inExpander(this.expanderX, this.expanderY, x, y);
    }

    public boolean isSelection(double x, double y) {
        BTree tree = this.getTree();
        TreeNodeRenderer renderer = tree.getNodeRenderer();
        double nodeWidth = renderer.getWidth(this);
        boolean bl = false;
        if (x >= this.nodeX && x <= this.nodeX + nodeWidth) {
            bl = true;
        }
        return bl;
    }

    public double getWidth() {
        return this.expanderWidth + (double)4 + this.getTree().getNodeRenderer().getWidth(this);
    }

    double paint(Graphics g, double prevY) {
        try {
            TreeTheme theme = Theme.tree();
            TreeNodeRenderer renderer = this.getTree().getNodeRenderer();
            boolean leaf = this.isLeaf();
            if (!leaf) {
                theme.paintExpander(g, this.getTree(), this.expanderX, this.expanderY, this.expanded);
            }
            double cx = this.expanderX + this.expanderWidth / (double)2;
            double cy = this.expanderY + this.expanderHeight / (double)2;
            g.setBrush(theme.getConnectingBrush(this.getTree()));
            if (leaf) {
                PaintUtil.drawDashedLine(g, cx, cy, cx + this.expanderWidth / (double)2 + (double)4, cy);
            } else {
                PaintUtil.drawDashedLine(g, this.expanderX + this.expanderWidth, cy, this.expanderX + this.expanderWidth + (double)4, cy);
            }
            if (!this.isTop) {
                if (leaf) {
                    PaintUtil.drawDashedLine(g, cx, cy, cx, prevY);
                } else {
                    PaintUtil.drawDashedLine(g, cx, this.expanderY, cx, prevY);
                }
            }
            if (!this.isLast) {
                if (leaf) {
                    PaintUtil.drawDashedLine(g, cx, cy, cx, this.y + this.height);
                } else {
                    PaintUtil.drawDashedLine(g, cx, this.expanderY + this.expanderHeight, cx, this.y + this.height);
                }
            }
            renderer.paintNode(g, this, this.nodeX, this.nodeY);
            if (this.expanded) {
                IRectGeom clip = g.getClipBounds();
                double viewTop = clip.y();
                double viewBottom = clip.y() + clip.height();
                prevY = this.y + this.height;
                int childCount = this.getChildCount();
                boolean belowBottom = false;
                int i = 0;
                while (i < childCount) {
                    TreeNode nextChild;
                    TreeNode thisChild = this.getChild(i);
                    if (thisChild.getY() > viewBottom) {
                        if (belowBottom) break;
                        belowBottom = true;
                    }
                    TreeNode treeNode = nextChild = i == childCount - 1 ? null : this.getChild(i + 1);
                    if (nextChild == null || !(nextChild.getY() <= viewTop)) {
                        prevY = this.getChild(i).paint(g, prevY);
                    }
                    ++i;
                }
            }
            return this.y + this.height;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return this.y + this.height;
        }
    }

    private final /* synthetic */ void this() {
        this.isTop = true;
        this.isLast = true;
        this.expanded = false;
        this.selected = false;
        this.focus = false;
    }

    public TreeNode(TreeModel model, TreeNode parent) {
        this.this();
        this.model = model;
        this.parent = parent;
    }

    public TreeNode(TreeModel model) {
        this.this();
        this.model = model;
    }

    public TreeNode(TreeNode parent) {
        this.this();
        this.parent = parent;
    }
}

