/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTree
extends BTransferWidget {
    public static final Property multipleSelection = BTree.newProperty((int)0, (boolean)false, null);
    public static final Topic actionPerformed = BTree.newTopic((int)0, null);
    public static final Topic cancelled = BTree.newTopic((int)0, null);
    public static final Topic treeModified = BTree.newTopic((int)0, null);
    public static final Topic selectionModified = BTree.newTopic((int)0, null);
    public static final Type TYPE;
    TreeModel model;
    TreeController controller;
    TreeNodeRenderer nodeRenderer;
    TreeSelection selection;
    ArrayList visibleNodes;
    TreeNode toVisible;
    TreeNode lastExpand;
    RectGeom toVisibleRect;
    static /* synthetic */ Class class$javax$baja$ui$tree$BTree;

    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    public void setMultipleSelection(boolean v) {
        this.setBoolean(multipleSelection, v, null);
    }

    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    public void fireCancelled(BWidgetEvent event) {
        this.fire(cancelled, (BValue)event, null);
    }

    public void fireTreeModified(BWidgetEvent event) {
        this.fire(treeModified, (BValue)event, null);
    }

    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel model) {
        this.installSupport(this.model, model);
        this.model = model;
        this.visibleNodes = new ArrayList(64);
        this.toVisible = null;
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public TreeController getController() {
        return this.controller;
    }

    public void setController(TreeController controller) {
        this.installSupport(this.controller, controller);
        this.controller = controller;
    }

    public TreeNodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(TreeNodeRenderer r) {
        this.installSupport(this.nodeRenderer, r);
        this.nodeRenderer = r;
    }

    public TreeSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TreeSelection selModel) {
        this.installSupport(this.selection, selModel);
        this.selection = selModel;
    }

    private final void installSupport(TreeSupport old, TreeSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.tree != null) {
            throw new IllegalArgumentException("Already installed on another tree");
        }
        if (old != null) {
            old.tree = null;
        }
        support.tree = this;
    }

    public void computePreferredSize() {
        Size prefSize = new Size(0.0, 0.0);
        prefSize = this.doLayout(null, prefSize);
        this.setPreferredSize(prefSize.width, prefSize.height);
    }

    public void doLayout(BWidget[] children) {
        this.doLayout(children, null);
        if (this.toVisibleRect != null) {
            this.scrollToVisible(this.toVisibleRect);
        }
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public Size doLayout(BWidget[] children, Size prefSize) {
        if (prefSize == null) {
            prefSize = new Size(0.0, 0.0);
        }
        double x = Theme.tree().getInsets().left;
        double y = Theme.tree().getInsets().top;
        this.visibleNodes.clear();
        TreeModel model = this.model;
        int rootCount = model.getRootCount();
        int i = 0;
        while (i < rootCount) {
            TreeNode treeNode = model.getRoot(i);
            boolean bl = false;
            if (i == 0) {
                bl = true;
            }
            boolean bl2 = false;
            if (i == rootCount - 1) {
                bl2 = true;
            }
            y = treeNode.layout(x, y, bl, bl2, this.visibleNodes, prefSize);
            ++i;
        }
        prefSize.height = y;
        if (this.getParent() instanceof BTreePane) {
            prefSize.height += this.getRowHeight();
        }
        return prefSize;
    }

    public double getRowHeight() {
        return Math.max(Theme.tree().getExpanderHeight(), this.nodeRenderer.getHeight());
    }

    public int getRow(double y) {
        double rowHeight = this.getRowHeight();
        if ((y -= Theme.tree().getInsets().top) < 0.0) {
            y = 0.0;
        }
        return (int)(y / rowHeight);
    }

    public TreeNode yToTreeNode(double y) {
        int row = this.getRow(y);
        if (row >= this.visibleNodes.size()) {
            return null;
        }
        return (TreeNode)this.visibleNodes.get(row);
    }

    public TreeNode getPrevious(TreeNode startNode) {
        double y = startNode.getY();
        int row = this.getRow(y);
        if (row == 0) {
            return null;
        }
        return (TreeNode)this.visibleNodes.get(row - 1);
    }

    public TreeNode getNext(TreeNode startNode) {
        double y = startNode.getY();
        int row = this.getRow(y);
        if (row == this.visibleNodes.size() - 1) {
            return null;
        }
        return (TreeNode)this.visibleNodes.get(row + 1);
    }

    public void paint(Graphics g) {
        IRectGeom clip = g.getClipBounds();
        g.setBrush(Theme.tree().getBackground(this));
        g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        int rootCount = this.model.getRootCount();
        double height = this.nodeRenderer.getHeight();
        double viewTop = clip.y();
        double viewBottom = clip.y() + clip.height();
        double prevY = 0.0;
        boolean belowBottom = false;
        int i = 0;
        while (i < rootCount) {
            TreeNode nextRoot;
            TreeNode thisRoot = this.model.getRoot(i);
            if (thisRoot.getY() > viewBottom) {
                if (belowBottom) break;
                belowBottom = true;
            }
            TreeNode treeNode = nextRoot = i == rootCount - 1 ? null : this.model.getRoot(i + 1);
            if (nextRoot == null || !(nextRoot.getY() <= viewTop)) {
                prevY = thisRoot.paint(g, prevY);
                if (this.toVisible != null) {
                    RectGeom nodeRect = new RectGeom(this.toVisible.getX(), this.toVisible.getY(), this.toVisible.getWidth() + (double)4, this.getRowHeight());
                    this.scrollToVisible(nodeRect);
                    this.toVisible = null;
                }
            }
            ++i;
        }
    }

    public String getStyleSelector() {
        return "tree";
    }

    public final void toggleExpanded(TreeNode node) {
        this.setExpanded(node, node.isExpanded() ^ true);
    }

    public void setExpanded(TreeNode node, boolean exp) {
        if (node.isExpanded() == exp) {
            return;
        }
        node.setExpanded(exp);
        if (!exp) {
            this.selection.collapsed(node);
            this.controller.collapsed(node);
        } else {
            this.selection.expanded(node);
            this.controller.expanded(node);
            this.lastExpand = node;
        }
        this.relayout();
    }

    public void expandToNode(TreeNode node) {
        this.expandPath(node.getPathFromRoot());
    }

    public void expandPath(TreeNode[] path) {
        int count = path.length;
        int i = 0;
        while (i < count - 1) {
            path[i].setExpanded(true);
            ++i;
        }
        this.relayout();
    }

    public void scrollNodeToVisible(TreeNode node) {
        this.scrollPathToVisible(node.getPathFromRoot());
    }

    public void scrollPathToVisible(TreeNode[] path) {
        this.toVisible = path[path.length - 1];
        this.expandPath(path);
    }

    public Object widgetSupport(Object arg) {
        if (arg instanceof TreeNode) {
            if (arg == this.lastExpand) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (arg instanceof RectGeom) {
            this.toVisibleRect = (RectGeom)arg;
            return null;
        }
        return super.widgetSupport(arg);
    }

    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    public void focusGained(BFocusEvent event) {
        this.controller.focusGained(event);
    }

    public void focusLost(BFocusEvent event) {
        this.controller.focusLost(event);
    }

    public void mousePressed(BMouseEvent evt) {
        this.controller.mousePressed(evt);
    }

    public void mouseReleased(BMouseEvent evt) {
        this.controller.mouseReleased(evt);
    }

    public void mouseEntered(BMouseEvent evt) {
        this.controller.mouseEntered(evt);
    }

    public void mouseExited(BMouseEvent evt) {
        this.controller.mouseExited(evt);
    }

    public void mousePulsed(BMouseEvent evt) {
        this.controller.mousePulsed(evt);
    }

    public void mouseMoved(BMouseEvent evt) {
        this.controller.mouseMoved(evt);
    }

    public void mouseDragged(BMouseEvent evt) {
        this.controller.mouseDragged(evt);
    }

    public void keyPressed(BKeyEvent evt) {
        this.controller.keyPressed(evt);
    }

    public void keyReleased(BKeyEvent evt) {
        this.controller.keyReleased(evt);
    }

    public void keyTyped(BKeyEvent evt) {
        this.controller.keyTyped(evt);
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int dragOver(TransferContext cx) {
        if (cx.isPulse()) {
            this.controller.pulseViewport(cx.getX(), cx.getY());
        }
        return super.dragOver(cx);
    }

    public TreeNode[] getVisibleNodes() {
        TreeNode[] arr = new TreeNode[this.visibleNodes.size()];
        int i = 0;
        while (i < this.visibleNodes.size()) {
            arr[i] = (TreeNode)this.visibleNodes.get(i);
            ++i;
        }
        return arr;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.visibleNodes = new ArrayList(64);
        this.toVisible = null;
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public BTree() {
        this(new TreeModel.DefaultTreeModel(), new TreeController());
    }

    public BTree(TreeModel model) {
        this(model, new TreeController());
    }

    public BTree(TreeModel model, TreeController controller) {
        this.this();
        this.setModel(model);
        this.setController(controller);
        this.setNodeRenderer(new TreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    static {
        Class clazz = class$javax$baja$ui$tree$BTree;
        if (clazz == null) {
            clazz = class$javax$baja$ui$tree$BTree = BTree.class("[Ljavax.baja.ui.tree.BTree;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static abstract class TreeSupport {
        BTree tree;

        public final BTree getTree() {
            return this.tree;
        }

        public final TreeModel getModel() {
            return this.tree.model;
        }

        public final TreeController getController() {
            return this.tree.controller;
        }

        public final TreeNodeRenderer getNodeRenderer() {
            return this.tree.nodeRenderer;
        }

        public final TreeSelection getSelection() {
            return this.tree.selection;
        }

        public final BWidgetShell getShell() {
            return this.tree.getShell();
        }
    }
}

