/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class CssParser
extends TextParser {
    protected Segment nextSegment() {
        Segment whitespace = this.parseWhitespace();
        if (whitespace != null) {
            return whitespace;
        }
        int c = this.current;
        if (c == 123 || c == 125 || c == 40 || c == 41 || c == 91 || c == 93 || c == 44 || c == 59) {
            this.advance();
            return this.newSegment(8);
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            Segment id = this.parseIdentifier();
            if (this.isKeyword(id)) {
                return new Segment(6, 8, id.offset, id.length);
            }
            if (this.isDataValue(id)) {
                return new Segment(4, 8, id.offset, id.length);
            }
            if (this.isIdentifier(id)) {
                return new Segment(5, 8, id.offset, id.length);
            }
            return id;
        }
        if (c == 47 && this.next == 42) {
            this.advance();
            this.advance();
            int mods = 16;
            if (this.current == 42) {
                this.advance();
                mods = 0;
            }
            return this.newSegment(11, 0);
        }
        if (c == 42 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(12);
        }
        if (!(c != 34 && c != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70 || c == 35 || c == 46 && 48 <= this.next && this.next <= 57 || c == 45 && 48 <= this.next && this.next <= 57) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current)) {
            if (!this.advance()) break;
        }
        return this.newSegment(0);
    }

    private final Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current) || this.current == 45 || this.current == 58 || this.current == 59) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private final boolean isDataValue(Segment seg) {
        if (this.isKeyword(seg, "bold;")) {
            return true;
        }
        if (this.isKeyword(seg, "bolder;")) {
            return true;
        }
        if (this.isKeyword(seg, "center;")) {
            return true;
        }
        if (this.isKeyword(seg, "em;")) {
            return true;
        }
        if (this.isKeyword(seg, "in;")) {
            return true;
        }
        if (this.isKeyword(seg, "italic;")) {
            return true;
        }
        if (this.isKeyword(seg, "large;")) {
            return true;
        }
        if (this.isKeyword(seg, "left;")) {
            return true;
        }
        if (this.isKeyword(seg, "medium;")) {
            return true;
        }
        if (this.isKeyword(seg, "monospace;")) {
            return true;
        }
        if (this.isKeyword(seg, "px;")) {
            return true;
        }
        if (this.isKeyword(seg, "sans-serif;")) {
            return true;
        }
        if (this.isKeyword(seg, "serif;")) {
            return true;
        }
        return this.isKeyword(seg, "solid;");
    }

    private final boolean isKeyword(Segment seg) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(seg, "a")) {
                    return true;
                }
                if (this.isKeyword(seg, "abbr:")) {
                    return true;
                }
                if (this.isKeyword(seg, "above:")) {
                    return true;
                }
                if (this.isKeyword(seg, "acronym:")) {
                    return true;
                }
                if (this.isKeyword(seg, "address:")) {
                    return true;
                }
                if (this.isKeyword(seg, "applet:")) {
                    return true;
                }
                if (this.isKeyword(seg, "array:")) {
                    return true;
                }
                if (this.isKeyword(seg, "area:")) {
                    return true;
                }
                if (this.isKeyword(seg, "abbr:")) {
                    return true;
                }
                if (this.isKeyword(seg, "accept-charset:")) {
                    return true;
                }
                if (this.isKeyword(seg, "accept:")) {
                    return true;
                }
                if (this.isKeyword(seg, "accesskey:")) {
                    return true;
                }
                if (this.isKeyword(seg, "action:")) {
                    return true;
                }
                if (this.isKeyword(seg, "align:")) {
                    return true;
                }
                if (this.isKeyword(seg, "alink:")) {
                    return true;
                }
                if (this.isKeyword(seg, "alt:")) {
                    return true;
                }
                if (this.isKeyword(seg, "archive:")) {
                    return true;
                }
                return this.isKeyword(seg, "axis:");
            }
            case 'b': {
                if (this.isKeyword(seg, "b")) {
                    return true;
                }
                if (this.isKeyword(seg, "base")) {
                    return true;
                }
                if (this.isKeyword(seg, "basefont")) {
                    return true;
                }
                if (this.isKeyword(seg, "bdo:")) {
                    return true;
                }
                if (this.isKeyword(seg, "bbsound:")) {
                    return true;
                }
                if (this.isKeyword(seg, "big:")) {
                    return true;
                }
                if (this.isKeyword(seg, "blink:")) {
                    return true;
                }
                if (this.isKeyword(seg, "blockquote:")) {
                    return true;
                }
                if (this.isKeyword(seg, "body")) {
                    return true;
                }
                if (this.isKeyword(seg, "br")) {
                    return true;
                }
                if (this.isKeyword(seg, "button:")) {
                    return true;
                }
                if (this.isKeyword(seg, "background:")) {
                    return true;
                }
                if (this.isKeyword(seg, "behavior:")) {
                    return true;
                }
                if (this.isKeyword(seg, "below:")) {
                    return true;
                }
                if (this.isKeyword(seg, "bgcolor:")) {
                    return true;
                }
                if (this.isKeyword(seg, "border:")) {
                    return true;
                }
                if (this.isKeyword(seg, "border-top:")) {
                    return true;
                }
                if (this.isKeyword(seg, "border-left:")) {
                    return true;
                }
                if (this.isKeyword(seg, "border-right:")) {
                    return true;
                }
                if (this.isKeyword(seg, "border-bottom:")) {
                    return true;
                }
                if (this.isKeyword(seg, "border-color:")) {
                    return true;
                }
                return this.isKeyword(seg, "border-width:");
            }
            case 'c': {
                if (this.isKeyword(seg, "caption:")) {
                    return true;
                }
                if (this.isKeyword(seg, "center:")) {
                    return true;
                }
                if (this.isKeyword(seg, "cite:")) {
                    return true;
                }
                if (this.isKeyword(seg, "code:")) {
                    return true;
                }
                if (this.isKeyword(seg, "col:")) {
                    return true;
                }
                if (this.isKeyword(seg, "colgroup:")) {
                    return true;
                }
                if (this.isKeyword(seg, "command:")) {
                    return true;
                }
                if (this.isKeyword(seg, "comment:")) {
                    return true;
                }
                if (this.isKeyword(seg, "cellpadding:")) {
                    return true;
                }
                if (this.isKeyword(seg, "cellspacing:")) {
                    return true;
                }
                if (this.isKeyword(seg, "char:")) {
                    return true;
                }
                if (this.isKeyword(seg, "charoff:")) {
                    return true;
                }
                if (this.isKeyword(seg, "charset:")) {
                    return true;
                }
                if (this.isKeyword(seg, "checked:")) {
                    return true;
                }
                if (this.isKeyword(seg, "cite:")) {
                    return true;
                }
                if (this.isKeyword(seg, "class:")) {
                    return true;
                }
                if (this.isKeyword(seg, "classid:")) {
                    return true;
                }
                if (this.isKeyword(seg, "clear:")) {
                    return true;
                }
                if (this.isKeyword(seg, "codebase:")) {
                    return true;
                }
                if (this.isKeyword(seg, "codetype:")) {
                    return true;
                }
                if (this.isKeyword(seg, "color:")) {
                    return true;
                }
                if (this.isKeyword(seg, "cols:")) {
                    return true;
                }
                if (this.isKeyword(seg, "colspan:")) {
                    return true;
                }
                if (this.isKeyword(seg, "compact:")) {
                    return true;
                }
                if (this.isKeyword(seg, "content:")) {
                    return true;
                }
                return this.isKeyword(seg, "coords:");
            }
            case 'd': {
                if (this.isKeyword(seg, "dd:")) {
                    return true;
                }
                if (this.isKeyword(seg, "del:")) {
                    return true;
                }
                if (this.isKeyword(seg, "dfn:")) {
                    return true;
                }
                if (this.isKeyword(seg, "dir:")) {
                    return true;
                }
                if (this.isKeyword(seg, "div")) {
                    return true;
                }
                if (this.isKeyword(seg, "dl")) {
                    return true;
                }
                if (this.isKeyword(seg, "dt")) {
                    return true;
                }
                if (this.isKeyword(seg, "data:")) {
                    return true;
                }
                if (this.isKeyword(seg, "datetime:")) {
                    return true;
                }
                if (this.isKeyword(seg, "declare:")) {
                    return true;
                }
                if (this.isKeyword(seg, "defer:")) {
                    return true;
                }
                return this.isKeyword(seg, "disabled:");
            }
            case 'e': {
                if (this.isKeyword(seg, "em")) {
                    return true;
                }
                if (this.isKeyword(seg, "embed:")) {
                    return true;
                }
                if (this.isKeyword(seg, "envar:")) {
                    return true;
                }
                return this.isKeyword(seg, "enctype:");
            }
            case 'f': {
                if (this.isKeyword(seg, "family:")) {
                    return true;
                }
                if (this.isKeyword(seg, "fieldset:")) {
                    return true;
                }
                if (this.isKeyword(seg, "filename:")) {
                    return true;
                }
                if (this.isKeyword(seg, "fig:")) {
                    return true;
                }
                if (this.isKeyword(seg, "font:")) {
                    return true;
                }
                if (this.isKeyword(seg, "font-size:")) {
                    return true;
                }
                if (this.isKeyword(seg, "font-family:")) {
                    return true;
                }
                if (this.isKeyword(seg, "font-weight:")) {
                    return true;
                }
                if (this.isKeyword(seg, "form:")) {
                    return true;
                }
                if (this.isKeyword(seg, "frame:")) {
                    return true;
                }
                if (this.isKeyword(seg, "frameset:")) {
                    return true;
                }
                if (this.isKeyword(seg, "face:")) {
                    return true;
                }
                if (this.isKeyword(seg, "for:")) {
                    return true;
                }
                if (this.isKeyword(seg, "frameborder:")) {
                    return true;
                }
                return this.isKeyword(seg, "framespacing:");
            }
            case 'h': {
                if (this.isKeyword(seg, "h1")) {
                    return true;
                }
                if (this.isKeyword(seg, "h2")) {
                    return true;
                }
                if (this.isKeyword(seg, "h3")) {
                    return true;
                }
                if (this.isKeyword(seg, "h4")) {
                    return true;
                }
                if (this.isKeyword(seg, "h5")) {
                    return true;
                }
                if (this.isKeyword(seg, "h6")) {
                    return true;
                }
                if (this.isKeyword(seg, "head")) {
                    return true;
                }
                if (this.isKeyword(seg, "hr")) {
                    return true;
                }
                if (this.isKeyword(seg, "html")) {
                    return true;
                }
                if (this.isKeyword(seg, "headers:")) {
                    return true;
                }
                if (this.isKeyword(seg, "height:")) {
                    return true;
                }
                if (this.isKeyword(seg, "hidden:")) {
                    return true;
                }
                if (this.isKeyword(seg, "href:")) {
                    return true;
                }
                if (this.isKeyword(seg, "hreflang:")) {
                    return true;
                }
                if (this.isKeyword(seg, "hspace:")) {
                    return true;
                }
                return this.isKeyword(seg, "http-equiv:");
            }
            case 'i': {
                if (this.isKeyword(seg, "i:")) {
                    return true;
                }
                if (this.isKeyword(seg, "iframe:")) {
                    return true;
                }
                if (this.isKeyword(seg, "ilayer:")) {
                    return true;
                }
                if (this.isKeyword(seg, "img")) {
                    return true;
                }
                if (this.isKeyword(seg, "input:")) {
                    return true;
                }
                if (this.isKeyword(seg, "ins:")) {
                    return true;
                }
                if (this.isKeyword(seg, "isindex:")) {
                    return true;
                }
                if (this.isKeyword(seg, "id")) {
                    return true;
                }
                return this.isKeyword(seg, "ismap:");
            }
            case 'l': {
                if (this.isKeyword(seg, "label:")) {
                    return true;
                }
                if (this.isKeyword(seg, "layer:")) {
                    return true;
                }
                if (this.isKeyword(seg, "left:")) {
                    return true;
                }
                if (this.isKeyword(seg, "legend:")) {
                    return true;
                }
                if (this.isKeyword(seg, "li")) {
                    return true;
                }
                if (this.isKeyword(seg, "link")) {
                    return true;
                }
                if (this.isKeyword(seg, "listing:")) {
                    return true;
                }
                if (this.isKeyword(seg, "lang:")) {
                    return true;
                }
                if (this.isKeyword(seg, "language:")) {
                    return true;
                }
                if (this.isKeyword(seg, "loop:")) {
                    return true;
                }
                return this.isKeyword(seg, "longdesc:");
            }
            case 'm': {
                if (this.isKeyword(seg, "map:")) {
                    return true;
                }
                if (this.isKeyword(seg, "marquee:")) {
                    return true;
                }
                if (this.isKeyword(seg, "menu:")) {
                    return true;
                }
                if (this.isKeyword(seg, "meta:")) {
                    return true;
                }
                if (this.isKeyword(seg, "multicol:")) {
                    return true;
                }
                if (this.isKeyword(seg, "mailto:")) {
                    return true;
                }
                if (this.isKeyword(seg, "margin:")) {
                    return true;
                }
                if (this.isKeyword(seg, "marginheight:")) {
                    return true;
                }
                if (this.isKeyword(seg, "marginwidth:")) {
                    return true;
                }
                if (this.isKeyword(seg, "maxlength:")) {
                    return true;
                }
                if (this.isKeyword(seg, "media:")) {
                    return true;
                }
                if (this.isKeyword(seg, "method:")) {
                    return true;
                }
                return this.isKeyword(seg, "multiple:");
            }
            case 'n': {
                if (this.isKeyword(seg, "nextid:")) {
                    return true;
                }
                if (this.isKeyword(seg, "nobr:")) {
                    return true;
                }
                if (this.isKeyword(seg, "noframes:")) {
                    return true;
                }
                if (this.isKeyword(seg, "nolayer:")) {
                    return true;
                }
                if (this.isKeyword(seg, "note:")) {
                    return true;
                }
                if (this.isKeyword(seg, "noscript:")) {
                    return true;
                }
                if (this.isKeyword(seg, "name:")) {
                    return true;
                }
                if (this.isKeyword(seg, "nohref:")) {
                    return true;
                }
                if (this.isKeyword(seg, "noresize:")) {
                    return true;
                }
                return this.isKeyword(seg, "noshade:");
            }
            case 'o': {
                if (this.isKeyword(seg, "object:")) {
                    return true;
                }
                if (this.isKeyword(seg, "ol")) {
                    return true;
                }
                if (this.isKeyword(seg, "option:")) {
                    return true;
                }
                if (this.isKeyword(seg, "optgroup:")) {
                    return true;
                }
                if (this.isKeyword(seg, "object")) {
                    return true;
                }
                if (this.isKeyword(seg, "onblur:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onchange:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onfocus:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onkeydown:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onkeypress:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onkeyup:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onload:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onreset:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onselect:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onsubmit:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onunload:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onclick:")) {
                    return true;
                }
                if (this.isKeyword(seg, "ondblclick:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmousedown:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmousemove:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmouseout:")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmouseover:")) {
                    return true;
                }
                return this.isKeyword(seg, "onmouseup:");
            }
            case 'p': {
                if (this.isKeyword(seg, "p")) {
                    return true;
                }
                if (this.isKeyword(seg, "padding:")) {
                    return true;
                }
                if (this.isKeyword(seg, "padding-top:")) {
                    return true;
                }
                if (this.isKeyword(seg, "padding-left:")) {
                    return true;
                }
                if (this.isKeyword(seg, "padding-right:")) {
                    return true;
                }
                if (this.isKeyword(seg, "padding-bottom:")) {
                    return true;
                }
                if (this.isKeyword(seg, "param:")) {
                    return true;
                }
                if (this.isKeyword(seg, "pre")) {
                    return true;
                }
                if (this.isKeyword(seg, "profile:")) {
                    return true;
                }
                return this.isKeyword(seg, "prompt:");
            }
            case 'q': {
                if (this.isKeyword(seg, "q:")) {
                    return true;
                }
                return this.isKeyword(seg, "quote:");
            }
            case 'r': {
                if (this.isKeyword(seg, "range:")) {
                    return true;
                }
                if (this.isKeyword(seg, "root:")) {
                    return true;
                }
                if (this.isKeyword(seg, "readonly:")) {
                    return true;
                }
                if (this.isKeyword(seg, "rel:")) {
                    return true;
                }
                if (this.isKeyword(seg, "rev:")) {
                    return true;
                }
                if (this.isKeyword(seg, "right:")) {
                    return true;
                }
                if (this.isKeyword(seg, "rows")) {
                    return true;
                }
                if (this.isKeyword(seg, "rowspan")) {
                    return true;
                }
                return this.isKeyword(seg, "rules:");
            }
            case 's': {
                if (this.isKeyword(seg, "s:")) {
                    return true;
                }
                if (this.isKeyword(seg, "samp:")) {
                    return true;
                }
                if (this.isKeyword(seg, "script:")) {
                    return true;
                }
                if (this.isKeyword(seg, "select:")) {
                    return true;
                }
                if (this.isKeyword(seg, "small:")) {
                    return true;
                }
                if (this.isKeyword(seg, "sound:")) {
                    return true;
                }
                if (this.isKeyword(seg, "spacer:")) {
                    return true;
                }
                if (this.isKeyword(seg, "span")) {
                    return true;
                }
                if (this.isKeyword(seg, "sqrt:")) {
                    return true;
                }
                if (this.isKeyword(seg, "strike:")) {
                    return true;
                }
                if (this.isKeyword(seg, "strong:")) {
                    return true;
                }
                if (this.isKeyword(seg, "style:")) {
                    return true;
                }
                if (this.isKeyword(seg, "sub:")) {
                    return true;
                }
                if (this.isKeyword(seg, "sup:")) {
                    return true;
                }
                if (this.isKeyword(seg, "scheme:")) {
                    return true;
                }
                if (this.isKeyword(seg, "scope:")) {
                    return true;
                }
                if (this.isKeyword(seg, "scrolling:")) {
                    return true;
                }
                if (this.isKeyword(seg, "selected:")) {
                    return true;
                }
                if (this.isKeyword(seg, "shape:")) {
                    return true;
                }
                if (this.isKeyword(seg, "size:")) {
                    return true;
                }
                if (this.isKeyword(seg, "src:")) {
                    return true;
                }
                if (this.isKeyword(seg, "standby:")) {
                    return true;
                }
                if (this.isKeyword(seg, "start:")) {
                    return true;
                }
                return this.isKeyword(seg, "summary:");
            }
            case 't': {
                if (this.isKeyword(seg, "table")) {
                    return true;
                }
                if (this.isKeyword(seg, "tbody")) {
                    return true;
                }
                if (this.isKeyword(seg, "td")) {
                    return true;
                }
                if (this.isKeyword(seg, "text:")) {
                    return true;
                }
                if (this.isKeyword(seg, "text-align:")) {
                    return true;
                }
                if (this.isKeyword(seg, "textarea:")) {
                    return true;
                }
                if (this.isKeyword(seg, "tfoot")) {
                    return true;
                }
                if (this.isKeyword(seg, "th")) {
                    return true;
                }
                if (this.isKeyword(seg, "thead")) {
                    return true;
                }
                if (this.isKeyword(seg, "title")) {
                    return true;
                }
                if (this.isKeyword(seg, "tr")) {
                    return true;
                }
                if (this.isKeyword(seg, "tt")) {
                    return true;
                }
                if (this.isKeyword(seg, "tabindex:")) {
                    return true;
                }
                if (this.isKeyword(seg, "target:")) {
                    return true;
                }
                if (this.isKeyword(seg, "topmargin:")) {
                    return true;
                }
                return this.isKeyword(seg, "type:");
            }
            case 'u': {
                if (this.isKeyword(seg, "u")) {
                    return true;
                }
                if (this.isKeyword(seg, "ul")) {
                    return true;
                }
                if (this.isKeyword(seg, "url")) {
                    return true;
                }
                return this.isKeyword(seg, "usemap:");
            }
            case 'v': {
                if (this.isKeyword(seg, "var:")) {
                    return true;
                }
                if (this.isKeyword(seg, "valign:")) {
                    return true;
                }
                if (this.isKeyword(seg, "value:")) {
                    return true;
                }
                if (this.isKeyword(seg, "valuetype:")) {
                    return true;
                }
                if (this.isKeyword(seg, "version:")) {
                    return true;
                }
                if (this.isKeyword(seg, "vlink:")) {
                    return true;
                }
                return this.isKeyword(seg, "vspace:");
            }
            case 'w': {
                if (this.isKeyword(seg, "wbr:")) {
                    return true;
                }
                if (this.isKeyword(seg, "weight:")) {
                    return true;
                }
                return this.isKeyword(seg, "width:");
            }
            case 'x': {
                return this.isKeyword(seg, "xmp:");
            }
        }
        return false;
    }

    private final boolean isIdentifier(Segment seg) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(seg, "a")) {
                    return true;
                }
                if (this.isKeyword(seg, "abbr")) {
                    return true;
                }
                if (this.isKeyword(seg, "above")) {
                    return true;
                }
                if (this.isKeyword(seg, "acronym")) {
                    return true;
                }
                if (this.isKeyword(seg, "address")) {
                    return true;
                }
                if (this.isKeyword(seg, "applet")) {
                    return true;
                }
                if (this.isKeyword(seg, "array")) {
                    return true;
                }
                if (this.isKeyword(seg, "area")) {
                    return true;
                }
                if (this.isKeyword(seg, "abbr")) {
                    return true;
                }
                if (this.isKeyword(seg, "accept-charset")) {
                    return true;
                }
                if (this.isKeyword(seg, "accept")) {
                    return true;
                }
                if (this.isKeyword(seg, "accesskey")) {
                    return true;
                }
                if (this.isKeyword(seg, "action")) {
                    return true;
                }
                if (this.isKeyword(seg, "align")) {
                    return true;
                }
                if (this.isKeyword(seg, "alink")) {
                    return true;
                }
                if (this.isKeyword(seg, "alt")) {
                    return true;
                }
                if (this.isKeyword(seg, "archive")) {
                    return true;
                }
                return this.isKeyword(seg, "axis");
            }
            case 'b': {
                if (this.isKeyword(seg, "b")) {
                    return true;
                }
                if (this.isKeyword(seg, "base")) {
                    return true;
                }
                if (this.isKeyword(seg, "basefont")) {
                    return true;
                }
                if (this.isKeyword(seg, "bdo")) {
                    return true;
                }
                if (this.isKeyword(seg, "bbsound")) {
                    return true;
                }
                if (this.isKeyword(seg, "big")) {
                    return true;
                }
                if (this.isKeyword(seg, "blink")) {
                    return true;
                }
                if (this.isKeyword(seg, "blockquote")) {
                    return true;
                }
                if (this.isKeyword(seg, "body")) {
                    return true;
                }
                if (this.isKeyword(seg, "br")) {
                    return true;
                }
                if (this.isKeyword(seg, "button")) {
                    return true;
                }
                if (this.isKeyword(seg, "background")) {
                    return true;
                }
                if (this.isKeyword(seg, "behavior")) {
                    return true;
                }
                if (this.isKeyword(seg, "below")) {
                    return true;
                }
                if (this.isKeyword(seg, "bgcolor")) {
                    return true;
                }
                if (this.isKeyword(seg, "border")) {
                    return true;
                }
                if (this.isKeyword(seg, "border-color")) {
                    return true;
                }
                return this.isKeyword(seg, "border-width");
            }
            case 'c': {
                if (this.isKeyword(seg, "caption")) {
                    return true;
                }
                if (this.isKeyword(seg, "center")) {
                    return true;
                }
                if (this.isKeyword(seg, "cite")) {
                    return true;
                }
                if (this.isKeyword(seg, "code")) {
                    return true;
                }
                if (this.isKeyword(seg, "col")) {
                    return true;
                }
                if (this.isKeyword(seg, "colgroup")) {
                    return true;
                }
                if (this.isKeyword(seg, "command")) {
                    return true;
                }
                if (this.isKeyword(seg, "comment")) {
                    return true;
                }
                if (this.isKeyword(seg, "cellpadding")) {
                    return true;
                }
                if (this.isKeyword(seg, "cellspacing")) {
                    return true;
                }
                if (this.isKeyword(seg, "char")) {
                    return true;
                }
                if (this.isKeyword(seg, "charoff")) {
                    return true;
                }
                if (this.isKeyword(seg, "charset")) {
                    return true;
                }
                if (this.isKeyword(seg, "checked")) {
                    return true;
                }
                if (this.isKeyword(seg, "cite")) {
                    return true;
                }
                if (this.isKeyword(seg, "class")) {
                    return true;
                }
                if (this.isKeyword(seg, "classid")) {
                    return true;
                }
                if (this.isKeyword(seg, "clear")) {
                    return true;
                }
                if (this.isKeyword(seg, "codebase")) {
                    return true;
                }
                if (this.isKeyword(seg, "codetype")) {
                    return true;
                }
                if (this.isKeyword(seg, "color")) {
                    return true;
                }
                if (this.isKeyword(seg, "cols")) {
                    return true;
                }
                if (this.isKeyword(seg, "colspan")) {
                    return true;
                }
                if (this.isKeyword(seg, "compact")) {
                    return true;
                }
                if (this.isKeyword(seg, "content")) {
                    return true;
                }
                return this.isKeyword(seg, "coords");
            }
            case 'd': {
                if (this.isKeyword(seg, "dd")) {
                    return true;
                }
                if (this.isKeyword(seg, "del")) {
                    return true;
                }
                if (this.isKeyword(seg, "dfn")) {
                    return true;
                }
                if (this.isKeyword(seg, "dir")) {
                    return true;
                }
                if (this.isKeyword(seg, "div")) {
                    return true;
                }
                if (this.isKeyword(seg, "dl")) {
                    return true;
                }
                if (this.isKeyword(seg, "dt")) {
                    return true;
                }
                if (this.isKeyword(seg, "data")) {
                    return true;
                }
                if (this.isKeyword(seg, "datetime")) {
                    return true;
                }
                if (this.isKeyword(seg, "declare")) {
                    return true;
                }
                if (this.isKeyword(seg, "defer")) {
                    return true;
                }
                return this.isKeyword(seg, "disabled");
            }
            case 'e': {
                if (this.isKeyword(seg, "em")) {
                    return true;
                }
                if (this.isKeyword(seg, "embed")) {
                    return true;
                }
                if (this.isKeyword(seg, "envar")) {
                    return true;
                }
                return this.isKeyword(seg, "enctype");
            }
            case 'f': {
                if (this.isKeyword(seg, "family")) {
                    return true;
                }
                if (this.isKeyword(seg, "fieldset")) {
                    return true;
                }
                if (this.isKeyword(seg, "filename")) {
                    return true;
                }
                if (this.isKeyword(seg, "fig")) {
                    return true;
                }
                if (this.isKeyword(seg, "font")) {
                    return true;
                }
                if (this.isKeyword(seg, "font-size")) {
                    return true;
                }
                if (this.isKeyword(seg, "form")) {
                    return true;
                }
                if (this.isKeyword(seg, "frame")) {
                    return true;
                }
                if (this.isKeyword(seg, "frameset")) {
                    return true;
                }
                if (this.isKeyword(seg, "face")) {
                    return true;
                }
                if (this.isKeyword(seg, "for")) {
                    return true;
                }
                if (this.isKeyword(seg, "frameborder")) {
                    return true;
                }
                return this.isKeyword(seg, "framespacing");
            }
            case 'h': {
                if (this.isKeyword(seg, "h1")) {
                    return true;
                }
                if (this.isKeyword(seg, "h2")) {
                    return true;
                }
                if (this.isKeyword(seg, "h3")) {
                    return true;
                }
                if (this.isKeyword(seg, "h4")) {
                    return true;
                }
                if (this.isKeyword(seg, "h5")) {
                    return true;
                }
                if (this.isKeyword(seg, "h6")) {
                    return true;
                }
                if (this.isKeyword(seg, "head")) {
                    return true;
                }
                if (this.isKeyword(seg, "hr")) {
                    return true;
                }
                if (this.isKeyword(seg, "html")) {
                    return true;
                }
                if (this.isKeyword(seg, "headers")) {
                    return true;
                }
                if (this.isKeyword(seg, "height")) {
                    return true;
                }
                if (this.isKeyword(seg, "hidden")) {
                    return true;
                }
                if (this.isKeyword(seg, "href")) {
                    return true;
                }
                if (this.isKeyword(seg, "hreflang")) {
                    return true;
                }
                if (this.isKeyword(seg, "hspace")) {
                    return true;
                }
                return this.isKeyword(seg, "http-equiv");
            }
            case 'i': {
                if (this.isKeyword(seg, "i")) {
                    return true;
                }
                if (this.isKeyword(seg, "iframe")) {
                    return true;
                }
                if (this.isKeyword(seg, "ilayer")) {
                    return true;
                }
                if (this.isKeyword(seg, "img")) {
                    return true;
                }
                if (this.isKeyword(seg, "input")) {
                    return true;
                }
                if (this.isKeyword(seg, "ins")) {
                    return true;
                }
                if (this.isKeyword(seg, "isindex")) {
                    return true;
                }
                if (this.isKeyword(seg, "id")) {
                    return true;
                }
                return this.isKeyword(seg, "ismap");
            }
            case 'l': {
                if (this.isKeyword(seg, "label")) {
                    return true;
                }
                if (this.isKeyword(seg, "layer")) {
                    return true;
                }
                if (this.isKeyword(seg, "left")) {
                    return true;
                }
                if (this.isKeyword(seg, "legend")) {
                    return true;
                }
                if (this.isKeyword(seg, "li")) {
                    return true;
                }
                if (this.isKeyword(seg, "link")) {
                    return true;
                }
                if (this.isKeyword(seg, "listing")) {
                    return true;
                }
                if (this.isKeyword(seg, "lang")) {
                    return true;
                }
                if (this.isKeyword(seg, "language")) {
                    return true;
                }
                if (this.isKeyword(seg, "loop")) {
                    return true;
                }
                return this.isKeyword(seg, "longdesc");
            }
            case 'm': {
                if (this.isKeyword(seg, "map")) {
                    return true;
                }
                if (this.isKeyword(seg, "marquee")) {
                    return true;
                }
                if (this.isKeyword(seg, "menu")) {
                    return true;
                }
                if (this.isKeyword(seg, "meta")) {
                    return true;
                }
                if (this.isKeyword(seg, "multicol")) {
                    return true;
                }
                if (this.isKeyword(seg, "mailto")) {
                    return true;
                }
                if (this.isKeyword(seg, "margin")) {
                    return true;
                }
                if (this.isKeyword(seg, "marginheight")) {
                    return true;
                }
                if (this.isKeyword(seg, "marginwidth")) {
                    return true;
                }
                if (this.isKeyword(seg, "maxlength")) {
                    return true;
                }
                if (this.isKeyword(seg, "media")) {
                    return true;
                }
                if (this.isKeyword(seg, "method")) {
                    return true;
                }
                return this.isKeyword(seg, "multiple");
            }
            case 'n': {
                if (this.isKeyword(seg, "nextid")) {
                    return true;
                }
                if (this.isKeyword(seg, "nobr")) {
                    return true;
                }
                if (this.isKeyword(seg, "noframes")) {
                    return true;
                }
                if (this.isKeyword(seg, "nolayer")) {
                    return true;
                }
                if (this.isKeyword(seg, "note")) {
                    return true;
                }
                if (this.isKeyword(seg, "noscript")) {
                    return true;
                }
                if (this.isKeyword(seg, "name")) {
                    return true;
                }
                if (this.isKeyword(seg, "nohref")) {
                    return true;
                }
                if (this.isKeyword(seg, "noresize")) {
                    return true;
                }
                return this.isKeyword(seg, "noshade");
            }
            case 'o': {
                if (this.isKeyword(seg, "object")) {
                    return true;
                }
                if (this.isKeyword(seg, "ol")) {
                    return true;
                }
                if (this.isKeyword(seg, "option")) {
                    return true;
                }
                if (this.isKeyword(seg, "optgroup")) {
                    return true;
                }
                if (this.isKeyword(seg, "object")) {
                    return true;
                }
                if (this.isKeyword(seg, "onblur")) {
                    return true;
                }
                if (this.isKeyword(seg, "onchange")) {
                    return true;
                }
                if (this.isKeyword(seg, "onfocus")) {
                    return true;
                }
                if (this.isKeyword(seg, "onkeydown")) {
                    return true;
                }
                if (this.isKeyword(seg, "onkeypress")) {
                    return true;
                }
                if (this.isKeyword(seg, "onkeyup")) {
                    return true;
                }
                if (this.isKeyword(seg, "onload")) {
                    return true;
                }
                if (this.isKeyword(seg, "onreset")) {
                    return true;
                }
                if (this.isKeyword(seg, "onselect")) {
                    return true;
                }
                if (this.isKeyword(seg, "onsubmit")) {
                    return true;
                }
                if (this.isKeyword(seg, "onunload")) {
                    return true;
                }
                if (this.isKeyword(seg, "onclick")) {
                    return true;
                }
                if (this.isKeyword(seg, "ondblclick")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmousedown")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmousemove")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmouseout")) {
                    return true;
                }
                if (this.isKeyword(seg, "onmouseover")) {
                    return true;
                }
                return this.isKeyword(seg, "onmouseup");
            }
            case 'p': {
                if (this.isKeyword(seg, "p")) {
                    return true;
                }
                if (this.isKeyword(seg, "padding-left")) {
                    return true;
                }
                if (this.isKeyword(seg, "param")) {
                    return true;
                }
                if (this.isKeyword(seg, "pre")) {
                    return true;
                }
                if (this.isKeyword(seg, "profile")) {
                    return true;
                }
                return this.isKeyword(seg, "prompt");
            }
            case 'q': {
                if (this.isKeyword(seg, "q")) {
                    return true;
                }
                return this.isKeyword(seg, "quote");
            }
            case 'r': {
                if (this.isKeyword(seg, "range")) {
                    return true;
                }
                if (this.isKeyword(seg, "root")) {
                    return true;
                }
                if (this.isKeyword(seg, "readonly")) {
                    return true;
                }
                if (this.isKeyword(seg, "rel")) {
                    return true;
                }
                if (this.isKeyword(seg, "rev")) {
                    return true;
                }
                if (this.isKeyword(seg, "right")) {
                    return true;
                }
                if (this.isKeyword(seg, "rows")) {
                    return true;
                }
                if (this.isKeyword(seg, "rowspan")) {
                    return true;
                }
                return this.isKeyword(seg, "rules");
            }
            case 's': {
                if (this.isKeyword(seg, "s")) {
                    return true;
                }
                if (this.isKeyword(seg, "samp")) {
                    return true;
                }
                if (this.isKeyword(seg, "script")) {
                    return true;
                }
                if (this.isKeyword(seg, "select")) {
                    return true;
                }
                if (this.isKeyword(seg, "small")) {
                    return true;
                }
                if (this.isKeyword(seg, "sound")) {
                    return true;
                }
                if (this.isKeyword(seg, "spacer")) {
                    return true;
                }
                if (this.isKeyword(seg, "span")) {
                    return true;
                }
                if (this.isKeyword(seg, "sqrt")) {
                    return true;
                }
                if (this.isKeyword(seg, "strike")) {
                    return true;
                }
                if (this.isKeyword(seg, "strong")) {
                    return true;
                }
                if (this.isKeyword(seg, "style")) {
                    return true;
                }
                if (this.isKeyword(seg, "sub")) {
                    return true;
                }
                if (this.isKeyword(seg, "sup")) {
                    return true;
                }
                if (this.isKeyword(seg, "scheme")) {
                    return true;
                }
                if (this.isKeyword(seg, "scope")) {
                    return true;
                }
                if (this.isKeyword(seg, "scrolling")) {
                    return true;
                }
                if (this.isKeyword(seg, "selected")) {
                    return true;
                }
                if (this.isKeyword(seg, "shape")) {
                    return true;
                }
                if (this.isKeyword(seg, "size")) {
                    return true;
                }
                if (this.isKeyword(seg, "src")) {
                    return true;
                }
                if (this.isKeyword(seg, "standby")) {
                    return true;
                }
                if (this.isKeyword(seg, "start")) {
                    return true;
                }
                return this.isKeyword(seg, "summary");
            }
            case 't': {
                if (this.isKeyword(seg, "table")) {
                    return true;
                }
                if (this.isKeyword(seg, "tbody")) {
                    return true;
                }
                if (this.isKeyword(seg, "td")) {
                    return true;
                }
                if (this.isKeyword(seg, "text")) {
                    return true;
                }
                if (this.isKeyword(seg, "text-align")) {
                    return true;
                }
                if (this.isKeyword(seg, "textarea")) {
                    return true;
                }
                if (this.isKeyword(seg, "tfoot")) {
                    return true;
                }
                if (this.isKeyword(seg, "th")) {
                    return true;
                }
                if (this.isKeyword(seg, "thead")) {
                    return true;
                }
                if (this.isKeyword(seg, "title")) {
                    return true;
                }
                if (this.isKeyword(seg, "tr")) {
                    return true;
                }
                if (this.isKeyword(seg, "tt")) {
                    return true;
                }
                if (this.isKeyword(seg, "tabindex")) {
                    return true;
                }
                if (this.isKeyword(seg, "target")) {
                    return true;
                }
                if (this.isKeyword(seg, "topmargin")) {
                    return true;
                }
                return this.isKeyword(seg, "type");
            }
            case 'u': {
                if (this.isKeyword(seg, "u")) {
                    return true;
                }
                if (this.isKeyword(seg, "ul")) {
                    return true;
                }
                if (this.isKeyword(seg, "url")) {
                    return true;
                }
                return this.isKeyword(seg, "usemap");
            }
            case 'v': {
                if (this.isKeyword(seg, "var")) {
                    return true;
                }
                if (this.isKeyword(seg, "valign")) {
                    return true;
                }
                if (this.isKeyword(seg, "value")) {
                    return true;
                }
                if (this.isKeyword(seg, "valuetype")) {
                    return true;
                }
                if (this.isKeyword(seg, "version")) {
                    return true;
                }
                if (this.isKeyword(seg, "vlink")) {
                    return true;
                }
                return this.isKeyword(seg, "vspace");
            }
            case 'w': {
                if (this.isKeyword(seg, "wbr")) {
                    return true;
                }
                if (this.isKeyword(seg, "weight")) {
                    return true;
                }
                return this.isKeyword(seg, "width");
            }
            case 'x': {
                return this.isKeyword(seg, "xmp");
            }
        }
        return false;
    }

    private final boolean isKeyword(Segment seg, String s) {
        int len = seg.length;
        if (len != s.length()) {
            return false;
        }
        char[] buf = this.buffer;
        int start = this.segmentStart;
        int i = 1;
        while (i < len) {
            if (s.charAt(i) != buf[start + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final Segment parseNumberLiteral() {
        int c;
        this.advance();
        while (48 <= (c = this.current) && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70 || c == 108 || c == 76 || c == 35 || c == 46 || c == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private final boolean isSymbol(int c) {
        switch (c) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

