/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class CppParser
extends TextParser {
    protected Segment nextSegment() {
        Segment whitespace = this.parseWhitespace();
        if (whitespace != null) {
            return whitespace;
        }
        int c = this.current;
        if (c == 123 || c == 125 || c == 40 || c == 41 || c == 91 || c == 93) {
            this.advance();
            return this.newSegment(8);
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            Segment id = this.parseIdentifier();
            if (this.isKeyword(id)) {
                return new Segment(6, 8, id.offset, id.length);
            }
            return id;
        }
        if (c == 35) {
            this.advance();
            if (!Character.isJavaIdentifierStart((char)this.current)) {
                return this.newSegment(0);
            }
            Segment id = this.parseIdentifier();
            if (this.isPreprocessor(id)) {
                return new Segment(7, 8, id.offset, id.length);
            }
            return id;
        }
        if (c == 47 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(10);
        }
        if (c == 47 && this.next == 42) {
            this.advance();
            this.advance();
            int mods = 16;
            if (this.current == 42) {
                this.advance();
                mods = 0;
            }
            return this.newSegment(11, 0);
        }
        if (c == 42 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(12);
        }
        if (!(c != 34 && c != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (48 <= c && c <= 57 || c == 45 && 48 <= this.next && this.next <= 57) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current)) {
            if (!this.advance()) break;
        }
        return this.newSegment(0);
    }

    private final Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current)) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private final boolean isPreprocessor(Segment seg) {
        if (this.isKeyword(seg, "#if")) {
            return true;
        }
        if (this.isKeyword(seg, "#ifdef")) {
            return true;
        }
        if (this.isKeyword(seg, "#ifndef")) {
            return true;
        }
        if (this.isKeyword(seg, "#else")) {
            return true;
        }
        if (this.isKeyword(seg, "#elif")) {
            return true;
        }
        if (this.isKeyword(seg, "#endif")) {
            return true;
        }
        if (this.isKeyword(seg, "#include")) {
            return true;
        }
        if (this.isKeyword(seg, "#define")) {
            return true;
        }
        if (this.isKeyword(seg, "#undef")) {
            return true;
        }
        if (this.isKeyword(seg, "#line")) {
            return true;
        }
        if (this.isKeyword(seg, "#error")) {
            return true;
        }
        return this.isKeyword(seg, "#pragma");
    }

    private final boolean isKeyword(Segment seg) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(seg, "asm")) {
                    return true;
                }
                return this.isKeyword(seg, "auto");
            }
            case 'b': {
                if (this.isKeyword(seg, "bool")) {
                    return true;
                }
                return this.isKeyword(seg, "break");
            }
            case 'c': {
                if (this.isKeyword(seg, "case")) {
                    return true;
                }
                if (this.isKeyword(seg, "catch")) {
                    return true;
                }
                if (this.isKeyword(seg, "char")) {
                    return true;
                }
                if (this.isKeyword(seg, "class")) {
                    return true;
                }
                if (this.isKeyword(seg, "const")) {
                    return true;
                }
                if (this.isKeyword(seg, "const_cast")) {
                    return true;
                }
                return this.isKeyword(seg, "continue");
            }
            case 'd': {
                if (this.isKeyword(seg, "default")) {
                    return true;
                }
                if (this.isKeyword(seg, "delete")) {
                    return true;
                }
                if (this.isKeyword(seg, "do")) {
                    return true;
                }
                if (this.isKeyword(seg, "double")) {
                    return true;
                }
                return this.isKeyword(seg, "dynamic_cast");
            }
            case 'e': {
                if (this.isKeyword(seg, "else")) {
                    return true;
                }
                if (this.isKeyword(seg, "enum")) {
                    return true;
                }
                if (this.isKeyword(seg, "explicit")) {
                    return true;
                }
                return this.isKeyword(seg, "extern");
            }
            case 'f': {
                if (this.isKeyword(seg, "false")) {
                    return true;
                }
                if (this.isKeyword(seg, "float")) {
                    return true;
                }
                if (this.isKeyword(seg, "for")) {
                    return true;
                }
                return this.isKeyword(seg, "friend");
            }
            case 'g': {
                return this.isKeyword(seg, "goto");
            }
            case 'i': {
                if (this.isKeyword(seg, "if")) {
                    return true;
                }
                if (this.isKeyword(seg, "inline")) {
                    return true;
                }
                return this.isKeyword(seg, "int");
            }
            case 'l': {
                return this.isKeyword(seg, "long");
            }
            case 'm': {
                return this.isKeyword(seg, "mutable");
            }
            case 'n': {
                if (this.isKeyword(seg, "namespace")) {
                    return true;
                }
                return this.isKeyword(seg, "new");
            }
            case 'o': {
                return this.isKeyword(seg, "operator");
            }
            case 'p': {
                if (this.isKeyword(seg, "private")) {
                    return true;
                }
                if (this.isKeyword(seg, "protected")) {
                    return true;
                }
                return this.isKeyword(seg, "public");
            }
            case 'r': {
                if (this.isKeyword(seg, "register")) {
                    return true;
                }
                if (this.isKeyword(seg, "reinterpret_cast")) {
                    return true;
                }
                return this.isKeyword(seg, "return");
            }
            case 's': {
                if (this.isKeyword(seg, "short")) {
                    return true;
                }
                if (this.isKeyword(seg, "signed")) {
                    return true;
                }
                if (this.isKeyword(seg, "sizeof")) {
                    return true;
                }
                if (this.isKeyword(seg, "static")) {
                    return true;
                }
                if (this.isKeyword(seg, "static_cast")) {
                    return true;
                }
                if (this.isKeyword(seg, "struct")) {
                    return true;
                }
                return this.isKeyword(seg, "switch");
            }
            case 't': {
                if (this.isKeyword(seg, "template")) {
                    return true;
                }
                if (this.isKeyword(seg, "this")) {
                    return true;
                }
                if (this.isKeyword(seg, "throw")) {
                    return true;
                }
                if (this.isKeyword(seg, "true")) {
                    return true;
                }
                if (this.isKeyword(seg, "try")) {
                    return true;
                }
                if (this.isKeyword(seg, "typedef")) {
                    return true;
                }
                if (this.isKeyword(seg, "typeid")) {
                    return true;
                }
                return this.isKeyword(seg, "typename");
            }
            case 'u': {
                if (this.isKeyword(seg, "union")) {
                    return true;
                }
                if (this.isKeyword(seg, "unsigned")) {
                    return true;
                }
                return this.isKeyword(seg, "using");
            }
            case 'v': {
                if (this.isKeyword(seg, "virtual")) {
                    return true;
                }
                if (this.isKeyword(seg, "void")) {
                    return true;
                }
                return this.isKeyword(seg, "volatile");
            }
            case 'w': {
                if (this.isKeyword(seg, "wchar_t")) {
                    return true;
                }
                return this.isKeyword(seg, "while");
            }
        }
        return false;
    }

    private final boolean isKeyword(Segment seg, String s) {
        int len = seg.length;
        if (len != s.length()) {
            return false;
        }
        char[] buf = this.buffer;
        int start = this.segmentStart;
        int i = 1;
        while (i < len) {
            if (s.charAt(i) != buf[start + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final Segment parseNumberLiteral() {
        int c;
        this.advance();
        if (this.last == 48 && (this.current == 120 || this.current == 88)) {
            this.advance();
        }
        while (48 <= (c = this.current) && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70 || c == 108 || c == 76 || c == 46 || c == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private final boolean isSymbol(int c) {
        switch (c) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

