/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.commands.EditCommand;

public class WordWrap
extends EditCommand {
    public WordWrap(BTextEditor editor) {
        super(editor, BKeyBindings.wordWrap);
    }

    public CommandArtifact doInvoke() {
        String orig = this.editor.getModel().getSelectedText();
        if (orig == null || orig.length() == 0) {
            return null;
        }
        char[] wrap = WordWrap.wrap(orig.toCharArray(), 79);
        return this.insert(wrap);
    }

    public static String wrap(String orig, int lineWidth) {
        return new String(WordWrap.wrap(orig.toCharArray(), lineWidth));
    }

    public static char[] wrap(char[] orig, int lineWidth) {
        try {
            String normal = WordWrap.stripRNs(orig);
            String[] words = WordWrap.parse(normal);
            CharArrayWriter out = new CharArrayWriter();
            int line = 0;
            boolean lastWasBreak = true;
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (word.charAt(0) == '\n') {
                    if (!lastWasBreak) {
                        out.write(10);
                    }
                    out.write(word);
                    lastWasBreak = true;
                    continue;
                }
                if (lastWasBreak) {
                    out.write(word);
                    line = word.length();
                } else if (line + 1 + word.length() > lineWidth) {
                    out.write(10);
                    out.write(word);
                    line = word.length();
                } else {
                    out.write(32);
                    out.write(word);
                    line += 1 + word.length();
                }
                lastWasBreak = false;
            }
            return out.toCharArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    static String stripRNs(char[] orig) {
        StringBuffer s = new StringBuffer(orig.length);
        int origLength = orig.length;
        for (int i = 0; i < origLength; ++i) {
            char next;
            char cur = orig[i];
            char c = next = i + 1 < origLength ? orig[i + 1] : (char)'\u0000';
            if (cur == '\r' && next == '\n') continue;
            s.append(cur);
        }
        return s.toString();
    }

    static String[] parse(String src) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(new String(src), " \n", true);
        boolean lastWasNewline = false;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            char c = tok.charAt(0);
            if (c != ' ' && (c != '\n' || lastWasNewline)) {
                v.add(tok);
            }
            lastWasNewline = tok.charAt(0) == '\n';
        }
        return v.toArray(new String[v.size()]);
    }
}

