/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.TextEditorCommand;

public class ToggleSlashSlash
extends TextEditorCommand {
    public ToggleSlashSlash(BTextEditor editor) {
        super(editor, BKeyBindings.toggleSlashSlash);
    }

    public CommandArtifact doInvoke() {
        if (this.editor.getSelection().isEmpty()) {
            return null;
        }
        Artifact art = new Artifact(this.editor);
        return art.invoke();
    }

    static class Artifact
    implements CommandArtifact {
        BTextEditor editor;
        int line0;
        int line1;

        Artifact(BTextEditor editor) {
            Position start = editor.getSelection().getStart();
            Position end = editor.getSelection().getEnd();
            this.editor = editor;
            this.line0 = start.line;
            this.line1 = end.column > 0 ? end.line : end.line - 1;
        }

        Artifact invoke() {
            String text = this.toggle(this.getLines());
            Position rs = new Position(this.line0, 0);
            Position re = new Position(this.line1, this.editor.getModel().getLine(this.line1).getColumnCount());
            this.editor.getModel().remove(rs, re);
            this.editor.getModel().insert(rs, text);
            return this;
        }

        private String toggle(String[] lines) {
            boolean comment = !lines[0].startsWith("//");
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int j = 0;
                if (comment) {
                    if (!line.startsWith("//")) {
                        s.append('/').append('/');
                    }
                } else if (line.startsWith("//")) {
                    j = 2;
                }
                while (j < line.length()) {
                    s.append(line.charAt(j));
                    ++j;
                }
            }
            return s.toString();
        }

        private String[] getLines() {
            String[] lines = new String[this.line1 - this.line0 + 1];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = new String(this.editor.getModel().getLine((int)(i + this.line0)).buffer);
            }
            return lines;
        }

        public void undo() {
            this.invoke();
        }

        public void redo() {
            this.invoke();
        }
    }
}

