/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import java.util.ArrayList;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.FindNext;
import javax.baja.ui.text.commands.InsertText;
import javax.baja.ui.text.commands.TextEditorCommand;

public class ReplaceAll
extends TextEditorCommand {
    private String replaceWith;
    private int count;

    public ReplaceAll(BTextEditor editor, String replaceWith) {
        super(editor, "null");
        this.replaceWith = replaceWith;
    }

    public CommandArtifact doInvoke() {
        ArrayList<CommandArtifact> list = new ArrayList<CommandArtifact>();
        while (this.findNext()) {
            Position pos1 = this.editor.getSelection().getAnchor();
            list.add(new InsertText(this.editor, this.replaceWith).doInvoke());
            Position pos2 = this.editor.getCaretPosition();
            this.editor.getSelection().select(pos1, pos2);
        }
        this.count = list.size();
        return new CompoundCommand.Artifact(list.toArray(new CommandArtifact[list.size()]));
    }

    private boolean findNext() {
        FindNext cmd = new FindNext(this.editor);
        cmd.doInvoke();
        return cmd.getFoundPosition() != null;
    }

    public int getCount() {
        return this.count;
    }
}

