/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.MoveCommand;

public class PageDown
extends MoveCommand {
    public PageDown(BTextEditor editor) {
        super(editor, BKeyBindings.pageDown);
    }

    public CommandArtifact doInvoke() throws Exception {
        Line targetLine;
        Position cur = this.editor.getCaretPosition();
        int visible = this.editor.getVisibleLineCount();
        int lineCount = this.editor.getModel().getLineCount();
        int targetLineNumber = Math.min(cur.line + visible - 1, lineCount - 1);
        Line curLine = this.editor.getModel().getLine(cur.line);
        if (curLine == (targetLine = this.editor.getModel().getLine(targetLineNumber))) {
            return null;
        }
        double caretX = this.editor.getRenderer().getLineWidth(curLine, 0, cur.column + 1);
        int targetColumn = this.editor.getRenderer().xToColumn(targetLine, caretX);
        Position to = new Position(targetLineNumber, targetColumn);
        return this.move(cur, to);
    }
}

