/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.sys.Property;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.TextEditorCommand;

public abstract class MoveCommand
extends TextEditorCommand {
    private boolean shiftDown;

    MoveCommand(BTextEditor editor, Property keyBinding) {
        super(editor, keyBinding);
    }

    MoveCommand(BTextEditor editor, String keyName) {
        super(editor, keyName);
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public void setShiftDown(boolean shiftDown) {
        this.shiftDown = shiftDown;
    }

    public CommandArtifact move(Position oldPos, Position newPos) {
        if (oldPos.equals(newPos = this.clip(newPos))) {
            return null;
        }
        MoveCaretArtifact artifact = new MoveCaretArtifact(this.editor, oldPos, newPos);
        artifact.redo();
        if (this.shiftDown) {
            Position anchor = this.editor.getSelection().getAnchor();
            if (anchor == null) {
                anchor = oldPos;
            }
            this.editor.getSelection().select(anchor, newPos);
        } else {
            this.editor.getSelection().deselect();
        }
        if (this.editor.getOptions().getUndoNavigation()) {
            return artifact;
        }
        return null;
    }

    Position clip(Position pos) {
        int colCount;
        int lineCount = this.editor.getModel().getLineCount();
        int q = pos.line;
        int c = pos.column;
        if (q > lineCount - 1) {
            q = lineCount - 1;
        }
        if (q < 0) {
            q = 0;
        }
        if (q == lineCount - 1 && c > (colCount = this.editor.getModel().getLine(q).getColumnCount())) {
            c = colCount;
        }
        if (c < 0) {
            c = 0;
        }
        return new Position(q, c);
    }

    static class MoveCaretArtifact
    implements CommandArtifact {
        private BTextEditor editor;
        private Position oldPos;
        private Position newPos;

        MoveCaretArtifact(BTextEditor editor, Position oldPos, Position newPos) {
            this.editor = editor;
            this.oldPos = oldPos;
            this.newPos = newPos;
        }

        public void redo() {
            this.editor.moveCaretPosition(this.newPos);
        }

        public void undo() {
            this.editor.moveCaretPosition(this.oldPos);
        }
    }
}

