/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.MoveCommand;

public class LineStart
extends MoveCommand {
    public LineStart(BTextEditor editor) {
        super(editor, BKeyBindings.lineStart);
    }

    public CommandArtifact doInvoke() throws Exception {
        Position cur = this.editor.getCaretPosition();
        if (cur.column == 0) {
            return null;
        }
        int pos = cur.column;
        Line line = this.editor.getModel().getLine(cur.line);
        if (pos >= line.getColumnCount()) {
            pos = line.getColumnCount() - 1;
        }
        for (int col = pos; col >= 0; --col) {
            if (line.getSegmentAt(col).isWhitespace()) continue;
            pos = col;
        }
        if (cur.column == pos) {
            pos = 0;
        }
        Position target = new Position(cur.line, pos);
        this.editor.updateAnchorX(target);
        return this.move(cur, target);
    }
}

