/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.log.Log;
import javax.baja.sys.Property;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextSelection;
import javax.baja.ui.text.commands.TextEditorCommand;

public abstract class EditCommand
extends TextEditorCommand {
    private static Log log = Log.getLog((String)"ui.command");

    EditCommand(BTextEditor editor, Property keyBinding) {
        super(editor, keyBinding);
    }

    EditCommand(BTextEditor editor, String keyName) {
        super(editor, keyName);
    }

    CommandArtifact insert(char[] text) {
        if (!this.editor.isEditable()) {
            return null;
        }
        log.trace("-- insert: " + TextModel.toString(text));
        RemoveArtifact remove = this.removeSelection();
        if (remove != null) {
            remove.redo();
        }
        Position pos = this.editor.getCaretPosition();
        InsertArtifact insert = new InsertArtifact(this, pos, text);
        insert.redo();
        return new CompoundCommand.Artifact(new CommandArtifact[]{remove, insert});
    }

    CommandArtifact remove(Position from, Position to) {
        if (!this.editor.isEditable()) {
            return null;
        }
        log.trace("-- remove");
        RemoveArtifact remove = this.removeSelection();
        if (remove == null) {
            if (from == null || to == null) {
                return null;
            }
            remove = new RemoveArtifact(this, from, to);
        }
        remove.redo();
        return remove;
    }

    RemoveArtifact removeSelection() {
        TextSelection sel = this.editor.getSelection();
        if (!sel.isEmpty()) {
            Position start = sel.getStart();
            Position end = sel.getEnd();
            return new RemoveArtifact(this, start, end);
        }
        return null;
    }

    CommandArtifact compose(char[] composedText, String committedText, int composedStart, int composedEnd, int caretCharIndex, boolean commit, boolean deleteComposed) {
        if (!this.editor.isEditable()) {
            return null;
        }
        log.trace("-- compose: ComposedText=" + this.getComposedTextString(composedText) + ", CommittedText=" + committedText + ", composedStart=" + composedStart + ", composedEnd=" + composedEnd + ", caretCharIndex=" + caretCharIndex + ", commit=" + commit + ", deleteComposed=" + deleteComposed);
        RemoveArtifact remove = this.removeSelection();
        if (remove != null) {
            remove.redo();
        }
        ComposeArtifact compose = new ComposeArtifact(this, composedText, composedStart, composedEnd, committedText, caretCharIndex, commit, deleteComposed);
        compose.redo();
        return new CompoundCommand.Artifact(new CommandArtifact[]{remove, compose});
    }

    private String getComposedTextString(char[] a) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            char c = a[i];
            String hexCode = Integer.toHexString(c).toUpperCase();
            String hexCodeWithAllLeadingZeros = "0000" + hexCode;
            String hexCodeWithLeadingZeros = hexCodeWithAllLeadingZeros.substring(hexCodeWithAllLeadingZeros.length() - 4);
            sb.append("\\u" + hexCodeWithLeadingZeros);
        }
        return sb.toString();
    }

    class ComposeArtifact
    extends AbstractEditArtifact {
        private Position origPos;
        private Position origCaretPos;
        private char[] text;
        private String committedText = null;
        private int composedStart;
        private int composedEnd;
        private int origComposedStart;
        private int origComposedEnd;
        private int caretCharacterIndex;
        private boolean commit;
        private boolean deleteComposed;
        private char[] origText = null;

        ComposeArtifact(EditCommand c, char[] text, int composedStart, int composedEnd, String committedText, int caretCharIndex, boolean commit, boolean deleteComposed) {
            super(c);
            this.text = text;
            this.commit = commit;
            this.committedText = committedText;
            this.deleteComposed = deleteComposed;
            this.composedStart = composedStart;
            this.composedEnd = composedEnd;
            this.caretCharacterIndex = caretCharIndex;
            log.trace("  ComposeArtifact<init>: " + TextModel.toString(text));
            TextController controller = this.editor.getController();
            this.origPos = controller.getComposedPosition();
            if (this.origPos == null) {
                this.origPos = this.editor.getCaretPosition();
                if (text.length > 0) {
                    log.trace("  Set the cached composedOriginPos = " + this.origPos.toString());
                    controller.setComposedPosition(this.origPos);
                }
            }
            this.origCaretPos = this.editor.getCaretPosition();
            this.origComposedStart = controller.getTextBeginIndex();
            this.origComposedEnd = controller.getTextEndIndex();
        }

        public void redo() {
            Position nextPos;
            log.trace("  doCompose: " + this.composedStart + " to " + this.composedEnd + " at " + this.origPos + " for " + TextModel.toString(this.text) + " deleteComposed: " + this.deleteComposed + " commit: " + this.commit);
            TextController controller = this.editor.getController();
            TextModel model = this.editor.getModel();
            if (this.deleteComposed) {
                Position startPos = new Position(this.origPos.line, this.origPos.column + this.origComposedStart);
                Position endPos = new Position(this.origPos.line, this.origPos.column + this.origComposedEnd);
                if (!startPos.equals(endPos)) {
                    endPos = model.getPrevPosition(endPos);
                }
                this.origText = model.getCharArray(startPos, endPos);
                log.trace("  deleteComposed " + TextModel.toString(this.origText) + " from " + startPos + " to " + endPos);
                model.remove(startPos, endPos);
            }
            if (this.commit && this.committedText != null && this.committedText.length() > 0) {
                log.trace("  insertCommitted " + this.committedText + " at " + this.origPos);
                model.insert(this.origPos, this.committedText.toCharArray(), 0, this.committedText.length());
                nextPos = new Position(this.origPos.line, this.origPos.column + this.committedText.length());
                log.trace("  move caret to " + nextPos);
                this.editor.moveCaretPosition(nextPos);
            } else if (this.text.length > 0) {
                log.trace("  insertComposed " + TextModel.toString(this.text) + " at " + this.origPos);
                model.insert(this.origPos, this.text, 0, this.text.length);
                if (this.caretCharacterIndex > 0) {
                    nextPos = new Position(this.origPos.line, this.origPos.column + this.caretCharacterIndex);
                    log.trace("  move caret to " + nextPos);
                    this.editor.moveCaretPosition(nextPos);
                }
            }
            if (this.commit) {
                log.trace("  Reset the cached composedOriginPos = null");
                controller.setComposedPosition(null);
                controller.setTextBeginIndex(0);
                controller.setTextEndIndex(0);
            } else {
                controller.setTextBeginIndex(this.composedStart);
                controller.setTextEndIndex(this.composedEnd);
            }
            this.editor.updateAnchorX();
        }

        public void undo() {
            Position nextPos;
            log.trace("  undoCompose: " + this.composedStart + " to " + this.composedEnd + " at " + this.origPos + " for " + TextModel.toString(this.text) + " deleteComposed: " + this.deleteComposed + " commit: " + this.commit);
            if (this.origPos == null) {
                return;
            }
            TextController controller = this.editor.getController();
            TextModel model = this.editor.getModel();
            if (this.commit && this.committedText != null && this.committedText.length() > 0) {
                log.trace("  removeCommitted " + this.committedText + " at " + this.origPos);
                nextPos = new Position(this.origPos.line, this.origPos.column + this.committedText.length());
                if (!this.origPos.equals(nextPos)) {
                    nextPos = model.getPrevPosition(nextPos);
                }
                model.remove(this.origPos, nextPos);
            } else if (this.text.length > 0) {
                log.trace("  removeComposed " + TextModel.toString(this.text) + " at " + this.origPos);
                nextPos = new Position(this.origPos.line, this.origPos.column + this.text.length);
                if (!this.origPos.equals(nextPos)) {
                    nextPos = model.getPrevPosition(nextPos);
                }
                model.remove(this.origPos, nextPos);
            }
            if (this.origText != null) {
                Position startPos = new Position(this.origPos.line, this.origPos.column + this.composedStart);
                model.insert(startPos, this.origText, 0, this.origText.length);
            }
            if (this.origCaretPos != null) {
                this.editor.moveCaretPosition(this.origCaretPos);
            }
            this.editor.updateAnchorX();
            this.editor.getSelection().deselect();
            controller.setTextBeginIndex(this.origComposedStart);
            controller.setTextEndIndex(this.origComposedEnd);
            controller.setComposedPosition(this.origPos);
        }
    }

    class InsertArtifact
    extends AbstractEditArtifact {
        private Position origPos;
        private Position newPos;
        private char[] text;

        InsertArtifact(EditCommand c, Position pos, char[] text) {
            super(c);
            this.origPos = pos;
            this.text = text;
            log.trace("  InsertArtifact<init>: " + this.origPos + " -> " + TextModel.toString(text));
        }

        public void undo() {
            TextController controller = this.editor.getController();
            controller.setComposedPosition(this.origPos);
            this.doRemove(this.origPos, this.newPos);
        }

        public void redo() {
            TextController controller = this.editor.getController();
            controller.setComposedPosition(this.origPos);
            controller.setComposedPosition(null);
            controller.setTextBeginIndex(0);
            controller.setTextEndIndex(0);
            this.newPos = this.doInsert(this.origPos, this.text);
            this.newPos = this.editor.getModel().getPrevPosition(this.newPos);
        }
    }

    class RemoveArtifact
    extends AbstractEditArtifact {
        private Position fromPos;
        private Position toPos;
        private char[] text;

        RemoveArtifact(EditCommand c, Position fromPos, Position toPos) {
            super(c);
            if (!fromPos.equals(toPos)) {
                toPos = c.editor.getModel().getPrevPosition(toPos);
            }
            this.fromPos = fromPos;
            this.toPos = toPos;
            this.text = c.editor.getModel().getCharArray(fromPos, toPos);
            log.trace("    RemoveArtifact<init>: " + fromPos + " -> " + toPos + " -> " + TextModel.toString(this.text));
        }

        public void undo() {
            this.doInsert(this.fromPos, this.text);
        }

        public void redo() {
            this.doRemove(this.fromPos, this.toPos);
        }
    }

    static abstract class AbstractEditArtifact
    implements CommandArtifact {
        protected BTextEditor editor;

        AbstractEditArtifact(EditCommand c) {
            this.editor = c.editor;
        }

        protected void doRemove(Position fromPos, Position toPos) {
            log.trace("  doRemove: " + fromPos + " -> " + toPos);
            this.editor.getModel().remove(fromPos, toPos);
            this.editor.moveCaretPosition(fromPos);
            this.editor.updateAnchorX();
            this.editor.getSelection().deselect();
            TextController controller = this.editor.getController();
            controller.setComposedPosition(null);
            controller.setTextBeginIndex(0);
            controller.setTextEndIndex(0);
        }

        protected Position doInsert(Position pos, char[] text) {
            log.trace("  doInsert: " + pos + " -> " + TextModel.toString(text));
            pos = this.editor.getModel().insert(pos, text, 0, text.length);
            this.editor.moveCaretPosition(pos);
            this.editor.updateAnchorX();
            return pos;
        }
    }
}

