/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.ui.BDropDown;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;

public class TextRenderer
extends BTextEditor.TextSupport {
    static BBrush inverseBrush = BBrush.makeInverse((BColor)BColor.black);
    BFont font;
    double cellHeight;
    double baseline;
    Position matchOpenPos;
    Position matchClosePos;

    public TextRenderer() {
        this(Theme.textEditor().getFixedWidthFont());
    }

    public TextRenderer(BFont font) {
        this.font = font;
        double w1 = font.width(".");
        double w2 = font.width("m");
        if (w1 != w2) {
            throw new IllegalStateException("Not fixed width font: " + font.getName());
        }
        this.cellHeight = font.getHeight() - 1.0;
        this.baseline = this.cellHeight - 2.0;
    }

    public double getLineHeight() {
        return this.cellHeight;
    }

    public double getLineWidth(Line line) {
        return line.getWidth(this.font);
    }

    public double getLineWidth(Line line, int startChar, int endChar) {
        return line.getWidth(this.font, startChar, endChar);
    }

    public double getColumnWidth(Line line, int col) {
        if (line == null || col >= line.buffer.length) {
            return this.font.width("m");
        }
        return this.font.width((int)line.buffer[col]);
    }

    public double columnToX(Line line, int column) {
        int x = 0;
        for (int i = 0; i < column; ++i) {
            x = (int)((double)x + this.getColumnWidth(line, i));
        }
        return x;
    }

    public int xToColumn(Line line, double x) {
        int columnCount = line.getColumnCountWithoutNewline();
        double totalWidth = 0.0;
        double columnWidth = 0.0;
        for (int i = 0; i < columnCount; ++i) {
            columnWidth = this.getColumnWidth(line, i);
            if (!((totalWidth += columnWidth) > x)) continue;
            double distanceFromRightEdge = totalWidth - x;
            if (distanceFromRightEdge < columnWidth / 2.0 && i < columnCount - 1) {
                return i + 1;
            }
            return i;
        }
        return columnCount;
    }

    public void paintBackground(Graphics g) {
        IRectGeom clip = g.getClipBounds();
        BInsets insets = this.editor.getInsets();
        double lineHeight = this.getLineHeight();
        g.setBrush(this.getBackground());
        if (this.editor.isSingleLine() && !(this.editor.getParent() instanceof BDropDown)) {
            g.fillRect(0.0, 0.0, 32000.0, lineHeight + insets.top + insets.bottom);
        } else {
            g.fill((IGeom)clip);
        }
    }

    public void paintLine(Graphics g, LineInfo info) {
        char[] buffer = info.line.buffer;
        Segment[] segments = info.line.segments;
        double x = 0.0;
        int selStart = info.selectionStartColumn;
        int selEnd = info.selectionEndColumn;
        boolean isSel = selStart >= 0;
        int q = info.lineIndex;
        if (this.matchOpenPos != null) {
            double columnX;
            double columnWidth;
            if (this.matchOpenPos.line == q) {
                g.setBrush(BColor.yellow);
                columnWidth = this.getColumnWidth(info.line, this.matchOpenPos.column);
                columnX = this.columnToX(info.line, this.matchOpenPos.column);
                g.fillRect(columnX, 0.0, columnWidth, this.cellHeight);
            }
            if (this.matchClosePos.line == q) {
                g.setBrush(BColor.yellow);
                columnWidth = this.getColumnWidth(info.line, this.matchClosePos.column);
                columnX = this.columnToX(info.line, this.matchClosePos.column);
                g.fillRect(columnX, 0.0, columnWidth, this.cellHeight);
            }
        }
        if (isSel) {
            double selWidth = selEnd == Integer.MAX_VALUE ? this.getEditor().getWidth() : this.columnToX(info.line, selEnd) - this.columnToX(info.line, selStart);
            g.setBrush(this.getSelectionBackground());
            g.fillRect(this.columnToX(info.line, selStart), 0.0, selWidth, this.cellHeight);
        }
        g.setFont(this.font);
        for (int i = 0; i < segments.length; ++i) {
            Segment segment = segments[i];
            int type = segment.type;
            int mods = segment.modifiers;
            int offset = segment.offset;
            int length = segment.length;
            if (isSel && selStart <= offset && offset + length <= selEnd) {
                g.setBrush(this.getSelectionForeground());
                x += this.paintSegment(g, x, buffer, type, mods, offset, length);
                continue;
            }
            g.setBrush(this.getForeground(segment));
            x += this.paintSegment(g, x, buffer, type, mods, offset, length);
            if (!isSel || selStart > offset + length || offset > selEnd) continue;
            int selOffset = offset < selStart ? selStart : offset;
            double selX = this.columnToX(info.line, selOffset);
            int selLength = Math.min(length - (selOffset - offset), selEnd - selOffset);
            double selWidth = this.columnToX(info.line, selOffset + selLength) - selX;
            g.setBrush(this.getSelectionForeground());
            this.paintSegment(g, selX, buffer, type, mods, selOffset, selLength);
        }
    }

    public BBrush getSelectionForeground() {
        return Theme.textEditor().getSelectionForeground();
    }

    public BBrush getSelectionBackground() {
        return Theme.textEditor().getSelectionBackground();
    }

    public BBrush getBackground() {
        return Theme.textEditor().getTextBackground(this.editor);
    }

    public BBrush getForeground(Segment seg) {
        if (!this.getEditor().isEnabled() || !this.getEditor().getParentWidget().isEnabled()) {
            return Theme.textEditor().getDisabledTextBrush(this.getEditor());
        }
        return BTextEditorOptions.make().getColorCoding().getColor(seg).toBrush();
    }

    double paintSegment(Graphics g, double x, char[] buffer, int type, int mods, int offset, int length) {
        switch (type) {
            case 1: {
                if (this.getOptions().getShowSpaces()) {
                    this.paintSpaces(g, x, length);
                }
                return this.font.width(" ") * (double)length;
            }
            case 2: {
                if (this.getOptions().getShowTabs()) {
                    this.paintTab(g, x);
                }
                return this.font.width("\t");
            }
            case 3: {
                if (this.getOptions().getShowNewlines()) {
                    this.paintNewline(g, x, mods);
                }
                return 0.0;
            }
        }
        g.drawString(buffer, offset, length, x, this.baseline);
        return this.font.width(buffer, offset, length);
    }

    void paintSpaces(Graphics g, double x, int len) {
        double spaceWidth = this.font.width(" ");
        for (int i = 0; i < len; ++i) {
            g.strokeLine(x + 1.0, this.baseline - 1.0, x + spaceWidth - 2.0, this.baseline - 1.0);
            x += spaceWidth;
        }
    }

    double paintTab(Graphics g, double x) {
        double tabWidth = this.font.width("\t");
        g.strokeLine(x + 1.0, 2.0, tabWidth - 3.0, this.baseline - 3.0);
        return x + tabWidth;
    }

    void paintNewline(Graphics g, double xCell, int mods) {
        double x = xCell + 1.0;
        double y = 2.0;
        double w = this.font.width("n") - 2.0;
        double h = this.baseline - 3.0;
        if ((mods & 1) != 0) {
            g.drawString("n", x, this.baseline);
        } else if ((mods & 2) != 0) {
            g.drawString("r", x, this.baseline);
        } else {
            g.strokeRect(x, y, w, h);
        }
    }

    public void paintCaret(Graphics g, LineInfo lineInfo, int col) {
        g.setBrush(inverseBrush);
        g.fillRect(this.columnToX(lineInfo.line, col), 0.0, 2.0, this.cellHeight - 1.0);
    }

    public static class LineInfo {
        public Line line;
        public int lineIndex;
        public int selectionStartColumn;
        public int selectionEndColumn;
    }
}

