/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.baja.nre.util.TextUtil;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;

public class TextModel
extends BTextEditor.TextSupport {
    private String text;
    private Line[] lines = new Line[]{new Line(new char[0], new Segment[0])};
    double prefWidth;
    double prefHeight;
    int textLength = 0;
    double anchorX = 0.0;

    public int getLineCount() {
        return this.lines.length;
    }

    public Line getLine(int line) {
        try {
            if (line >= this.lines.length) {
                return this.lines[this.lines.length - 1];
            }
            if (line < 0) {
                return this.lines[0];
            }
            return this.lines[line];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERROR TextModel.getLine(" + line + ") length=" + this.lines.length);
            throw e;
        }
    }

    public String getText() {
        if (this.text == null) {
            try {
                StringWriter out = new StringWriter();
                this.write(out);
                this.text = out.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.toString());
            }
        }
        return this.text;
    }

    public String getText(Position fromPos, Position toPos) {
        return new String(this.getCharArray(fromPos, toPos));
    }

    public char[] getCharArray(Position fromPos, Position toPos) {
        if (toPos.compareTo(fromPos) < 0) {
            throw new IllegalArgumentException("toPos < fromPos");
        }
        char[] buf = new char[256];
        int count = 0;
        for (int q = fromPos.line; q <= toPos.line; ++q) {
            int c1;
            Line line = this.getLine(q);
            int lineLen = line.buffer.length;
            int c2 = q == toPos.line ? Math.min(toPos.column, lineLen - 1) : lineLen - 1;
            int len = c2 - (c1 = q == fromPos.line ? Math.min(fromPos.column, lineLen - 1) : 0) + 1;
            if (count + len >= buf.length) {
                char[] temp = new char[Math.max(count * 2, count + len)];
                System.arraycopy(buf, 0, temp, 0, count);
                buf = temp;
            }
            try {
                if (c1 < 0) continue;
                System.arraycopy(line.buffer, c1, buf, count, len);
                count += len;
                continue;
            }
            catch (RuntimeException e) {
                System.out.println("ERROR: TextModel.getCharArray(" + fromPos + "," + toPos + ")");
                System.out.println("  q          = " + q);
                System.out.println("  buf.length = " + buf.length);
                System.out.println("  count      = " + count);
                System.out.println("  len        = " + len);
                System.out.println("  lineLen    = " + lineLen);
                System.out.println("  c1         = " + c1);
                System.out.println("  c2         = " + c2);
                System.out.println("  e          = " + e);
                throw e;
            }
        }
        char[] result = new char[count];
        System.arraycopy(buf, 0, result, 0, count);
        return result;
    }

    public void setText(String text) {
        this.update(text.toCharArray());
        this.text = text;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(double anchorX) {
        this.anchorX = anchorX;
    }

    public void read(Reader in, int length) throws IOException {
        int n;
        char[] buf = new char[length];
        for (int count = 0; count < length; count += n) {
            n = in.read(buf, count, length - count);
            if (n >= 0) continue;
            throw new IOException("Unexpected EOF: " + this);
        }
        this.update(buf);
    }

    public void read(Reader in) throws IOException {
        int n;
        CharArrayWriter out = new CharArrayWriter();
        char[] buf = new char[256];
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
        }
        this.update(out.toCharArray());
    }

    public void read(char[] buf) {
        this.update(buf);
    }

    public void write(Writer out) throws IOException {
        for (int q = 0; q < this.lines.length; ++q) {
            this.lines[q].write(out);
        }
    }

    public Position getStartPosition() {
        return new Position(0, 0);
    }

    public Position getEndPosition() {
        int q = this.getLineCount() - 1;
        return new Position(q, this.getLine(q).getColumnCount());
    }

    public Position getPrevPosition(Position pos) {
        int c = pos.column - 1;
        int q = pos.line;
        if (c < 0) {
            if (q == 0) {
                return this.getStartPosition();
            }
            c = this.getLine(--q).getColumnCount() - 1;
        }
        return new Position(q, c);
    }

    public Position getNextPosition(Position pos) {
        return new Position(pos.line, pos.column + 1);
    }

    public Position getWordLeft(Position pos) {
        block1: {
            Position left;
            Segment seg;
            int q = pos.line;
            int s = this.lines[q].getSegmentIndexAt(pos.column);
            s = s == -1 ? this.lines[q].segments.length : ++s;
            do {
                if (--s >= 0) continue;
                if (--q < 0) break block1;
                s = this.lines[q].segments.length - 1;
            } while (!(seg = this.lines[q].segments[s]).isWord() || (left = new Position(q, seg.offset)).equals(pos));
            return left;
        }
        return this.getStartPosition();
    }

    public Position getWordRight(Position pos) {
        block7: {
            Segment seg;
            boolean wordEnd = this.editor.getOptions().getWordRightToEndOfWord();
            int q = pos.line;
            int s = this.getLine(q).getSegmentIndexAt(pos.column);
            if (s == -1) {
                s = this.lines[q].segments.length;
            } else if (wordEnd) {
                --s;
            }
            if (!wordEnd && s == this.lines[q].segments.length - 2) {
                Segment seg2 = this.lines[q].segments[s];
                return new Position(q, seg2.offset + seg2.length);
            }
            while (true) {
                if (++s >= this.lines[q].segments.length) {
                    if (++q < this.lines.length) {
                        s = 0;
                        if (this.lines[q].segments.length <= 1) continue;
                    }
                    break block7;
                }
                if ((seg = this.lines[q].segments[s]).isWord()) break;
            }
            return new Position(q, wordEnd ? seg.offset + seg.length : seg.offset);
        }
        return this.getEndPosition();
    }

    public Position findNext(FindPattern pattern) {
        String text = pattern.string;
        if (text == null || text.length() == 0) {
            return null;
        }
        Position cur = this.getEditor().getCaretPosition();
        int c = cur.column;
        int len = text.length();
        for (int q = cur.line; q < this.lines.length; ++q) {
            char[] buffer = this.lines[q].buffer;
            int x = pattern.findNext(buffer, c, buffer.length - c);
            if (x != -1) {
                return new Position(q, x);
            }
            c = 0;
        }
        return null;
    }

    public Position findPrev(FindPattern pattern) {
        String text = pattern.string;
        if (text == null || text.length() == 0) {
            return null;
        }
        Position cur = this.getEditor().getCaretPosition();
        int len = text.length();
        for (int q = cur.line; q >= 0; --q) {
            int x;
            char[] buffer = this.lines[q].buffer;
            int c = buffer.length - len;
            if (q == cur.line && cur.column - 1 < buffer.length) {
                c = cur.column - len - 1;
            }
            if ((x = pattern.findPrev(buffer, c, buffer.length - c)) == -1) continue;
            return new Position(q, x);
        }
        return null;
    }

    public Position insert(Position pos, String text) {
        char[] buf = text.toCharArray();
        return this.insert(pos, buf, 0, buf.length);
    }

    public Position insert(Position pos, char[] buf, int offset, int len) {
        if (pos.line >= this.lines.length) {
            throw new IllegalArgumentException("Position out of bounds: " + pos);
        }
        Line origLine = this.lines[pos.line];
        char[] orig = origLine.toCharArrayGrowAsNeeded(pos.column);
        char[] mix = new char[orig.length + len];
        System.arraycopy(orig, 0, mix, 0, pos.column);
        int c = pos.column;
        System.arraycopy(buf, offset, mix, c, len);
        c += len;
        if (orig.length > pos.column) {
            System.arraycopy(orig, pos.column, mix, c, orig.length - pos.column);
        }
        this.splice(pos.line, 1, mix);
        int iq = pos.line;
        int ic = pos.column;
        for (int i = 0; i < len && iq < this.lines.length; ++i) {
            if (++ic < this.lines[iq].buffer.length) continue;
            ++iq;
            ic = 0;
        }
        if (iq >= this.lines.length) {
            return this.getEndPosition();
        }
        return new Position(iq, ic);
    }

    public void remove(Position fromPos, Position toPos) {
        if (toPos.compareTo(fromPos) < 0) {
            throw new IllegalArgumentException("toPosition < fromPosition");
        }
        Line line1 = this.lines[fromPos.line];
        Line line2 = this.lines[toPos.line];
        char[] line1Char = line1.toCharArrayGrowAsNeeded(fromPos.column);
        int leftIn1 = fromPos.column;
        char[] line2Char = line2.toCharArrayGrowAsNeeded(toPos.column);
        int leftIn2 = line2Char.length - toPos.column - 1;
        if (leftIn1 + leftIn2 < 0) {
            return;
        }
        char[] cut = new char[leftIn1 + leftIn2];
        if (leftIn1 >= 0 && leftIn2 >= 0) {
            System.arraycopy(line1Char, 0, cut, 0, leftIn1);
            System.arraycopy(line2Char, toPos.column + 1, cut, fromPos.column, leftIn2);
            this.splice(fromPos.line, toPos.line - fromPos.line + 1, cut);
        }
    }

    private void splice(int q, int origLineCount, char[] buf) {
        Line[] temp;
        Line[] modLines;
        Line lastModLine;
        if ((buf.length == 0 || buf[buf.length - 1] != '\n') && q + origLineCount < this.lines.length) {
            Line join = this.lines[q + origLineCount];
            char[] temp2 = new char[buf.length + join.buffer.length];
            System.arraycopy(buf, 0, temp2, 0, buf.length);
            System.arraycopy(join.buffer, 0, temp2, buf.length, join.buffer.length);
            buf = temp2;
            ++origLineCount;
        }
        if ((lastModLine = (modLines = this.getParser().parse(buf))[modLines.length - 1]).endsWithNewline() && q + origLineCount >= this.lines.length) {
            temp = new Line[modLines.length + 1];
            System.arraycopy(modLines, 0, temp, 0, modLines.length);
            temp[modLines.length] = new Line(new char[0], new Segment[0]);
            modLines = temp;
        }
        if (origLineCount == modLines.length) {
            for (int i = 0; i < modLines.length; ++i) {
                this.lines[i + q] = modLines[i];
            }
        } else {
            temp = new Line[this.lines.length + modLines.length - origLineCount];
            System.arraycopy(this.lines, 0, temp, 0, q);
            System.arraycopy(modLines, 0, temp, q, modLines.length);
            System.arraycopy(this.lines, q + origLineCount, temp, q + modLines.length, this.lines.length - q - origLineCount);
            this.lines = temp;
        }
        this.update(this.lines);
    }

    public void cut() {
        this.getCommandFactory().make("cut").invoke();
    }

    public void copy() {
        this.getCommandFactory().make("copy").invoke();
    }

    public void paste() {
        this.getCommandFactory().make("paste").invoke();
    }

    public String getSelectedText() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        Position start = this.getSelection().getStart();
        Position end = this.getSelection().getEnd();
        end = this.getPrevPosition(end);
        return this.getText(start, end);
    }

    public char[] getSelectedCharArray() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        Position start = this.getSelection().getStart();
        Position end = this.getSelection().getEnd();
        start = this.getPrevPosition(start);
        return this.getCharArray(start, end);
    }

    protected void update(char[] buf) {
        this.update(this.getParser().parse(buf));
    }

    protected void update(Line[] lines) {
        Position end;
        Position caret;
        BTextEditor editor = this.getEditor();
        boolean singleLine = editor.isSingleLine();
        this.lines = lines;
        this.text = null;
        double pw = this.prefWidth;
        double ph = this.prefHeight;
        if (!singleLine) {
            this.walkLines(lines);
        }
        if ((caret = editor.getCaretPosition()).compareTo(end = this.getEndPosition()) > 0) {
            editor.moveCaretPosition(end);
        }
        if (!(pw == this.prefWidth && ph == this.prefHeight || singleLine)) {
            editor.relayout();
        } else {
            editor.repaint();
        }
        editor.fireTextModified(new BWidgetEvent(1, this.getEditor()));
        this.textModified();
    }

    protected void textModified() {
    }

    private void walkLines(Line[] lines) {
        TextRenderer renderer = this.getRenderer();
        int len = lines.length;
        Segment string = null;
        Segment multi = null;
        Segment line = null;
        char stringChar = '\u0000';
        int mask = 0;
        double maxw = 10.0;
        int clear = -488;
        int newlineMask = 1;
        Line first = lines[0];
        if (first.segments.length > 0) {
            Segment seg = first.segments[first.segments.length - 1];
            if (seg.isNewlineR()) {
                newlineMask = 2;
            } else if (seg.isNewlineRN()) {
                newlineMask = 4;
            }
        }
        int newTextLength = 0;
        for (int q = 0; q < len; ++q) {
            Segment[] segments = lines[q].segments;
            char[] buffer = lines[q].buffer;
            newTextLength += buffer.length;
            maxw = Math.max(maxw, renderer.getLineWidth(lines[q]));
            int segmentsLength = segments.length;
            for (int i = 0; i < segmentsLength; ++i) {
                Segment segment = segments[i];
                int type = segment.type;
                segment.modifiers &= clear;
                if (type == 3) {
                    segment.modifiers |= newlineMask;
                }
                if (multi != null) {
                    segment.modifiers |= mask;
                    if (type != 12) continue;
                    multi = null;
                    mask = 0;
                    continue;
                }
                if (line != null) {
                    segment.modifiers |= mask;
                    continue;
                }
                if (string != null) {
                    segment.modifiers |= mask;
                    if (type != 9 || buffer[segment.offset] != stringChar) continue;
                    string = null;
                    mask = 0;
                    continue;
                }
                if (type == 11) {
                    multi = segment;
                    mask = 128;
                    if (segment.isNonJavadoc()) {
                        mask |= 0x100;
                    }
                    segment.modifiers |= mask;
                    continue;
                }
                if (type == 10) {
                    line = segment;
                    mask = 64;
                    segment.modifiers |= mask;
                    continue;
                }
                if (type != 9) continue;
                string = segment;
                stringChar = buffer[segment.offset];
                mask = 32;
                segment.modifiers |= mask;
            }
            string = null;
            line = null;
        }
        this.textLength = newTextLength;
        this.prefWidth = maxw;
        this.prefHeight = renderer.getLineHeight() * (double)len;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public double getPreferredWidth() {
        return this.prefWidth;
    }

    public double getPreferredHeight() {
        return this.prefHeight;
    }

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        for (int q = 0; q < this.lines.length && q < 20; ++q) {
            this.dump(out, q, this.lines[q]);
        }
    }

    void dump(PrintWriter out, int q, Line line) {
        out.println(TextUtil.padRight((String)("" + q + ": "), (int)3) + TextModel.toString(line.buffer));
        Segment[] segs = line.segments;
        for (int i = 0; i < segs.length; ++i) {
            out.println("   " + segs[i]);
        }
    }

    public static String toString(char[] buf) {
        if (buf == null) {
            return "null";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            char c = buf[i];
            if (c == '\n') {
                s.append("\\n");
                continue;
            }
            if (c == '\r') {
                s.append("\\r");
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }
}

