/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.commands.DocumentEnd;
import javax.baja.ui.text.commands.DocumentStart;
import javax.baja.ui.text.commands.InsertText;
import javax.baja.ui.text.commands.LineEnd;
import javax.baja.ui.text.commands.LineStart;
import javax.baja.ui.text.commands.MoveDown;
import javax.baja.ui.text.commands.MoveLeft;
import javax.baja.ui.text.commands.MoveRight;
import javax.baja.ui.text.commands.MoveUp;
import javax.baja.ui.text.commands.WordLeft;
import javax.baja.ui.text.commands.WordRight;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.xml.XElem;

class Macro {
    BAccelerator acc;
    Phrase[] phrases;
    Prompt[] prompts;
    private static String[] validPhrases = new String[]{"text", "nl", "date", "up", "down", "left", "right", "docEnd", "docStart", "lineEnd", "lineStart", "wordLeft", "wordRight", "replace"};
    private static Set validPhraseSet = new HashSet();

    Macro(XElem m) {
        BAccelerator acc = BAccelerator.make(m.get("accelerator"));
        this.prompts = Macro.decodePrompts(m.elems("prompts"));
        HashMap<String, Prompt> promptMap = new HashMap<String, Prompt>();
        for (int i = 0; i < this.prompts.length; ++i) {
            promptMap.put(this.prompts[i].name, this.prompts[i]);
        }
        XElem[] phr = m.elems();
        ArrayList<Phrase> list = new ArrayList<Phrase>();
        for (int j = 0; j < phr.length; ++j) {
            String name = phr[j].name();
            if (validPhraseSet.contains(name)) {
                if (name.equals("text")) {
                    list.add(new TextPhrase(phr[j].get("val")));
                    continue;
                }
                if (name.equals("date")) {
                    list.add(new DatePhrase(phr[j].get("format")));
                    continue;
                }
                if (name.equals("nl")) {
                    list.add(new NewlinePhrase());
                    continue;
                }
                if (name.equals("replace")) {
                    list.add(new ReplacePhrase(phr[j].get("from"), phr[j].get("to"), phr[j].get("options", "")));
                    continue;
                }
                list.add(new NavPhrase(name));
                continue;
            }
            if (name.equals("prompts")) continue;
            Prompt p = (Prompt)promptMap.get(name);
            if (p == null) {
                System.out.println("WARNING: ignoring invalid macro phrase '" + name + "'.");
                continue;
            }
            list.add(new PromptPhrase(p));
        }
        this.acc = acc;
        this.phrases = list.toArray(new Phrase[list.size()]);
    }

    CompoundCommand makeCommand(BTextEditor editor) {
        ArrayList<Command> list = new ArrayList<Command>();
        if (!this.loadPrompts(editor)) {
            return null;
        }
        for (int i = 0; i < this.phrases.length; ++i) {
            Command cmd = this.phrases[i].makeCommand(editor);
            if (cmd == null) continue;
            list.add(cmd);
        }
        return new CompoundCommand((BWidget)editor, null, list.toArray(new Command[list.size()]));
    }

    private static Prompt[] decodePrompts(XElem[] defn) {
        if (defn.length > 0) {
            if (defn.length > 1) {
                System.out.println("WARNING: ignoring extra extraneous prompts definitions.");
            }
            XElem[] x = defn[0].elems();
            Prompt[] p = new Prompt[x.length];
            for (int i = 0; i < x.length; ++i) {
                p[i] = new Prompt(x[i].name(), x[i].get("default", null));
            }
            return p;
        }
        return new Prompt[0];
    }

    private boolean loadPrompts(BTextEditor editor) {
        int i;
        if (this.prompts.length == 0) {
            return true;
        }
        BGridPane pane = new BGridPane();
        BTextField[] fields = new BTextField[this.prompts.length];
        for (i = 0; i < this.prompts.length; ++i) {
            fields[i] = new BTextField();
            if (this.prompts[i].defaultVal != null) {
                fields[i].setText(this.prompts[i].defaultVal);
            }
            pane.add(null, (BValue)new BLabel(TextUtil.capitalize((String)(this.prompts[i].name + ":"))));
            pane.add(null, (BValue)fields[i]);
        }
        if (BDialog.open(editor, null, pane, 3) == 2) {
            return false;
        }
        for (i = 0; i < this.prompts.length; ++i) {
            this.prompts[i].val = fields[i].getText();
        }
        return true;
    }

    static {
        for (int i = 0; i < validPhrases.length; ++i) {
            validPhraseSet.add(validPhrases[i]);
        }
    }

    private static class NavPhrase
    extends Phrase {
        private String name;

        private NavPhrase(String name) {
            this.name = name;
        }

        Command makeCommand(BTextEditor editor) {
            if (this.name.equals("up")) {
                return new MoveUp(editor);
            }
            if (this.name.equals("down")) {
                return new MoveDown(editor);
            }
            if (this.name.equals("left")) {
                return new MoveLeft(editor);
            }
            if (this.name.equals("right")) {
                return new MoveRight(editor);
            }
            if (this.name.equals("docEnd")) {
                return new DocumentEnd(editor);
            }
            if (this.name.equals("docStart")) {
                return new DocumentStart(editor);
            }
            if (this.name.equals("lineEnd")) {
                return new LineEnd(editor);
            }
            if (this.name.equals("lineStart")) {
                return new LineStart(editor);
            }
            if (this.name.equals("wordLeft")) {
                return new WordLeft(editor);
            }
            if (this.name.equals("wordRight")) {
                return new WordRight(editor);
            }
            throw new IllegalStateException();
        }
    }

    private static class ReplacePhrase
    extends Phrase {
        private String from;
        private String to;
        private String options;
        private Map promptMap;

        private ReplacePhrase(String from, String to, String options) {
            this.from = from;
            this.to = to;
            this.options = options;
        }

        Command makeCommand(BTextEditor editor) {
            String fromClipBoard = Clipboard.getDefault().getContents().getData(TransferFormat.string).toString();
            String toPaste = TextUtil.replace((String)fromClipBoard, (String)this.from, (String)this.to);
            if (this.options != null && this.options.indexOf("trimRight") > -1) {
                toPaste = TextUtil.trimRight((String)toPaste);
            }
            if (this.options != null && this.options.indexOf("clipBoard") > -1) {
                Clipboard.getDefault().setContents(TransferEnvelope.make(toPaste));
                return ReplacePhrase.makeInsert(editor, "");
            }
            return ReplacePhrase.makeInsert(editor, toPaste);
        }
    }

    private static class NewlinePhrase
    extends Phrase {
        private NewlinePhrase() {
        }

        Command makeCommand(BTextEditor editor) {
            return NewlinePhrase.makeInsert(editor, "\n" + TextUtil.getSpaces((int)editor.getController().columnForNewline()));
        }
    }

    private static class DatePhrase
    extends Phrase {
        private String format;

        private DatePhrase(String format) {
            this.format = format;
        }

        Command makeCommand(BTextEditor editor) {
            return DatePhrase.makeInsert(editor, new SimpleDateFormat(this.format).format(new Date(System.currentTimeMillis())));
        }
    }

    private static class PromptPhrase
    extends Phrase {
        private Prompt prompt;

        private PromptPhrase(Prompt prompt) {
            this.prompt = prompt;
        }

        Command makeCommand(BTextEditor editor) {
            return PromptPhrase.makeInsert(editor, this.prompt.val);
        }
    }

    private static class TextPhrase
    extends Phrase {
        private String val;

        private TextPhrase(String val) {
            this.val = val;
        }

        Command makeCommand(BTextEditor editor) {
            return TextPhrase.makeInsert(editor, this.val);
        }
    }

    private static abstract class Phrase {
        private Phrase() {
        }

        abstract Command makeCommand(BTextEditor var1);

        static InsertText makeInsert(BTextEditor editor, String text) {
            if (text == null || text.length() == 0) {
                return null;
            }
            return new InsertText(editor, text);
        }
    }

    static class Prompt {
        private String name;
        private String defaultVal;
        private String val;

        Prompt(String name, String defaultVal) {
            this.name = name;
            this.defaultVal = defaultVal;
            this.val = null;
        }
    }
}

