/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import javax.baja.ui.BWidget;
import javax.baja.ui.text.BTextEditor;

class Blinker
extends Thread {
    private static Blinker blinker;
    private BTextEditor widget;
    private boolean isAlive;
    private boolean visible;

    static synchronized void startBlinking(BTextEditor widget) {
        Blinker.stopBlinking();
        blinker = new Blinker(widget);
        blinker.start();
    }

    static synchronized void stopBlinking() {
        if (blinker != null) {
            Blinker.blinker.isAlive = false;
            Blinker.blinker.widget = null;
            blinker = null;
        }
    }

    static synchronized void pauseBlinking() {
        if (blinker != null) {
            blinker.interrupt();
        }
    }

    static BWidget getBlinkingWidget() {
        Blinker b = blinker;
        if (b == null) {
            return null;
        }
        return b.widget;
    }

    private Blinker(BTextEditor widget) {
        super("Ui:CaretBlinker");
        this.widget = widget;
        this.isAlive = true;
    }

    public void run() {
        while (this.isAlive) {
            try {
                this.visible = !this.visible;
                this.widget.blinkCaret(this.visible);
                Blinker.sleep(500L);
            }
            catch (InterruptedException e) {
                try {
                    if (this.widget != null) {
                        this.widget.blinkCaret(true);
                    }
                    this.visible = false;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

