/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.io.File;
import java.util.Hashtable;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.Command;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Macro;
import javax.baja.ui.text.commands.MoveCommand;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BKeyBindings
extends BComponent {
    public static final Property moveUp = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Up"), null);
    public static final Property moveDown = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Down"), null);
    public static final Property moveLeft = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Left"), null);
    public static final Property moveRight = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Right"), null);
    public static final Property pageUp = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("PageUp"), null);
    public static final Property pageDown = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("PageDown"), null);
    public static final Property lineStart = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Home"), null);
    public static final Property lineEnd = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("End"), null);
    public static final Property documentStart = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Home"), null);
    public static final Property documentEnd = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+End"), null);
    public static final Property wordLeft = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Left"), null);
    public static final Property wordRight = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Right"), null);
    public static final Property cut = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+X"), null);
    public static final Property copy = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+C"), null);
    public static final Property paste = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+V"), null);
    public static final Property cut2 = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Shift+Delete"), null);
    public static final Property copy2 = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Insert"), null);
    public static final Property paste2 = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Shift+Insert"), null);
    public static final Property undo = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Z"), null);
    public static final Property redo = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Alt+Z"), null);
    public static final Property delete = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Delete"), null);
    public static final Property backspace = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Backspace"), null);
    public static final Property cutLine = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Y"), null);
    public static final Property deleteWord = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Delete"), null);
    public static final Property tabForward = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Tab"), null);
    public static final Property tabBack = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Shift+Tab"), null);
    public static final Property toggleSlashSlash = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+/"), null);
    public static final Property wordWrap = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+W"), null);
    public static final Property goTo = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+G"), null);
    public static final Property find = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("F5"), null);
    public static final Property findNext = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+F"), null);
    public static final Property findPrev = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+Shift+F"), null);
    public static final Property replace = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("F6"), null);
    public static final Property reloadMacros = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+M"), null);
    public static final Property selectAll = BKeyBindings.newProperty((int)0, (BValue)BAccelerator.make("Ctrl+A"), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$text$BKeyBindings == null ? (class$javax$baja$ui$text$BKeyBindings = BKeyBindings.class$("javax.baja.ui.text.BKeyBindings")) : class$javax$baja$ui$text$BKeyBindings));
    private static Hashtable macros = new Hashtable();
    private static final BIcon icon;
    Hashtable table;
    static /* synthetic */ Class class$javax$baja$ui$text$BKeyBindings;

    public BAccelerator getMoveUp() {
        return (BAccelerator)this.get(moveUp);
    }

    public void setMoveUp(BAccelerator v) {
        this.set(moveUp, (BValue)v, null);
    }

    public BAccelerator getMoveDown() {
        return (BAccelerator)this.get(moveDown);
    }

    public void setMoveDown(BAccelerator v) {
        this.set(moveDown, (BValue)v, null);
    }

    public BAccelerator getMoveLeft() {
        return (BAccelerator)this.get(moveLeft);
    }

    public void setMoveLeft(BAccelerator v) {
        this.set(moveLeft, (BValue)v, null);
    }

    public BAccelerator getMoveRight() {
        return (BAccelerator)this.get(moveRight);
    }

    public void setMoveRight(BAccelerator v) {
        this.set(moveRight, (BValue)v, null);
    }

    public BAccelerator getPageUp() {
        return (BAccelerator)this.get(pageUp);
    }

    public void setPageUp(BAccelerator v) {
        this.set(pageUp, (BValue)v, null);
    }

    public BAccelerator getPageDown() {
        return (BAccelerator)this.get(pageDown);
    }

    public void setPageDown(BAccelerator v) {
        this.set(pageDown, (BValue)v, null);
    }

    public BAccelerator getLineStart() {
        return (BAccelerator)this.get(lineStart);
    }

    public void setLineStart(BAccelerator v) {
        this.set(lineStart, (BValue)v, null);
    }

    public BAccelerator getLineEnd() {
        return (BAccelerator)this.get(lineEnd);
    }

    public void setLineEnd(BAccelerator v) {
        this.set(lineEnd, (BValue)v, null);
    }

    public BAccelerator getDocumentStart() {
        return (BAccelerator)this.get(documentStart);
    }

    public void setDocumentStart(BAccelerator v) {
        this.set(documentStart, (BValue)v, null);
    }

    public BAccelerator getDocumentEnd() {
        return (BAccelerator)this.get(documentEnd);
    }

    public void setDocumentEnd(BAccelerator v) {
        this.set(documentEnd, (BValue)v, null);
    }

    public BAccelerator getWordLeft() {
        return (BAccelerator)this.get(wordLeft);
    }

    public void setWordLeft(BAccelerator v) {
        this.set(wordLeft, (BValue)v, null);
    }

    public BAccelerator getWordRight() {
        return (BAccelerator)this.get(wordRight);
    }

    public void setWordRight(BAccelerator v) {
        this.set(wordRight, (BValue)v, null);
    }

    public BAccelerator getCut() {
        return (BAccelerator)this.get(cut);
    }

    public void setCut(BAccelerator v) {
        this.set(cut, (BValue)v, null);
    }

    public BAccelerator getCopy() {
        return (BAccelerator)this.get(copy);
    }

    public void setCopy(BAccelerator v) {
        this.set(copy, (BValue)v, null);
    }

    public BAccelerator getPaste() {
        return (BAccelerator)this.get(paste);
    }

    public void setPaste(BAccelerator v) {
        this.set(paste, (BValue)v, null);
    }

    public BAccelerator getCut2() {
        return (BAccelerator)this.get(cut2);
    }

    public void setCut2(BAccelerator v) {
        this.set(cut2, (BValue)v, null);
    }

    public BAccelerator getCopy2() {
        return (BAccelerator)this.get(copy2);
    }

    public void setCopy2(BAccelerator v) {
        this.set(copy2, (BValue)v, null);
    }

    public BAccelerator getPaste2() {
        return (BAccelerator)this.get(paste2);
    }

    public void setPaste2(BAccelerator v) {
        this.set(paste2, (BValue)v, null);
    }

    public BAccelerator getUndo() {
        return (BAccelerator)this.get(undo);
    }

    public void setUndo(BAccelerator v) {
        this.set(undo, (BValue)v, null);
    }

    public BAccelerator getRedo() {
        return (BAccelerator)this.get(redo);
    }

    public void setRedo(BAccelerator v) {
        this.set(redo, (BValue)v, null);
    }

    public BAccelerator getDelete() {
        return (BAccelerator)this.get(delete);
    }

    public void setDelete(BAccelerator v) {
        this.set(delete, (BValue)v, null);
    }

    public BAccelerator getBackspace() {
        return (BAccelerator)this.get(backspace);
    }

    public void setBackspace(BAccelerator v) {
        this.set(backspace, (BValue)v, null);
    }

    public BAccelerator getCutLine() {
        return (BAccelerator)this.get(cutLine);
    }

    public void setCutLine(BAccelerator v) {
        this.set(cutLine, (BValue)v, null);
    }

    public BAccelerator getDeleteWord() {
        return (BAccelerator)this.get(deleteWord);
    }

    public void setDeleteWord(BAccelerator v) {
        this.set(deleteWord, (BValue)v, null);
    }

    public BAccelerator getTabForward() {
        return (BAccelerator)this.get(tabForward);
    }

    public void setTabForward(BAccelerator v) {
        this.set(tabForward, (BValue)v, null);
    }

    public BAccelerator getTabBack() {
        return (BAccelerator)this.get(tabBack);
    }

    public void setTabBack(BAccelerator v) {
        this.set(tabBack, (BValue)v, null);
    }

    public BAccelerator getToggleSlashSlash() {
        return (BAccelerator)this.get(toggleSlashSlash);
    }

    public void setToggleSlashSlash(BAccelerator v) {
        this.set(toggleSlashSlash, (BValue)v, null);
    }

    public BAccelerator getWordWrap() {
        return (BAccelerator)this.get(wordWrap);
    }

    public void setWordWrap(BAccelerator v) {
        this.set(wordWrap, (BValue)v, null);
    }

    public BAccelerator getGoTo() {
        return (BAccelerator)this.get(goTo);
    }

    public void setGoTo(BAccelerator v) {
        this.set(goTo, (BValue)v, null);
    }

    public BAccelerator getFind() {
        return (BAccelerator)this.get(find);
    }

    public void setFind(BAccelerator v) {
        this.set(find, (BValue)v, null);
    }

    public BAccelerator getFindNext() {
        return (BAccelerator)this.get(findNext);
    }

    public void setFindNext(BAccelerator v) {
        this.set(findNext, (BValue)v, null);
    }

    public BAccelerator getFindPrev() {
        return (BAccelerator)this.get(findPrev);
    }

    public void setFindPrev(BAccelerator v) {
        this.set(findPrev, (BValue)v, null);
    }

    public BAccelerator getReplace() {
        return (BAccelerator)this.get(replace);
    }

    public void setReplace(BAccelerator v) {
        this.set(replace, (BValue)v, null);
    }

    public BAccelerator getReloadMacros() {
        return (BAccelerator)this.get(reloadMacros);
    }

    public void setReloadMacros(BAccelerator v) {
        this.set(reloadMacros, (BValue)v, null);
    }

    public BAccelerator getSelectAll() {
        return (BAccelerator)this.get(selectAll);
    }

    public void setSelectAll(BAccelerator v) {
        this.set(selectAll, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Command eventToCommand(BTextEditor editor, BKeyEvent event) {
        Command command;
        int modifiers;
        int keyCode;
        BAccelerator acc;
        Property prop;
        if (this.table == null) {
            this.updateTable();
        }
        if ((prop = (Property)this.table.get((Object)(acc = BAccelerator.make(keyCode = event.getKeyCode(), modifiers = event.getModifiers())))) != null) {
            return editor.getCommandFactory().make(prop.getName());
        }
        Macro macro = (Macro)macros.get((Object)acc);
        if (macro != null) {
            return macro.makeCommand(editor);
        }
        if (event.isShiftDown() && (prop = (Property)this.table.get((Object)(acc = BAccelerator.make(keyCode, modifiers & 0xFFFFFFFE)))) != null && (command = editor.getCommandFactory().make(prop.getName())) instanceof MoveCommand) {
            MoveCommand moveCommand = (MoveCommand)command;
            moveCommand.setShiftDown(true);
            return moveCommand;
        }
        return null;
    }

    void updateTable() {
        this.table = new Hashtable();
        SlotCursor c = this.getProperties();
        while (c.next()) {
            this.table.put(c.get(), c.property());
        }
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        this.updateTable();
    }

    public static void loadMacros() {
        try {
            macros.clear();
            File file = new File(Sys.getUserHome(), "macros.xml");
            if (file.exists()) {
                XElem elem = XParser.make((File)file).parse();
                XElem[] mcrs = elem.elems();
                for (int i = 0; i < mcrs.length; ++i) {
                    Macro m = new Macro(mcrs[i]);
                    macros.put(m.acc, m);
                }
            }
        }
        catch (Exception e) {
            System.out.print("ERROR: Cannot initialize macros");
            e.printStackTrace();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BKeyBindings.loadMacros();
        icon = BIcon.std((String)"keyboardKey.png");
    }
}

