/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table.binding;

import com.tridium.sys.Nre;
import java.util.HashMap;
import java.util.Map;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.ui.BBinding;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.binding.BTableBinding;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BoundTableModel
extends TableModel {
    private Row[] rows;
    private Map cols;
    private Object monitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRowCount() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.rows == null) {
                return 0;
            }
            return this.rows.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getColumnCount() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.cols == null) {
                return 0;
            }
            return this.cols.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnName(int col) {
        Object object = this.monitor;
        synchronized (object) {
            ColumnInfo colInfo = (ColumnInfo)this.cols.get(new Integer(col));
            return colInfo.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueAt(int row, int col) {
        Object object = this.monitor;
        synchronized (object) {
            return this.rows[row].get(row, col);
        }
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sortByColumn(int col, boolean ascending) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] keys = new Object[this.rows.length];
            int i = 0;
            while (true) {
                if (i >= keys.length) {
                    SortUtil.sort((Object[])keys, (Object[])this.rows, (boolean)ascending);
                    return;
                }
                keys[i] = this.rows[i].get(i, col);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void rebind() {
        BBinding[] bindings = this.getTable().getBindings();
        BasicContext cx = null;
        int n = 0;
        RowSet[] sets = new RowSet[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            BTableBinding binding;
            if (bindings[i] instanceof BTableBinding && (binding = (BTableBinding)bindings[i]).isBound()) {
                BICollection c = (BICollection)binding.get();
                if (cx == null) {
                    cx = new BasicContext(binding.getTarget().getUser(), binding.getTarget().getLanguage());
                }
                sets[n++] = new RowSet(c.toTable());
            }
            ++i;
        }
        int rowCount = 0;
        int i2 = 0;
        while (i2 < n) {
            RowSet set = sets[i2];
            set.offset = rowCount;
            set.size = set.table.size();
            rowCount += set.size;
            ++i2;
        }
        Row[] rows = new Row[rowCount];
        int i3 = 0;
        while (i3 < n) {
            RowSet set = sets[i3];
            int j = 0;
            while (j < set.size) {
                rows[set.offset + j] = new Row(set, j);
                ++j;
            }
            ++i3;
        }
        HashMap<String, ColumnInfo> colsByName = new HashMap<String, ColumnInfo>();
        HashMap<Integer, ColumnInfo> colsByIndex = new HashMap<Integer, ColumnInfo>();
        int i4 = 0;
        while (i4 < n) {
            ColumnList colList = sets[i4].table.getColumns();
            int j = 0;
            while (j < colList.size()) {
                Column col = colList.get(j);
                String name = col.getName();
                if (colsByName.get(name) == null) {
                    ColumnInfo colInfo = new ColumnInfo(col, colsByName.size(), (Context)cx);
                    colsByName.put(name, colInfo);
                    colsByIndex.put(new Integer(colInfo.index), colInfo);
                }
                ++j;
            }
            ++i4;
        }
        int colCount = colsByName.size();
        int i5 = 0;
        while (i5 < n) {
            RowSet set = sets[i5];
            set.colMap = new ColumnInfo[colCount];
            ColumnList colList = sets[i5].table.getColumns();
            int j = 0;
            while (j < colList.size()) {
                ColumnInfo colInfo;
                Column column = colList.get(j);
                String name = column.getName();
                set.colMap[((ColumnInfo)colInfo).index] = colInfo = (ColumnInfo)colsByName.get(name);
                ++j;
            }
            ++i5;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.rows = rows;
            this.cols = colsByIndex;
        }
        this.updateTable();
    }

    private final /* synthetic */ void this() {
        this.monitor = new Object();
    }

    public BoundTableModel() {
        this.this();
    }

    private static final class ColumnInfo {
        private int index;
        private Column col;
        private Context cx;

        final String getDisplayName() {
            BUnit unit;
            String displayName = this.col.getDisplayName(this.cx);
            BFacets facets = this.col.getFacets();
            if (facets != null && !facets.isNull() && (unit = (BUnit)facets.get("units")) != null && !unit.isNull()) {
                int convert = Nre.unitConversion;
                if ((convert = facets.geti("unitConversion", convert)) != 0) {
                    unit = BUnitConversion.make((int)convert).getDesiredUnit(unit);
                }
                displayName = displayName + " (" + unit.getSymbol() + ')';
            }
            return displayName;
        }

        ColumnInfo(Column col, int index, Context cx) {
            this.col = col;
            this.index = index;
            this.cx = new BasicContext(cx, col.getFacets());
        }
    }

    private static class Row {
        RowSet set;
        int rowIndex;

        public final Object get(int modelRow, int modelCol) {
            ColumnInfo tableColInfo = this.set.colMap[modelCol];
            if (tableColInfo == null) {
                return "";
            }
            BObject obj = this.set.table.get(this.rowIndex, tableColInfo.col);
            if (obj != null) {
                return obj.toString(tableColInfo.cx);
            }
            return obj;
        }

        Row(RowSet set, int rowIndex) {
            this.set = set;
            this.rowIndex = rowIndex;
        }
    }

    private static class RowSet {
        BITable table;
        int size;
        int offset;
        ColumnInfo[] colMap;

        RowSet(BITable table) {
            this.table = table;
        }
    }
}

