/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;

public class TableCellRenderer
extends BTable.TableSupport {
    private RectGeom clip = new RectGeom();

    public BBrush getForeground(Cell cell) {
        return Theme.table().getTextBrush(this.getTable());
    }

    public BBrush getBackground(Cell cell) {
        return null;
    }

    public BFont getFont(Cell cell) {
        return Theme.table().getCellFont(this.getTable());
    }

    public BBrush getSelectionForeground(Cell cell) {
        return Theme.table().getSelectionForeground(this.getTable());
    }

    public BBrush getSelectionBackground(Cell cell) {
        return Theme.table().getSelectionBackground(this.getTable());
    }

    public double getCellHeight() {
        return Math.max(Theme.table().getCellHeight(), 16.0);
    }

    public double getPreferredCellWidth(Cell cell) {
        String s = this.getCellText(cell);
        double w = this.getFont(cell).width(s) + 12.0;
        if (cell.column == 0 && this.getTable().getModel().getRowIcon(cell.row) != null) {
            w += 20.0;
        }
        return w;
    }

    public IGeom getClip(Cell cell) {
        this.clip.set(0.0, 0.0, cell.width, cell.height);
        return this.clip;
    }

    public String getCellText(Cell cell) {
        return String.valueOf(cell.value);
    }

    public void paintCell(Graphics g, Cell cell) {
        BImage icon;
        TableModel model = this.getTable().getModel();
        this.paintCellBackground(g, cell);
        double x = 2.0;
        double y = (cell.height - 16.0) / 2.0;
        if (cell.column == 0 && (icon = model.getRowIcon(cell.row)) != null) {
            g.drawImage(icon, x, y);
            x += 20.0;
        }
        String s = this.getCellText(cell);
        BFont font = this.getFont(cell);
        switch (model.getColumnAlignment(cell.column).getOrdinal()) {
            case 2: {
                x = cell.width - 2.0 - font.width(s);
                break;
            }
            case 1: {
                x = (cell.width - font.width(s)) / 2.0;
            }
        }
        g.setFont(font);
        if (cell.selected) {
            g.setBrush(this.getSelectionForeground(cell));
        } else {
            g.setBrush(this.getForeground(cell));
        }
        g.drawString(s, x, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
    }

    protected void paintCellBackground(Graphics g, Cell cell) {
        if (cell.selected) {
            BBrush bg = this.getSelectionBackground(cell);
            if (bg != null && !bg.isNull()) {
                g.setBrush(bg);
                g.fillRect(0.0, 0.0, cell.width, cell.height);
            }
            g.setBrush(this.getSelectionForeground(cell));
        } else {
            BBrush bg = this.getBackground(cell);
            if (bg != null && !bg.isNull()) {
                g.setBrush(bg);
                g.fillRect(0.0, 0.0, cell.width, cell.height);
            }
            g.setBrush(this.getForeground(cell));
        }
        g.setFont(this.getFont(cell));
    }

    public static class Cell {
        public int row;
        public int column;
        public Object value;
        public double width;
        public double height;
        public boolean selected;
    }
}

